/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import xzeroair.trinkets.capabilities.CapabilityBase;

public class CapabilityProviderBase<Handler extends CapabilityBase>
implements ICapabilitySerializable<NBTTagCompound> {
    private final Capability<?> capability;
    private final Handler handler;

    public CapabilityProviderBase(Capability<?> capability, Handler handler) {
        this.capability = capability;
        this.handler = handler;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == this.capability;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == this.capability) {
            return (T)this.handler;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = ((CapabilityBase)this.handler).getTag();
        ((CapabilityBase)this.handler).saveToNBT(tag);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        ((CapabilityBase)this.handler).loadFromNBT(nbt);
    }
}

