/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities.race;

import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.api.events.TransformationEvent;
import xzeroair.trinkets.attributes.JumpAttribute;
import xzeroair.trinkets.capabilities.CapabilityBase;
import xzeroair.trinkets.capabilities.race.KeybindHandler;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.SyncRaceDataPacket;
import xzeroair.trinkets.races.EntityRace;
import xzeroair.trinkets.races.EntityRaceHelper;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.human.RaceHuman;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.IAbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.util.compat.artemislib.SizeAttribute;
import xzeroair.trinkets.util.helpers.ColorHelper;
import xzeroair.trinkets.util.helpers.EyeHeightHandler;

public class EntityProperties
extends CapabilityBase<EntityProperties, EntityLivingBase> {
    protected int size = 100;
    protected int width = 100;
    protected int height = 100;
    protected int target = 100;
    protected int targetWidth = 100;
    protected int targetHeight = 100;
    protected float defaultWidth;
    protected float defaultHeight;
    protected boolean first_login = true;
    protected boolean login = true;
    protected boolean changed = false;
    protected boolean sync = false;
    protected EntityRace previous;
    protected EntityRace original = EntityRace.getByNameOrId("xat:none");
    protected EntityRace imbued;
    protected EntityRace current;
    protected boolean traitShown = true;
    protected String traitColor = "16777215";
    protected ColorHelper color;
    protected boolean isFake = false;
    protected KeybindHandler keybindHandler;
    protected EntityRacePropertiesHandler properties;
    protected AbilityHandler abilities;
    protected Map<String, ItemStack> equippedItems;
    protected Map<Integer, ItemStack> equippedBaubles;
    protected Map<Integer, ItemStack> equippedTrinkets;
    private float stepHeightPrev = 0.6f;
    private boolean onGround;

    public EntityProperties(EntityLivingBase e) {
        super(e);
        this.previous = EntityRace.getByNameOrId("xat:none");
        this.imbued = EntityRace.getByNameOrId("xat:none");
        this.current = EntityRace.getByNameOrId("xat:none");
        this.properties = new RaceHuman(e, this);
        this.color = new ColorHelper().setColor(this.getTraitColor());
        this.equippedItems = new TreeMap<String, ItemStack>();
        this.abilities = new AbilityHandler(e);
        this.keybindHandler = new KeybindHandler();
    }

    @Override
    public NBTTagCompound getTag() {
        return super.getTag();
    }

    public void parseEquipped() {
        if (this.object instanceof EntityPlayer) {
            TrinketHelper.getEquippedList(this.equippedItems, (EntityPlayer)this.object);
        }
    }

    public Map<String, ItemStack> getEquippedItems() {
        return this.equippedItems;
    }

    public AbilityHandler getAbilityHandler() {
        return this.abilities;
    }

    @SideOnly(value=Side.CLIENT)
    public void onRender(RenderLivingBase renderer, boolean isSlim, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.properties.doRenderLayer(renderer, this.isFake, isSlim, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
    }

    public void onUpdatePre() {
        this.onGround = ((EntityLivingBase)this.object).field_70122_E;
    }

    @Override
    public void onUpdate() {
        if (this.object instanceof EntityPlayer && !((EntityLivingBase)this.object).func_130014_f_().field_72995_K) {
            ((EntityLivingBase)this.object).field_70122_E = this.onGround;
        }
        this.parseEquipped();
        this.abilities.accessoriesCheck(this.equippedItems);
        this.abilities.cleanUp();
        this.color = this.color.setColor(this.getTraitColor());
        if (!(this.object instanceof EntityPlayer)) {
            if (this.isLogin()) {
                IAttributeInstance stepheight = ((EntityLivingBase)this.object).func_110140_aT().func_111151_a(JumpAttribute.stepHeight);
                if (stepheight != null) {
                    stepheight.func_111128_a((double)((EntityLivingBase)this.object).field_70138_W);
                }
                this.setDefaultHeight(((EntityLivingBase)this.object).field_70131_O);
                this.setDefaultWidth(((EntityLivingBase)this.object).field_70130_N);
                this.setLogin(false);
            }
        } else {
            this.setDefaultHeight(1.8f);
            this.setDefaultWidth(0.6f);
        }
        this.stepHeightHandler();
        EntityRace race = this.getEntityRace();
        TransformationEvent.RaceChangedEvent rc = new TransformationEvent.RaceChangedEvent((EntityLivingBase)this.object, this, this.current, race);
        if (!MinecraftForge.EVENT_BUS.post((Event)rc) && rc.raceChanged()) {
            EntityRace newRace = rc.getNewRace();
            if (newRace == null) {
                newRace = EntityRace.getByNameOrId("xat:none");
            }
            SizeAttribute artemisLib = new SizeAttribute((EntityLivingBase)this.object, 0.0, 0.0, 0);
            artemisLib.removeModifiers();
            this.properties.onTransformEnd();
            IAttributeInstance attribute = ((EntityLivingBase)this.object).func_110140_aT().func_111151_a(JumpAttribute.stepHeight);
            if (attribute != null && (double)((EntityLivingBase)this.object).field_70138_W != attribute.func_111125_b()) {
                ((EntityLivingBase)this.object).field_70138_W = (float)attribute.func_111125_b();
            }
            TransformationEvent.endTransformationEvent end = new TransformationEvent.endTransformationEvent((EntityLivingBase)this.object, this, this.current, this.previous);
            MinecraftForge.EVENT_BUS.post((Event)end);
            this.previous = end.getPreviousRace();
            this.current = newRace;
            this.properties = newRace.getRaceHandler((EntityLivingBase)this.object);
            this.properties.onTransform();
            this.setTargetSize(newRace.getRaceSize());
            TransformationEvent.startTransformationEvent event = new TransformationEvent.startTransformationEvent((EntityLivingBase)this.object, this, this.current);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.sync = true;
        }
        this.properties.onTick();
        this.sizeHandler();
        if (this.sync) {
            this.sendInformationToAll();
            this.sync = false;
        }
        this.abilities.tickAbilities((EntityLivingBase)this.object);
    }

    public KeybindHandler getKeybindHandler() {
        return this.keybindHandler;
    }

    private EntityRace getEntityRace() {
        EntityRace potionRace = EntityRaceHelper.getAttributeRace((EntityLivingBase)this.object);
        EntityRace TrinketRace = EntityRaceHelper.getTrinketRace((EntityLivingBase)this.object);
        if (potionRace != null && !potionRace.equals(EntityRaces.none)) {
            this.setFake(true);
            return potionRace;
        }
        if (TrinketRace != null && !TrinketRace.equals(EntityRaces.none)) {
            this.setFake(true);
            return TrinketRace;
        }
        if (this.imbued != null && !this.imbued.equals(EntityRaces.none)) {
            this.setFake(false);
            return this.imbued;
        }
        this.setFake(false);
        if (this.original == null) {
            this.original = EntityRace.getByNameOrId("xat:none");
        }
        return this.original;
    }

    private void stepHeightHandler() {
        IAttributeInstance attribute = ((EntityLivingBase)this.object).func_110140_aT().func_111151_a(JumpAttribute.stepHeight);
        if (attribute != null && !attribute.func_111122_c().isEmpty()) {
            double f = attribute.func_111126_e();
            float defaultStepHeight = (float)attribute.func_111125_b();
            float result = (float)f;
            float step = ((EntityLivingBase)this.object).field_70138_W;
            ((EntityLivingBase)this.object).field_70138_W = defaultStepHeight;
            if (step - ((EntityLivingBase)this.object).field_70138_W == 0.0f) {
                ((EntityLivingBase)this.object).field_70138_W = result;
                this.stepHeightPrev = defaultStepHeight;
            } else if (step - ((EntityLivingBase)this.object).field_70138_W - result == -defaultStepHeight) {
                ((EntityLivingBase)this.object).field_70138_W = result;
                this.stepHeightPrev = defaultStepHeight;
            } else {
                float stepP = this.stepHeightPrev;
                this.stepHeightPrev = step;
                if (result - defaultStepHeight + step == result - defaultStepHeight + stepP) {
                    ((EntityLivingBase)this.object).field_70138_W = result - defaultStepHeight + this.stepHeightPrev;
                }
            }
        }
    }

    private void sizeHandler() {
        int defaultSize = 100;
        if (this.isTransforming() || this.isTransformed()) {
            if (this.getSize() > this.getTargetSize()) {
                this.setSize(this.getSize() - 1);
            }
            if (this.getSize() < this.getTargetSize()) {
                this.setSize(this.getSize() + 1);
            }
            if (this.object instanceof EntityPlayer) {
                EyeHeightHandler.eyeHeightHandler((EntityPlayer)this.object, this);
            }
        }
    }

    public void sendInformationToAll() {
        if (!((EntityLivingBase)this.object).func_130014_f_().field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            this.saveToNBT(tag);
            NetworkHandler.sendToAll(new SyncRaceDataPacket((EntityLivingBase)this.object, tag));
        }
    }

    public void sendInformationToPlayer(EntityLivingBase receiver) {
        if (!((EntityLivingBase)this.object).func_130014_f_().field_72995_K && receiver instanceof EntityPlayerMP) {
            NBTTagCompound tag = new NBTTagCompound();
            this.saveToNBT(tag);
            this.saveAbilitiesToNBT(tag);
            NetworkHandler.sendTo(new SyncRaceDataPacket((EntityLivingBase)this.object, tag), (EntityPlayerMP)receiver);
        }
    }

    public void sendInformationToPlayer(EntityLivingBase receiver, NBTTagCompound tag) {
        if (!((EntityLivingBase)this.object).func_130014_f_().field_72995_K && receiver instanceof EntityPlayerMP) {
            NetworkHandler.sendTo(new SyncRaceDataPacket((EntityLivingBase)this.object, tag), (EntityPlayerMP)receiver);
        }
    }

    public void sendInformationToTracking() {
        World world = ((EntityLivingBase)this.object).func_130014_f_();
        if (!world.field_72995_K && world instanceof WorldServer) {
            WorldServer w = (WorldServer)world;
            NBTTagCompound tag = new NBTTagCompound();
            this.saveToNBT(tag);
            this.saveAbilitiesToNBT(tag);
            NetworkHandler.sendToClients(w, ((EntityLivingBase)this.object).func_180425_c(), new SyncRaceDataPacket((EntityLivingBase)this.object, tag));
        }
    }

    public void sendInformationToServer() {
        if (((EntityLivingBase)this.object).func_130014_f_().field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            this.saveToNBT(tag);
            this.saveAbilitiesToNBT(tag);
            NetworkHandler.sendToServer(new SyncRaceDataPacket((EntityLivingBase)this.object, tag));
        }
    }

    public boolean isNormalHeight() {
        return this.size == 100;
    }

    public boolean isTransforming() {
        return this.getSize() != this.getTargetSize();
    }

    public boolean isTransformed() {
        return this.current.equals(EntityRaces.none) ? false : this.getSize() == this.getTargetSize();
    }

    public boolean showTraits() {
        return this.traitShown;
    }

    public void setTraitsShown(boolean shown) {
        this.traitShown = shown;
    }

    public String getTraitColor() {
        return this.traitColor;
    }

    public ColorHelper getTraitColorHandler() {
        return this.color;
    }

    public void setTraitColor(String color) {
        this.traitColor = color;
    }

    public EntityRacePropertiesHandler getRaceProperties() {
        return this.properties;
    }

    public EntityRace getPreviousRace() {
        return this.previous;
    }

    public EntityRace setPreviousRace(EntityRace race) {
        this.previous = race;
        return this.previous;
    }

    public EntityRace getOriginalRace() {
        return this.original;
    }

    public EntityRace getCurrentRace() {
        return this.current;
    }

    public EntityRace getImbuedRace() {
        return this.imbued;
    }

    public EntityRace setImbuedRace(EntityRace race) {
        this.imbued = race != null ? race : EntityRace.getByNameOrId("xat:none");
        return this.imbued;
    }

    public EntityRace setOriginalRace(EntityRace race) {
        this.original = race != null ? race : EntityRace.getByNameOrId("xat:none");
        return this.original;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getTargetSize() {
        return this.target;
    }

    public void setTargetSize(int target) {
        this.target = target;
    }

    public float getHeight() {
        return this.getDefaultHeight() * ((float)this.getSize() * 0.01f);
    }

    public float getWidth() {
        return this.getDefaultWidth() * ((float)this.getSize() * 0.01f);
    }

    public float getDefaultWidth() {
        return this.defaultWidth;
    }

    public void setDefaultWidth(float defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public float getDefaultHeight() {
        return this.defaultHeight;
    }

    public void setDefaultHeight(float defaultHeight) {
        this.defaultHeight = defaultHeight;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }

    public boolean isFirstLogin() {
        return this.first_login;
    }

    public void setFirstLogin(boolean firstLogin) {
        this.first_login = firstLogin;
    }

    public boolean isFake() {
        return this.isFake;
    }

    public void setFake(boolean isFake) {
        this.isFake = isFake;
    }

    public void scheduleResync() {
        this.sync = true;
    }

    @Override
    public void copyFrom(EntityProperties source, boolean wasDeath, boolean keepInv) {
        this.login = source.login;
        this.first_login = source.first_login;
        this.defaultWidth = source.defaultWidth;
        this.defaultHeight = source.defaultHeight;
        this.original = source.original;
        this.imbued = source.imbued;
        if (wasDeath) {
            if (keepInv) {
                this.size = source.size;
                this.previous = source.previous;
            } else {
                boolean isNormal = this.imbued.equals(EntityRaces.none);
                if (!isNormal) {
                    this.size = this.imbued.getRaceSize();
                }
                this.previous = source.current;
            }
        } else {
            this.size = source.size;
            this.target = source.target;
            this.previous = source.previous;
        }
        this.traitColor = source.traitColor;
        this.traitShown = source.traitShown;
        this.getRaceProperties().copyFrom(source.getRaceProperties(), wasDeath, keepInv);
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        compound.func_74768_a("size", this.size);
        compound.func_74768_a("target", this.target);
        compound.func_74778_a("original_race", this.original.getName());
        compound.func_74778_a("imbued_race", this.imbued.getName());
        compound.func_74778_a("prev_race", this.previous.getName());
        compound.func_74757_a("trait_shown", this.traitShown);
        compound.func_74778_a("trait_color", this.traitColor);
        compound.func_74776_a("default_height", this.defaultHeight);
        compound.func_74776_a("default_width", this.defaultWidth);
        compound.func_74757_a("login", this.login);
        compound.func_74757_a("first_login", this.first_login);
        compound.func_74757_a("fake", this.isFake);
        this.getRaceProperties().savedNBTData(compound);
    }

    public void saveAbilitiesToNBT(NBTTagCompound compound) {
        for (Map.Entry<IAbilityInterface, AbilityHandler.Storage> ability : this.abilities.getAbilities().entrySet()) {
            try {
                IAbilityHandler handler;
                if (ability.getValue() == null || (handler = ability.getValue().handler()) == null) continue;
                handler.saveStorage(compound);
            }
            catch (Exception e) {
                Trinkets.log.error("Error when saving ability:" + ability.getKey().getName());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("first_login")) {
            this.first_login = false;
        }
        if (compound.func_74764_b("login")) {
            this.login = compound.func_74767_n("login");
        }
        if (compound.func_74764_b("size")) {
            this.size = compound.func_74762_e("size");
        }
        if (compound.func_74764_b("target")) {
            this.target = compound.func_74762_e("target");
        }
        if (compound.func_74764_b("original_race")) {
            EntityRace originalRace = EntityRace.getByNameOrId("xat:" + compound.func_74779_i("original_race"));
            this.original = originalRace == null ? EntityRace.getByNameOrId("xat:none") : originalRace;
        }
        if (compound.func_74764_b("imbued_race")) {
            EntityRace imbuedRace = EntityRace.getByNameOrId("xat:" + compound.func_74779_i("imbued_race"));
            this.imbued = imbuedRace == null ? EntityRace.getByNameOrId("xat:none") : imbuedRace;
        }
        if (compound.func_74764_b("prev_race")) {
            EntityRace previousRace = EntityRace.getByNameOrId("xat:" + compound.func_74779_i("prev_race"));
            this.previous = previousRace == null ? EntityRace.getByNameOrId("xat:none") : previousRace;
        }
        if (compound.func_74764_b("trait_shown")) {
            this.traitShown = compound.func_74767_n("trait_shown");
        }
        if (compound.func_74764_b("trait_color")) {
            this.traitColor = compound.func_74779_i("trait_color");
        }
        if (compound.func_74764_b("default_height")) {
            this.defaultHeight = compound.func_74760_g("default_height");
        }
        if (compound.func_74764_b("default_width")) {
            this.defaultWidth = compound.func_74760_g("default_width");
        }
        if (compound.func_74764_b("fake")) {
            this.isFake = compound.func_74767_n("fake");
        }
        this.getRaceProperties().loadNBTData(compound);
    }

    public void loadAbilitiesFromNBT(NBTTagCompound compound) {
        for (Map.Entry<IAbilityInterface, AbilityHandler.Storage> ability : this.abilities.getAbilities().entrySet()) {
            try {
                IAbilityHandler handler;
                if (ability.getValue() == null || (handler = ability.getValue().handler()) == null) continue;
                handler.loadStorage(compound);
            }
            catch (Exception e) {
                Trinkets.log.error("Error when loading ability:" + ability.getKey().getName());
                e.printStackTrace();
            }
        }
    }
}

