/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities.race;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.client.keybinds.KeyHandler;
import xzeroair.trinkets.traits.abilities.IAbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IMovementAbility;

public class KeybindHandler {
    Map<String, KeyHandler> storage = new HashMap<String, KeyHandler>();

    public KeybindHandler() {
        this.addKeyBind("Left");
        this.addKeyBind("Right");
        this.addKeyBind("Forward");
        this.addKeyBind("Back");
        this.addKeyBind("Jump");
        this.addKeyBind("Sneak");
    }

    public void addKeyBind(String key) {
        if (!this.storage.containsKey(key)) {
            this.storage.put(key, new KeyHandler());
        }
    }

    public KeyHandler getKeyHandler(String key) {
        if (this.storage.containsKey(key)) {
            return this.storage.get(key);
        }
        KeyHandler kh = new KeyHandler();
        this.storage.put(key, kh);
        return kh;
    }

    public boolean pressKey(Entity entity, String key, int state) {
        switch (key) {
            case "Left": {
                return this.left(entity, state);
            }
            case "Right": {
                return this.right(entity, state);
            }
            case "Forward": {
                return this.forward(entity, state);
            }
            case "Backward": {
                return this.back(entity, state);
            }
            case "Jump": {
                return this.jump(entity, state);
            }
            case "Sneak": {
                return this.sneak(entity, state);
            }
        }
        return false;
    }

    public boolean left(Entity entity, String ability, int state) {
        IAbilityInterface kbAbility;
        EntityProperties cap = Capabilities.getEntityRace(entity);
        if (cap != null && (kbAbility = cap.getAbilityHandler().getAbilityByName(ability)) != null) {
            try {
                IAbilityHandler handler = cap.getAbilityHandler().getAbilityInstance(kbAbility);
                if (handler != null && handler instanceof IMovementAbility) {
                    IMovementAbility iMovementAbility = (IMovementAbility)handler;
                }
            }
            catch (Exception e) {
                Trinkets.log.error("Trinkets had an Error with Ability:" + kbAbility.getName());
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean left(Entity entity, int state) {
        EntityProperties cap = Capabilities.getEntityRace(entity);
        if (cap != null) {
            for (IAbilityInterface ability : cap.getAbilityHandler().getAbilitiesList()) {
                try {
                    IMovementAbility keybind;
                    IAbilityHandler handler = cap.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IMovementAbility) || (keybind = (IMovementAbility)handler).left(entity, state)) continue;
                    return false;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public boolean right(Entity entity, int state) {
        EntityProperties cap = Capabilities.getEntityRace(entity);
        if (cap != null) {
            for (IAbilityInterface ability : cap.getAbilityHandler().getAbilitiesList()) {
                try {
                    IMovementAbility keybind;
                    IAbilityHandler handler = cap.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IMovementAbility) || (keybind = (IMovementAbility)handler).right(entity, state)) continue;
                    return false;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public boolean forward(Entity entity, int state) {
        EntityProperties cap = Capabilities.getEntityRace(entity);
        if (cap != null) {
            for (IAbilityInterface ability : cap.getAbilityHandler().getAbilitiesList()) {
                try {
                    IMovementAbility keybind;
                    IAbilityHandler handler = cap.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IMovementAbility) || (keybind = (IMovementAbility)handler).forward(entity, state)) continue;
                    return false;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public boolean back(Entity entity, int state) {
        EntityProperties cap = Capabilities.getEntityRace(entity);
        if (cap != null) {
            for (IAbilityInterface ability : cap.getAbilityHandler().getAbilitiesList()) {
                try {
                    IMovementAbility keybind;
                    IAbilityHandler handler = cap.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IMovementAbility) || (keybind = (IMovementAbility)handler).back(entity, state)) continue;
                    return false;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public boolean jump(Entity entity, int state) {
        EntityProperties cap = Capabilities.getEntityRace(entity);
        if (cap != null) {
            for (IAbilityInterface ability : cap.getAbilityHandler().getAbilitiesList()) {
                try {
                    IMovementAbility keybind;
                    IAbilityHandler handler = cap.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IMovementAbility) || (keybind = (IMovementAbility)handler).jump(entity, state)) continue;
                    return false;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public boolean sneak(Entity entity, int state) {
        EntityProperties cap = Capabilities.getEntityRace(entity);
        if (cap != null) {
            for (IAbilityInterface ability : cap.getAbilityHandler().getAbilitiesList()) {
                try {
                    IMovementAbility keybind;
                    IAbilityHandler handler = cap.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof IMovementAbility) || (keybind = (IMovementAbility)handler).sneak(entity, state)) continue;
                    return false;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
        return true;
    }
}

