/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.entity;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.attributes.UpdatingAttribute;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.RayTraceHelper;

public class AlphaWolf
extends EntityWolf {
    protected static final IAttribute JUMP_STRENGTH = new RangedAttribute((IAttribute)null, "wolf.jumpStrength", 0.7, 0.0, 2.0).func_111117_a("Jump Strength").func_111112_a(true);
    private EntityLivingBase attackTarget;
    private NBTTagCompound storedWolf;

    public AlphaWolf(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.2f);
        this.field_70138_W = 1.0f;
    }

    public void func_70071_h_() {
        boolean r;
        Entity rider;
        super.func_70071_h_();
        if (!this.func_70089_S() || this.field_70170_p.field_72995_K) {
            return;
        }
        boolean canRide = TrinketsConfig.SERVER.races.goblin.rider;
        if (!canRide) {
            this.func_70106_y();
        }
        if (!this.func_184188_bt().isEmpty() && (rider = this.func_184179_bs()) instanceof EntityLivingBase) {
            EntityLivingBase driver = (EntityLivingBase)rider;
            if (!this.func_70644_a(MobEffects.field_76428_l)) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 0, false, false));
            }
            if (driver.func_70644_a(MobEffects.field_76427_o) || TrinketHelper.AccessoryCheck(driver, ModItems.trinkets.TrinketSea)) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 100, 0, false, false));
            }
            if (driver.func_70644_a(MobEffects.field_76426_n)) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 100, 0, false, false));
            }
        }
        if (!(r = this.func_184188_bt().contains(this.func_70902_q())) && this.field_70173_aa > 20) {
            this.func_70106_y();
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            try {
                Entity oldWolf = EntityList.func_75615_a((NBTTagCompound)this.getPreviousWolf(), (World)this.field_70170_p);
                if (oldWolf != null) {
                    oldWolf.func_70020_e(this.getPreviousWolf());
                    oldWolf.func_70012_b(this.field_70165_t, this.field_70163_u + (double)1.1f, this.field_70161_v, this.field_70177_z, 0.0f);
                    if (oldWolf instanceof EntityLivingBase) {
                        ((EntityLivingBase)oldWolf).func_70606_j(this.func_110143_aJ());
                    }
                    this.field_70170_p.func_72838_d(oldWolf);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.func_70106_y();
    }

    protected boolean func_146066_aG() {
        return false;
    }

    public void func_110145_l(Entity entityIn) {
        super.func_110145_l(entityIn);
    }

    public void func_184210_p() {
        super.func_184210_p();
    }

    public void setTamedBy(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            super.func_193101_c((EntityPlayer)entity);
        }
    }

    public void storeOldWolf(EntityWolf wolf) {
        NBTTagCompound tag = new NBTTagCompound();
        wolf.func_189511_e(tag);
        this.storedWolf = tag;
    }

    public void storeOldWolf(NBTTagCompound tag) {
        this.storedWolf = tag;
    }

    public NBTTagCompound getPreviousWolf() {
        return this.storedWolf;
    }

    protected void func_184651_r() {
        this.field_70714_bg.field_75782_a.clear();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(JUMP_STRENGTH);
        UpdatingAttribute atkDamage = new UpdatingAttribute(UUID.fromString("76c436ad-d830-48ff-8b3c-fa3bcc1891c2"), SharedMonsterAttributes.field_111264_e);
        atkDamage.addModifier((EntityLivingBase)this, 4.0, 2);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("xat.wolf.stored", (NBTBase)this.storedWolf);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("xat.wolf.stored")) {
            this.storedWolf = (NBTTagCompound)compound.func_74781_a("xat.wolf.stored");
        }
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        return this.func_184207_aI() && entity != null && this.func_184215_y(entity) ? false : super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return false;
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            EntityWolf entitywolf;
            if (target instanceof EntityWolf && (entitywolf = (EntityWolf)target).func_70909_n() && entitywolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).func_110248_bS();
        }
        return false;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br * 0.5f;
            forward = entitylivingbase.field_191988_bg;
            if (this.isJumping() && this.field_70122_E) {
                this.func_70664_aZ();
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_191986_a(strafe, vertical, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.field_70122_E) {
                this.func_70637_d(false);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public boolean isJumping() {
        return this.field_70703_bu;
    }

    public void func_70637_d(boolean jumping) {
        this.field_70703_bu = jumping;
    }

    public double getJumpStrength() {
        return this.func_110148_a(JUMP_STRENGTH).func_111126_e();
    }

    protected void func_70664_aZ() {
        this.field_70181_x = this.getJumpStrength();
        if (this.func_70644_a(MobEffects.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        if (this.func_70051_ag()) {
            float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            this.field_70159_w -= (double)(0.2f * f) * this.getJumpStrength();
            this.field_70179_y += (double)(0.2f * f1) * this.getJumpStrength();
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    public void func_70098_U() {
        super.func_70098_U();
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 1.05;
    }

    public void MountedAttack(EntityPlayer player, double maxDist) {
        RayTraceHelper.Beam beam = new RayTraceHelper.Beam(player.field_70170_p, (EntityLivingBase)player, maxDist, 1.0, true);
        RayTraceHelper.rayTraceEntity(beam, target -> {
            if (target instanceof EntityLivingBase && target != this) {
                double d0 = target.field_70165_t - this.field_70165_t;
                double d1 = target.field_70161_v - this.field_70161_v;
                float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                if ((double)f >= 1.0E-4) {
                    this.field_70159_w += d0 / (double)f * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
                    this.field_70179_y += d1 / (double)f * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
                }
                this.field_70181_x = 0.4;
                this.func_70664_aZ();
                this.func_184609_a(EnumHand.MAIN_HAND);
                this.func_70652_k((Entity)target);
                return true;
            }
            return false;
        });
    }
}

