/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.attributes.JumpAttribute;
import xzeroair.trinkets.attributes.MagicAttributes;
import xzeroair.trinkets.attributes.RaceAttribute.RaceAttribute;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.configsync.PacketConfigSync;
import xzeroair.trinkets.network.trinketcontainer.OpenTrinketGui;
import xzeroair.trinkets.util.TrinketsConfig;

public class OnWorldJoinHandler {
    @SubscribeEvent
    public void attachAttributes(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getEntity();
            AbstractAttributeMap map = entity.func_110140_aT();
            map.func_111150_b(RaceAttribute.ENTITY_RACE);
            map.func_111150_b(JumpAttribute.Jump);
            map.func_111150_b(JumpAttribute.stepHeight);
            map.func_111150_b(MagicAttributes.regen);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (event.player.field_70170_p != null && player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
            boolean client = playerMP.field_70170_p.field_72995_K;
            if (!client) {
                MagicStats magic;
                Trinkets.log.info("Syncing Config to " + playerMP.func_70005_c_());
                Map<String, String> configMap = TrinketsConfig.writeConfigMap();
                NetworkHandler.sendTo(new PacketConfigSync(configMap), playerMP);
                EntityProperties cap = Capabilities.getEntityRace((Entity)player);
                if (cap != null) {
                    cap.sendInformationToPlayer((EntityLivingBase)player);
                    if (TrinketsConfig.SERVER.races.selectionMenu && cap.isFirstLogin()) {
                        NetworkHandler.sendTo(new OpenTrinketGui(4), playerMP);
                    }
                }
                if ((magic = Capabilities.getMagicStats((Entity)player)) != null) {
                    magic.sendManaToPlayer((EntityLivingBase)player);
                }
            }
        }
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player != null && event.player.func_130014_f_() != null) {
            MagicStats magic;
            EntityPlayer player = event.player;
            boolean client = player.field_70170_p.field_72995_K;
            EntityProperties cap = Capabilities.getEntityRace((Entity)player);
            if (cap != null && !client) {
                cap.sendInformationToPlayer((EntityLivingBase)player);
            }
            if ((magic = Capabilities.getMagicStats((Entity)player)) != null) {
                magic.sendManaToPlayer((EntityLivingBase)player);
            }
        }
    }
}

