/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.capabilities.Vip.VipStatus;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.traits.abilities.IAbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.ISleepAbility;

public class PlayerEventMC {
    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer().field_70128_L) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        boolean client = player.field_70170_p.field_72995_K;
        Entity entity = event.getTarget();
        if (!client) {
            VipStatus vip;
            EntityProperties cap = Capabilities.getEntityRace(entity);
            if (cap != null) {
                cap.sendInformationToPlayer((EntityLivingBase)player);
            }
            if ((vip = Capabilities.getVipStatus(entity)) != null) {
                vip.sendStatusToPlayer(player);
            }
        }
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        boolean client = player.field_70170_p.field_72995_K;
        if (!client && player.func_70089_S()) {
            TrinketProperties iCap;
            MagicStats magic;
            EntityProperties cap = Capabilities.getEntityRace((Entity)player);
            if (cap != null) {
                cap.sendInformationToPlayer((EntityLivingBase)player);
            }
            if ((magic = Capabilities.getMagicStats((Entity)player)) != null) {
                magic.sendManaToPlayer((EntityLivingBase)player);
            }
            ItemStack stack = null;
            if (TrinketHelper.AccessoryCheck((EntityLivingBase)player, ModItems.trinkets.TrinketDragonsEye) && (stack = TrinketHelper.getAccessory(player, ModItems.trinkets.TrinketDragonsEye)) != null && (iCap = Capabilities.getTrinketProperties(stack)) != null && !player.field_70170_p.field_72995_K) {
                iCap.turnOff();
                iCap.sendInformationToPlayer((EntityLivingBase)player, (EntityLivingBase)player);
            }
            if (TrinketHelper.AccessoryCheck((EntityLivingBase)player, ModItems.trinkets.TrinketPolarized) && (stack = TrinketHelper.getAccessory(player, ModItems.trinkets.TrinketPolarized)) != null && (iCap = Capabilities.getTrinketProperties(stack)) != null && !player.field_70170_p.field_72995_K) {
                iCap.turnOff();
                iCap.sendInformationToPlayer((EntityLivingBase)player, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void playerWakeUp(PlayerWakeUpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        EntityProperties prop = Capabilities.getEntityRace((Entity)entity);
        if (prop != null) {
            for (IAbilityInterface ability : prop.getAbilityHandler().getAbilitiesList()) {
                try {
                    IAbilityHandler handler = prop.getAbilityHandler().getAbilityInstance(ability);
                    if (handler == null || !(handler instanceof ISleepAbility)) continue;
                    ((ISleepAbility)handler).onWakeUp(entity, event.wakeImmediately(), event.updateWorld(), event.shouldSetSpawn());
                }
                catch (Exception e) {
                    Trinkets.log.error("Error with ability:" + ability.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.getOriginal();
        EntityPlayer newPlayer = event.getEntityPlayer();
        boolean wasDeath = event.isWasDeath();
        boolean keepInv = event.getOriginal().func_130014_f_().func_82736_K().func_82766_b("keepInventory");
        try {
            EntityProperties oldRace = Capabilities.getEntityRace((Entity)oldPlayer);
            EntityProperties newRace = Capabilities.getEntityRace((Entity)newPlayer);
            if (oldRace != null && newRace != null) {
                newRace.copyFrom(oldRace, wasDeath, keepInv);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            MagicStats oldMagic = Capabilities.getMagicStats((Entity)oldPlayer);
            MagicStats newMagic = Capabilities.getMagicStats((Entity)newPlayer);
            if (oldMagic != null && newMagic != null) {
                newMagic.copyFrom(oldMagic, wasDeath, keepInv);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

