/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.init;

import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.items.base.BasePotion;
import xzeroair.trinkets.items.potions.PotionObject;
import xzeroair.trinkets.items.potions.TransformationPotion;
import xzeroair.trinkets.races.EntityRace;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.CallHelper;

public class ModPotionTypes {
    public static final String baseSparkling = "sparkling";
    public static final String enhancedGlittering = "glittering";
    public static final String advancedGlowing = "glowing";
    public static final String restore = "restorative";
    public static HashMap<String, Potion> TrinketPotions = new HashMap();
    public static HashMap<String, PotionType> TrinketPotionTypes = new HashMap();
    public static HashMap<String, PotionObject> TrinketPotionObjects = new HashMap();

    public static PotionObject createBasePotion(String name, int color, int X, int Y, int duration, Ingredient ingredient) {
        BasePotion potion = new BasePotion(name, duration, color, X, Y);
        PotionObject potObj = new PotionObject(potion, name, color, duration, ingredient);
        TrinketPotionObjects.put(potObj.getName(), potObj);
        return potObj;
    }

    public static PotionObject createPotion(String name, int color, int X, int Y, int duration, PotionType base, Ingredient ingredient) {
        BasePotion potion = new BasePotion(name, duration, color, X, Y);
        PotionObject potObj = new PotionObject(potion, base, name, color, duration, ingredient);
        TrinketPotionObjects.put(potObj.getName(), potObj);
        return potObj;
    }

    public static PotionObject createRacePotion(EntityRace race, int X, int Y, int duration, PotionType base, Ingredient ingredient) {
        TransformationPotion potion = new TransformationPotion(race.getName().toLowerCase(), race.getPrimaryColor(), race.getUUID().toString(), X, Y);
        PotionObject potObj = new PotionObject(potion, base, race.getName().toLowerCase(), race.getPrimaryColor(), duration, ingredient);
        TrinketPotionObjects.put(potObj.getName(), potObj);
        return potObj;
    }

    public static void registerPotionTypes() {
        Trinkets.log.info("Generating Potions");
        PotionObject pot = ModPotionTypes.createBasePotion(baseSparkling, 0xFFFFC8, 0, 0, 0, Ingredient.func_193367_a((Item)ModItems.crafting.glowing_powder)).registerPotion();
        pot = ModPotionTypes.createPotion(enhancedGlittering, 0xFFFFA0, 0, 0, 0, TrinketPotionObjects.get(baseSparkling).getPotionType(), Ingredient.func_193367_a((Item)ModItems.crafting.glowing_ingot)).registerPotion();
        pot = ModPotionTypes.createPotion(advancedGlowing, 0xFFFF78, 0, 0, 0, TrinketPotionObjects.get(enhancedGlittering).getPotionType(), Ingredient.func_193367_a((Item)ModItems.crafting.glowing_gem)).registerPotion();
        pot = ModPotionTypes.createRacePotion(EntityRaces.human, 0, 0, TrinketsConfig.SERVER.Potion.human.Duration, TrinketPotionObjects.get(baseSparkling).getPotionType(), ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.human.catalyst)).registerPotion();
        pot = ModPotionTypes.createRacePotion(EntityRaces.fairy, 1, 0, TrinketsConfig.SERVER.Potion.fairy.Duration, TrinketPotionObjects.get(advancedGlowing).getPotionType(), ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.fairy.catalyst)).registerPotion();
        pot = ModPotionTypes.createRacePotion(EntityRaces.dwarf, 2, 0, TrinketsConfig.SERVER.Potion.dwarf.Duration, TrinketPotionObjects.get(enhancedGlittering).getPotionType(), ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.dwarf.catalyst)).registerPotion();
        pot = ModPotionTypes.createRacePotion(EntityRaces.titan, 3, 0, TrinketsConfig.SERVER.Potion.titan.Duration, TrinketPotionObjects.get(advancedGlowing).getPotionType(), ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.titan.catalyst)).registerPotion();
        pot = ModPotionTypes.createRacePotion(EntityRaces.goblin, 4, 0, TrinketsConfig.SERVER.Potion.goblin.Duration, TrinketPotionObjects.get(baseSparkling).getPotionType(), ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.goblin.catalyst)).registerPotion();
        pot = ModPotionTypes.createRacePotion(EntityRaces.elf, 5, 0, TrinketsConfig.SERVER.Potion.elf.Duration, TrinketPotionObjects.get(enhancedGlittering).getPotionType(), ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.elf.catalyst)).registerPotion();
        pot = ModPotionTypes.createRacePotion(EntityRaces.faelis, 6, 0, TrinketsConfig.SERVER.Potion.faelis.Duration, TrinketPotionObjects.get(enhancedGlittering).getPotionType(), ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.faelis.catalyst)).registerPotion();
        pot = ModPotionTypes.createRacePotion(EntityRaces.dragon, 7, 0, TrinketsConfig.SERVER.Potion.dragon.Duration, TrinketPotionObjects.get(advancedGlowing).getPotionType(), ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.dragon.catalyst)).registerPotion();
        Trinkets.log.info("Finished Generating Potions");
    }

    private static Ingredient getCatalyst(String catalyst) {
        String[] itemConfig = catalyst.replace(";", ":").split(":");
        String modIDString = CallHelper.getStringFromArray(itemConfig, 0);
        String itemIDString = CallHelper.getStringFromArray(itemConfig, 1);
        String metaString = CallHelper.getStringFromArray(itemConfig, 2).replaceAll("[^\\d]", "");
        int meta = Short.MAX_VALUE;
        try {
            if (!metaString.isEmpty()) {
                meta = Integer.parseInt(metaString);
            }
        }
        catch (Exception e) {
            Trinkets.log.warn("Invalid catalyst meta from | " + catalyst);
        }
        return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Item.func_111206_d((String)(modIDString + ":" + itemIDString)), 1, meta)});
    }
}

