/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.base;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.attributes.AttributeConfigWrapper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.init.Abilities;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.IAbilityHandler;
import xzeroair.trinkets.traits.abilities.base.AbilityBase;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.shared.BaubleCompat;
import xzeroair.trinkets.util.handlers.ItemAttributeHandler;
import xzeroair.trinkets.util.helpers.AttributeHelper;
import xzeroair.trinkets.util.helpers.TranslationHelper;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;
import xzeroair.trinkets.util.interfaces.IAttributeConfigHelper;
import xzeroair.trinkets.util.interfaces.IsModelLoaded;

public abstract class AccessoryBase
extends Item
implements IsModelLoaded,
IAccessoryInterface {
    protected UUID uuid;
    private BaubleCompat BaubleType;
    protected AttributeConfigWrapper attributesConfig;
    protected ItemAttributeHandler attributes;

    public AccessoryBase(String name) {
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77625_d(1);
        this.func_77637_a(Trinkets.trinketstab);
        this.attributes = new ItemAttributeHandler();
    }

    protected void setItemAttributes(IAttributeConfigHelper attributes) {
        this.attributesConfig = new AttributeConfigWrapper(attributes);
        this.attributes = new ItemAttributeHandler(this.getUUID(), this.attributesConfig);
    }

    public String func_77653_i(ItemStack stack) {
        return TranslationHelper.addTextColorFromLangKey(super.func_77653_i(stack));
    }

    public String getType() {
        return this.BaubleType.bauble_type;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    protected void setUUID(String uuid) {
        this.uuid = UUID.fromString(uuid);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
    }

    @Override
    public void playerEquipped(ItemStack stack, EntityLivingBase entity) {
        entity.func_184185_a(SoundEvents.field_187716_o, 0.75f, 1.9f);
        TrinketProperties cap = Capabilities.getTrinketProperties(stack);
        if (cap != null) {
            cap.itemEquipped(entity, this.getEquippedSlot(stack, entity), this.getIsTrinketOrBauble(stack, entity));
        }
    }

    @Override
    public void eventPlayerTick(ItemStack stack, EntityPlayer player) {
        this.attributes.addAttributes((EntityLivingBase)player);
        this.initAbilities((EntityLivingBase)player);
        TrinketProperties cap = Capabilities.getTrinketProperties(stack);
        if (cap != null) {
            cap.onUpdate();
        }
    }

    @Override
    public void playerUnequipped(ItemStack stack, EntityLivingBase entity) {
        TrinketProperties cap = Capabilities.getTrinketProperties(stack);
        if (cap != null) {
            cap.itemUnequipped(entity);
            if (!cap.isEquipped(entity)) {
                entity.func_184185_a(SoundEvents.field_187716_o, 0.75f, 2.0f);
            }
        }
        this.attributes.removeAttibutes(entity);
        AttributeHelper.removeAttributes(entity, this.getUUID());
    }

    @Override
    public void eventPlayerLogout(ItemStack stack, EntityLivingBase entity) {
        this.attributes.removeAttibutes(entity);
        AttributeHelper.removeAttributes(entity, this.getUUID());
    }

    public int getIsTrinketOrBauble(ItemStack stack, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            IBaublesItemHandler baubles2;
            boolean skip = false;
            ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler((EntityPlayer)entity);
            if (Trinket != null) {
                for (int i = 0; i < Trinket.getSlots(); ++i) {
                    if (Trinket.getStackInSlot(i) != stack) continue;
                    skip = true;
                    return 1;
                }
            }
            if (!skip && Loader.isModLoaded((String)"baubles") && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity))) != null) {
                for (int i = 0; i < baubles2.getSlots(); ++i) {
                    if (baubles2.getStackInSlot(i) != stack) continue;
                    return 2;
                }
            }
        }
        return 0;
    }

    public int getEquippedSlot(ItemStack stack, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            IBaublesItemHandler baubles2;
            boolean skip = false;
            ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler((EntityPlayer)entity);
            if (Trinket != null) {
                for (int i = 0; i < Trinket.getSlots(); ++i) {
                    if (Trinket.getStackInSlot(i) != stack) continue;
                    skip = true;
                    TrinketProperties iCap = Capabilities.getTrinketProperties(stack);
                    iCap.setSlot(i);
                    iCap.setHandler(1);
                    return i;
                }
            }
            if (!skip && Loader.isModLoaded((String)"baubles") && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity))) != null) {
                for (int i = 0; i < baubles2.getSlots(); ++i) {
                    if (baubles2.getStackInSlot(i) != stack) continue;
                    TrinketProperties iCap = Capabilities.getTrinketProperties(stack);
                    iCap.setSlot(i);
                    iCap.setHandler(2);
                    return i;
                }
            }
        }
        return -1;
    }

    protected boolean isItemAbility(IAbilityInterface ability, EntityLivingBase entity) {
        EntityProperties prop = Capabilities.getEntityRace((Entity)entity);
        if (prop != null) {
            AbilityHandler handler = prop.getAbilityHandler();
            return handler.isSource(Abilities.blockDetection, AbilityHandler.AbilitySource.EQUIPPED, this.getRegistryName().toString());
        }
        return false;
    }

    public void initAbilities(EntityLivingBase entity) {
    }

    protected void addAbility(EntityLivingBase entity, IAbilityInterface ability, IAbilityHandler handler) {
        EntityProperties prop = Capabilities.getEntityRace((Entity)entity);
        if (prop != null) {
            if (handler instanceof AbilityBase) {
                ((AbilityBase)handler).setEntity(entity);
            }
            prop.getAbilityHandler().addAbility(ability, AbilityHandler.AbilitySource.EQUIPPED.getName() + ";" + this.getRegistryName(), handler);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (worldIn == null) {
            return;
        }
        if (TrinketsConfig.CLIENT.GUI.SLOT.showID) {
            tooltip.add("Currently Equipped in Slot: " + String.valueOf(this.getEquippedSlot(stack, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g)));
        }
        TranslationHelper.addTooltips(stack, worldIn, tooltip);
        if (this.attributes != null && this.attributesConfig != null) {
            TranslationHelper.addOtherTooltips(this.attributesConfig, tooltip);
        }
    }

    @Override
    public boolean playerCanUnequip(ItemStack stack, EntityLivingBase player) {
        if (EnchantmentHelper.func_190938_b((ItemStack)stack) && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() != Item.func_150899_d((int)399)) {
            return false;
        }
        if (player instanceof EntityPlayer && ((EntityPlayer)player).field_71075_bZ.field_75098_d) {
            return true;
        }
        return true;
    }

    public NBTTagCompound getTagCompoundSafe(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    @Override
    public boolean playerCanEquip(ItemStack stack, EntityLivingBase player) {
        if (this.BaubleType != null && this.BaubleType.equip_multiple) {
            return true;
        }
        return !TrinketHelper.AccessoryCheck(player, stack.func_77973_b());
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77952_i();
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_190941_k) || EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_190940_C);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack);
    }
}

