/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.base;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.util.helpers.TranslationHelper;
import xzeroair.trinkets.util.interfaces.IsModelLoaded;

public class FoodBase
extends ItemFood
implements IsModelLoaded {
    private UUID uuid;
    protected int cooldown = 0;
    protected boolean canEat = true;

    public FoodBase(String name, int heal, float saturation) {
        super(heal, saturation, false);
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77637_a(Trinkets.trinketstab);
        ModItems.foods.ITEMS.add((Item)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationHelper.addTooltips(stack, worldIn, tooltip);
    }

    public String func_77653_i(ItemStack stack) {
        return TranslationHelper.addTextColorFromLangKey(super.func_77653_i(stack));
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = !uuid.isEmpty() ? UUID.fromString(uuid) : UUID.randomUUID();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.cooldown > 0) {
            this.canEat = false;
            --this.cooldown;
        } else {
            this.canEat = true;
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public boolean getEdible() {
        return this.canEat;
    }

    @Override
    public void registerModels() {
        Trinkets.proxy.registerItemRenderer((Item)this, 0, "inventory");
    }
}

