/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.potions;

import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xzeroair.trinkets.init.ModPotionTypes;

public class PotionObject {
    private Potion potion;
    private PotionType base;
    private PotionType normal;
    private PotionType extended;
    private Ingredient ingredient;
    private int duration;
    private String name;
    private int color;
    private boolean isBase;

    public PotionObject(Potion potion, String name, int color, int duration, Ingredient ingredient) {
        this.potion = potion;
        this.name = name;
        this.color = color;
        this.duration = duration;
        this.ingredient = ingredient;
        this.normal = this.createPotionType(name, potion, duration);
        this.extended = this.createPotionTypeExtended(name, potion, duration);
        this.isBase = true;
    }

    public PotionObject(Potion potion, PotionType base, String name, int color, int duration, Ingredient ingredient) {
        this(potion, name, color, duration, ingredient);
        this.base = base;
        this.isBase = false;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public Potion getPotion() {
        return this.potion;
    }

    public PotionType getBasePotionType() {
        return this.base;
    }

    public PotionType getPotionType() {
        return this.normal;
    }

    public PotionType getPotionTypeExtended() {
        return this.extended;
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public int getDuration() {
        return this.duration;
    }

    public PotionObject registerPotion() {
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)this.potion);
        ModPotionTypes.TrinketPotions.put(this.name, this.potion);
        ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)this.normal);
        ModPotionTypes.TrinketPotionTypes.put(this.name, this.normal);
        if (this.isBase) {
            this.addBaseMix(this.normal, this.ingredient);
        } else {
            PotionHelper.func_193356_a((PotionType)this.base, (Ingredient)this.ingredient, (PotionType)this.normal);
        }
        if (this.duration > 0) {
            ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)this.extended);
            ModPotionTypes.TrinketPotionTypes.put("extended_" + this.name, this.extended);
            PotionHelper.func_193357_a((PotionType)this.normal, (Item)Items.field_151137_ax, (PotionType)this.extended);
        }
        return this;
    }

    public PotionObject registerPotionWithoutRecipe() {
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)this.potion);
        ModPotionTypes.TrinketPotions.put(this.name, this.potion);
        ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)this.normal);
        ModPotionTypes.TrinketPotionTypes.put(this.name, this.normal);
        return this;
    }

    private PotionType createPotionType(String name, Potion pot, int duration) {
        PotionType type = (PotionType)new PotionType("xat." + name, new PotionEffect[]{new PotionEffect(pot, duration)}).setRegistryName(name);
        return type;
    }

    private PotionType createPotionTypeExtended(String name, Potion pot, int duration) {
        PotionType type = (PotionType)new PotionType("xat." + name, new PotionEffect[]{new PotionEffect(pot, duration * 3)}).setRegistryName("extended_" + name);
        return type;
    }

    private void addBaseMix(PotionType potion, Ingredient ingredient) {
        PotionHelper.func_193356_a((PotionType)PotionTypes.field_185231_c, (Ingredient)ingredient, (PotionType)potion);
        PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)ingredient, (PotionType)potion);
        PotionHelper.func_193356_a((PotionType)PotionTypes.field_185232_d, (Ingredient)ingredient, (PotionType)potion);
    }
}

