/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.trinkets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.Vip.VipStatus;
import xzeroair.trinkets.init.Abilities;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.traits.abilities.AbilityResistance;
import xzeroair.trinkets.traits.abilities.compat.firstaid.AbilityIgnoreHeadshot;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigDamageShield;

public class TrinketDamageShield
extends AccessoryBase {
    public static final ConfigDamageShield serverConfig = TrinketsConfig.SERVER.Items.DAMAGE_SHIELD;
    public static final TrinketsConfig.xClient.TrinketItems.Shield clientConfig = TrinketsConfig.CLIENT.items.DAMAGE_SHIELD;

    public TrinketDamageShield(String name) {
        super(name);
        this.setUUID("c0885371-20dd-4c56-86eb-78f24d9fe777");
        this.setItemAttributes(TrinketDamageShield.serverConfig.Attributes);
        ModItems.trinkets.ITEMS.add(this);
    }

    @Override
    public void initAbilities(EntityLivingBase entity) {
        this.addAbility(entity, Abilities.safeGuard, new AbilityResistance());
        if (Trinkets.FirstAid && TrinketDamageShield.serverConfig.compat.firstaid.chance_ignore) {
            this.addAbility(entity, Abilities.firstAidReflex, new AbilityIgnoreHeadshot());
        }
    }

    @Override
    public void eventPlayerTick(ItemStack stack, EntityPlayer player) {
        super.eventPlayerTick(stack, player);
        try {
            VipStatus status = Capabilities.getVipStatus((Entity)player);
            if (status != null && this.stackHasStatus(stack) && this.getTagCompoundSafe(stack).func_74762_e("status") != status.getStatus()) {
                this.getTagCompoundSafe(stack).func_74768_a("status", status.getStatus());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        this.removePlayerStatus(stack);
    }

    @Override
    public void playerEquipped(ItemStack stack, EntityLivingBase player) {
        this.addPlayerStatus(stack, player);
        super.playerEquipped(stack, player);
    }

    @Override
    public void playerUnequipped(ItemStack stack, EntityLivingBase player) {
        super.playerUnequipped(stack, player);
        if (!TrinketHelper.AccessoryCheck(player, stack.func_77973_b())) {
            this.removePlayerStatus(stack);
        }
    }

    private boolean stackHasStatus(ItemStack stack) {
        return this.getTagCompoundSafe(stack).func_74764_b("status");
    }

    private void addPlayerStatus(ItemStack stack, EntityLivingBase player) {
        VipStatus status;
        if (this.stackHasStatus(stack)) {
            this.getTagCompoundSafe(stack).func_82580_o("status");
        }
        if ((status = Capabilities.getVipStatus((Entity)player)) != null) {
            this.getTagCompoundSafe(stack).func_74768_a("status", status.getStatus());
        }
    }

    private void removePlayerStatus(ItemStack stack) {
        if (this.stackHasStatus(stack)) {
            this.getTagCompoundSafe(stack).func_82580_o("status");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        final ModelResourceLocation normal = new ModelResourceLocation(this.getRegistryName().toString(), "inventory");
        final ModelResourceLocation bro = new ModelResourceLocation(this.getRegistryName().toString() + "_bro", "inventory");
        final ModelResourceLocation panda = new ModelResourceLocation(this.getRegistryName().toString() + "_panda", "inventory");
        final ModelResourceLocation vip = new ModelResourceLocation(this.getRegistryName().toString() + "_vip", "inventory");
        final ModelResourceLocation artsy = new ModelResourceLocation(this.getRegistryName().toString() + "_artsy", "inventory");
        final ModelResourceLocation twilight = new ModelResourceLocation(this.getRegistryName().toString() + "_twilight", "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{normal, bro, panda, vip, artsy, twilight});
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (TrinketDamageShield.this.stackHasStatus(stack)) {
                    if (TrinketDamageShield.this.getTagCompoundSafe(stack).func_74762_e("status") == 0) {
                        return normal;
                    }
                    if (TrinketDamageShield.this.getTagCompoundSafe(stack).func_74762_e("status") == 1) {
                        return vip;
                    }
                    if (TrinketDamageShield.this.getTagCompoundSafe(stack).func_74762_e("status") == 2) {
                        return bro;
                    }
                    if (TrinketDamageShield.this.getTagCompoundSafe(stack).func_74762_e("status") == 3) {
                        return panda;
                    }
                    if (TrinketDamageShield.this.getTagCompoundSafe(stack).func_74762_e("status") == 4) {
                        return artsy;
                    }
                    if (TrinketDamageShield.this.getTagCompoundSafe(stack).func_74762_e("status") == 5) {
                        return twilight;
                    }
                    return vip;
                }
                return normal;
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playerRender(ItemStack stack, EntityLivingBase player, RenderPlayer renderer, boolean isSlim, float partialTicks, float scale, boolean isBauble) {
        if (!TrinketDamageShield.clientConfig.doRender) {
            return;
        }
        float offsetX = 0.17f;
        float offsetY = 0.22f;
        float offsetZ = 0.16f;
        GlStateManager.func_179094_E();
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        renderer.func_177087_b().field_78115_e.func_78794_c(scale);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.17f, (float)-0.22f, (float)0.16f);
        if (player.func_190630_a(EntityEquipmentSlot.CHEST)) {
            GlStateManager.func_179109_b((float)0.030000001f, (float)0.0f, (float)0.040000007f);
        }
        float bS = 3.0f;
        GlStateManager.func_179152_a((float)(scale * 3.0f), (float)(scale * 3.0f), (float)(scale * 3.0f));
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean ItemEnabled() {
        return TrinketDamageShield.serverConfig.enabled;
    }
}

