/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import xzeroair.trinkets.network.BasicNetworkWrapper;
import xzeroair.trinkets.network.BasicPacket;
import xzeroair.trinkets.network.IncreasedReachPacket;
import xzeroair.trinkets.network.PolarizedStoneSyncPacket;
import xzeroair.trinkets.network.SyncItemDataPacket;
import xzeroair.trinkets.network.SyncRaceDataPacket;
import xzeroair.trinkets.network.configsync.PacketConfigSync;
import xzeroair.trinkets.network.keybinds.KeybindPacket;
import xzeroair.trinkets.network.keybinds.MovementKeyPacket;
import xzeroair.trinkets.network.mana.SyncManaCostToHudPacket;
import xzeroair.trinkets.network.mana.SyncManaStatsPacket;
import xzeroair.trinkets.network.particles.EffectsRenderPacket;
import xzeroair.trinkets.network.status.StatusEffectPacket;
import xzeroair.trinkets.network.trinketcontainer.OpenTrinketGui;
import xzeroair.trinkets.network.vip.VipStatusPacket;

public class NetworkHandler
extends BasicNetworkWrapper {
    public static final NetworkHandler INSTANCE = new NetworkHandler();

    public NetworkHandler() {
        super("xat".toLowerCase());
    }

    public void init() {
        this.registerPacket(SyncRaceDataPacket.class);
        this.registerPacket(SyncItemDataPacket.class);
        this.registerPacket(StatusEffectPacket.class);
        this.registerPacketClient(SyncManaStatsPacket.class);
        this.registerPacketClient(SyncManaCostToHudPacket.class);
        this.registerPacketServer(KeybindPacket.class);
        this.registerPacketServer(MovementKeyPacket.class);
        this.registerPacketServer(IncreasedReachPacket.class);
        this.registerPacket(PolarizedStoneSyncPacket.class);
        this.registerPacket(EffectsRenderPacket.class);
        this.registerPacket(VipStatusPacket.class);
        this.registerPacket(OpenTrinketGui.class);
        this.registerPacketClient(PacketConfigSync.class);
    }

    public static void sendPacket(Entity player, Packet<?> packet) {
        if (player instanceof EntityPlayerMP && ((EntityPlayerMP)player).field_71135_a != null) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a(packet);
        }
    }

    public static void sendToAll(BasicPacket packet) {
        NetworkHandler.INSTANCE.network.sendToAll((IMessage)packet);
    }

    public static void sendTo(BasicPacket packet, EntityPlayerMP player) {
        NetworkHandler.INSTANCE.network.sendTo((IMessage)packet, player);
    }

    public static void sendToAllAround(BasicPacket packet, NetworkRegistry.TargetPoint point) {
        NetworkHandler.INSTANCE.network.sendToAllAround((IMessage)packet, point);
    }

    public static void sendToDimension(BasicPacket packet, int dimensionId) {
        NetworkHandler.INSTANCE.network.sendToDimension((IMessage)packet, dimensionId);
    }

    public static void sendToServer(BasicPacket packet) {
        NetworkHandler.INSTANCE.network.sendToServer((IMessage)packet);
    }

    public static void sendToTracking(BasicPacket packet, Entity entity) {
        NetworkHandler.INSTANCE.network.sendToAllTracking((IMessage)packet, entity);
    }

    public static void sendToClients(WorldServer world, BlockPos pos, BasicPacket packet) {
        Chunk chunk = world.func_175726_f(pos);
        for (EntityPlayer player : world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP)) continue;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (!world.func_184164_w().func_72694_a(playerMP, chunk.field_76635_g, chunk.field_76647_h)) continue;
            NetworkHandler.sendTo(packet, playerMP);
        }
    }
}

