/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.network.ThreadSafePacket;

public class SyncRaceDataPacket
extends ThreadSafePacket {
    private int entityID;
    private NBTTagCompound tag;

    public SyncRaceDataPacket() {
    }

    public SyncRaceDataPacket(EntityLivingBase entity, NBTTagCompound tag) {
        this.entityID = entity.func_145782_y();
        this.tag = tag;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    @Override
    public void handleClientSafe(NetHandlerPlayClient client) {
        Minecraft mc = Minecraft.func_71410_x();
        World world = mc.field_71439_g.func_130014_f_();
        Entity entity = world.func_73045_a(this.entityID);
        EntityProperties prop = Capabilities.getEntityRace(entity);
        if (prop != null) {
            prop.parseEquipped();
            if (entity instanceof EntityLivingBase && prop.getEquippedItems() != null && !prop.getEquippedItems().isEmpty()) {
                for (Map.Entry<String, ItemStack> entry : prop.getEquippedItems().entrySet()) {
                    ItemStack stack = entry.getValue();
                    TrinketProperties itemProp = Capabilities.getTrinketProperties(stack);
                    if (stack.func_190926_b() || itemProp == null || !(stack.func_77973_b() instanceof AccessoryBase)) continue;
                    AccessoryBase acc = (AccessoryBase)stack.func_77973_b();
                    acc.initAbilities((EntityLivingBase)entity);
                }
            }
            prop.loadFromNBT(this.tag);
            prop.loadAbilitiesFromNBT(this.tag);
        }
    }

    @Override
    public void handleServerSafe(NetHandlerPlayServer server) {
        Entity entity = server.field_147369_b.func_130014_f_().func_73045_a(this.entityID);
        EntityProperties prop = Capabilities.getEntityRace(entity);
        if (prop != null) {
            prop.loadFromNBT(this.tag);
            prop.loadAbilitiesFromNBT(this.tag);
            prop.sendInformationToTracking();
        }
    }
}

