/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network.keybinds;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.client.keybinds.IKeyBindInterface;
import xzeroair.trinkets.network.ThreadSafePacket;
import xzeroair.trinkets.traits.abilities.IAbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;

public class KeybindPacket
extends ThreadSafePacket {
    private int entityID;
    private boolean key;
    private boolean aux;
    private String ability;
    private int state;
    private int moveKey;

    public KeybindPacket() {
    }

    public KeybindPacket(EntityLivingBase entity, IAbilityInterface ability, int moveKey, boolean key, boolean auxKey, int state) {
        this.entityID = entity.func_145782_y();
        this.ability = ability.getName();
        this.moveKey = moveKey;
        this.key = key;
        this.aux = auxKey;
        this.state = state;
    }

    public KeybindPacket(EntityLivingBase entity, IAbilityInterface ability, boolean key, boolean auxKey, int state) {
        this(entity, ability, -1, key, auxKey, state);
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeInt(this.state);
        buffer.writeInt(this.moveKey);
        buffer.writeBoolean(this.key);
        buffer.writeBoolean(this.aux);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ability);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.state = buffer.readInt();
        this.moveKey = buffer.readInt();
        this.key = buffer.readBoolean();
        this.aux = buffer.readBoolean();
        this.ability = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    public void handleClientSafe(NetHandlerPlayClient client) {
    }

    @Override
    public void handleServerSafe(NetHandlerPlayServer server) {
        IAbilityInterface kbAbility;
        Entity entity = server.field_147369_b.func_130014_f_().func_73045_a(this.entityID);
        EntityProperties cap = Capabilities.getEntityRace(entity);
        if (cap != null && (kbAbility = cap.getAbilityHandler().getAbilityByName(this.ability)) != null) {
            try {
                IAbilityHandler handler = cap.getAbilityHandler().getAbilityInstance(kbAbility);
                if (handler != null && handler instanceof IKeyBindInterface) {
                    IKeyBindInterface keybind = (IKeyBindInterface)handler;
                    if (this.key) {
                        if (this.state == 0) {
                            keybind.onKeyPress(entity, this.aux);
                        } else if (this.state == 1) {
                            keybind.onKeyDown(entity, this.aux);
                        }
                    } else if (this.state == 2) {
                        keybind.onKeyRelease(entity, this.aux);
                    }
                }
            }
            catch (Exception e) {
                Trinkets.log.error("Trinkets had an Error with Ability:" + kbAbility.getName());
                e.printStackTrace();
            }
        }
    }
}

