/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races;

import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IRaceHandler {
    @SideOnly(value=Side.CLIENT)
    default public void doRenderLayer(RenderLivingBase renderer, boolean isFake, boolean isSlim, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void doRenderPlayerPre(EntityPlayer entity, double x, double y, double z, RenderPlayer renderer, float partialTick) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void doRenderPlayerPost(EntityPlayer entity, double x, double y, double z, RenderPlayer renderer, float partialTick) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void doRenderLivingSpecialsPre(RenderLivingEvent.Specials.Pre event) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void doRenderLivingSpecialsPost(RenderLivingEvent.Specials.Post event) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void doRenderLivingPre(RenderLivingEvent.Pre event) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void doRenderLivingPost(RenderLivingEvent.Post event) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void onClientTick() {
    }

    default public void startTransformation() {
    }

    default public void endTransformation() {
    }

    default public void whileTransformed() {
    }

    default public void jump() {
    }

    default public void fall(LivingFallEvent event) {
    }

    default public boolean potionBeingApplied(PotionEffect effect) {
        return false;
    }

    default public void breakingBlock(PlayerEvent.BreakSpeed event) {
    }

    default public void blockBroken(BlockEvent.BreakEvent event) {
    }

    default public void blockDrops(BlockEvent.HarvestDropsEvent event) {
    }

    default public ActionResult<ItemStack> bowNocked(World world, ItemStack bow, EnumHand hand, ActionResult<ItemStack> result, boolean hasAmmo) {
        return result;
    }

    default public void bowDrawing(ItemStack stack, int charge) {
    }

    default public void bowUsed(ItemStack stack, int charge) {
    }

    default public void interact(PlayerInteractEvent event) {
    }

    default public void interactWithEntity(PlayerInteractEvent.EntityInteract event) {
    }

    default public boolean dismountedEntity(Entity mount) {
        return true;
    }

    default public boolean mountEntity(Entity mount) {
        return true;
    }

    default public void targetedByEnemy(EntityLivingBase enemy) {
    }

    default public boolean isAttacked(DamageSource source, float dmg) {
        return true;
    }

    default public float isHurt(DamageSource source, float dmg) {
        return dmg;
    }

    default public float isDamaged(DamageSource source, float dmg) {
        return dmg;
    }

    default public boolean attackedEntity(EntityLivingBase target, DamageSource source, float dmg) {
        return true;
    }

    default public float hurtEntity(EntityLivingBase target, DamageSource source, float dmg) {
        return dmg;
    }

    default public float damagedEntity(EntityLivingBase target, DamageSource source, float dmg) {
        return dmg;
    }

    default public void savedNBTData(NBTTagCompound compound) {
    }

    default public void loadNBTData(NBTTagCompound compound) {
    }
}

