/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races.titan;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.init.Abilities;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.network.IncreasedReachPacket;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.titan.config.TitanConfig;
import xzeroair.trinkets.traits.abilities.other.AbilityHeavy;
import xzeroair.trinkets.traits.abilities.other.AbilityLargeHands;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.RayTraceHelper;

public class RaceTitan
extends EntityRacePropertiesHandler {
    public static final TitanConfig serverConfig = TrinketsConfig.SERVER.races.titan;
    public static List<String> disallowedMounts = Arrays.asList(RaceTitan.serverConfig.mountBlacklist);
    private float cooldown = 0.0f;
    float ls;
    float pls = 0.0f;

    public RaceTitan(@Nonnull EntityLivingBase e, EntityProperties properties) {
        super(e, properties, EntityRaces.titan);
        disallowedMounts = Arrays.asList(RaceTitan.serverConfig.mountBlacklist);
    }

    @Override
    public void startTransformation() {
        this.addAbility(Abilities.largeHands, new AbilityLargeHands());
        if (RaceTitan.serverConfig.sink) {
            this.addAbility(Abilities.heavy, new AbilityHeavy());
        }
    }

    @Override
    public void onTick() {
        super.onTick();
        this.cooldown = this.cooldown > 0.0f ? (this.cooldown -= 1.0f) : 0.0f;
    }

    @Override
    public void whileTransformed() {
        Entity mount;
        if (!this.entity.field_70170_p.field_72995_K && this.entity.func_184218_aH() && (mount = this.entity.func_184187_bx()) != null && !this.mountEntity(mount)) {
            this.entity.func_184210_p();
        }
    }

    @Override
    public boolean mountEntity(Entity mount) {
        if (this.isCreativePlayer()) {
            return true;
        }
        if (!RaceTitan.serverConfig.canMount) {
            return false;
        }
        if (!disallowedMounts.isEmpty()) {
            try {
                ResourceLocation regName = EntityRegistry.getEntry(mount.getClass()).getRegistryName();
                String modID = regName.func_110624_b();
                String entityID = regName.func_110623_a();
                boolean doesWildcardExist = disallowedMounts.contains(modID + ":*");
                boolean exists = disallowedMounts.contains(regName.toString());
                if (doesWildcardExist || exists) {
                    return RaceTitan.serverConfig.whitelist;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return !RaceTitan.serverConfig.whitelist;
        }
        return true;
    }

    @Override
    public void interact(PlayerInteractEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (Trinkets.proxy.getSide() == Side.CLIENT) {
            RayTraceResult result;
            if (this.cooldown != 0.0f) {
                return;
            }
            KeyBinding lClick = Minecraft.func_71410_x().field_71474_y.field_74312_F;
            KeyBinding rClick = Minecraft.func_71410_x().field_71474_y.field_74313_G;
            IAttributeInstance reach = player.func_110140_aT().func_111151_a(EntityPlayer.REACH_DISTANCE);
            if (reach.func_111126_e() > 5.0 && (result = RayTraceHelper.rayTrace((EntityLivingBase)player, reach.func_111126_e() * 0.8)) != null && result.field_72313_a == RayTraceResult.Type.ENTITY) {
                Entity entity = result.field_72308_g;
                Vec3d vec = result.field_72307_f;
                if (lClick.func_151470_d()) {
                    NetworkHandler.sendToServer(new IncreasedReachPacket((EntityLivingBase)player, EnumHand.MAIN_HAND, entity, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
                    this.cooldown = player.func_184818_cX();
                    Trinkets.proxy.renderEffect(3, player.func_130014_f_(), result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b + (double)(entity.field_70131_O * 0.5f), result.field_72307_f.field_72449_c, 0.0, 0.0, 0.0, 0, 1.0f, 1.0f);
                } else if (rClick.func_151470_d()) {
                    NetworkHandler.sendToServer(new IncreasedReachPacket((EntityLivingBase)player, EnumHand.OFF_HAND, entity, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doRenderPlayerPre(EntityPlayer entity, double x, double y, double z, RenderPlayer renderer, float partialTick) {
        if (entity.func_184218_aH()) {
            double t = 0.0;
            t = (double)(100 - this.properties.getSize()) * 0.01;
            double t1 = (double)(entity.field_70131_O * 100.0f) / 180.0;
            double t2 = 180.0 / (double)(entity.field_70131_O * 100.0f);
            GlStateManager.func_179137_b((double)0.0, (double)(t *= t2 * 0.5), (double)0.0);
        }
    }
}

