/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.traits.abilities.base.AbilityBase;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IToggleAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigPolarizedStone;
import xzeroair.trinkets.util.handlers.TickHandler;

public class AbilityRepel
extends AbilityBase
implements ITickableAbility,
IToggleAbility {
    private static final ConfigPolarizedStone serverConfig = TrinketsConfig.SERVER.Items.POLARIZED_STONE;

    @Override
    public void tickAbility(EntityLivingBase entity) {
        if (this.enabled) {
            MagicStats magic;
            if (AbilityRepel.serverConfig.exhaustion && (magic = Capabilities.getMagicStats((Entity)entity)) != null) {
                float exhaustRate = AbilityRepel.serverConfig.exhaust_rate;
                TickHandler counter = this.getCounter("repel.ticks", AbilityRepel.serverConfig.exhaust_ticks, false);
                if (exhaustRate <= magic.getMana()) {
                    if (counter.Tick()) {
                        magic.spendMana(exhaustRate);
                    }
                } else {
                    return;
                }
            }
            AxisAlignedBB bBox = entity.func_174813_aQ();
            List entityList = entity.field_70170_p.func_72872_a(Entity.class, bBox.func_186662_g(1.1));
            for (Entity repelledEntity : entityList) {
                if (repelledEntity == null || repelledEntity instanceof EntityPlayer) continue;
                String e = EntityRegistry.getEntry(repelledEntity.getClass()).getRegistryName().toString();
                for (String s : AbilityRepel.serverConfig.repelledEntities) {
                    if (!e.equalsIgnoreCase(s)) continue;
                    Vec3d playerVec3 = entity.func_70040_Z();
                    repelledEntity.field_70159_w = playerVec3.field_72450_a * 0.3;
                    repelledEntity.field_70181_x = playerVec3.field_72448_b * 0.3;
                    repelledEntity.field_70179_y = playerVec3.field_72449_c * 0.3;
                }
            }
        }
    }

    @Override
    public boolean abilityEnabled() {
        return this.enabled;
    }

    @Override
    public IToggleAbility toggleAbility(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public IToggleAbility toggleAbility(int value) {
        this.value = value;
        return this;
    }
}

