/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import net.minecraft.block.Block;
import net.minecraft.block.BlockObsidian;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import xzeroair.trinkets.races.dwarf.config.DwarfConfig;
import xzeroair.trinkets.traits.abilities.base.AbilityBase;
import xzeroair.trinkets.traits.abilities.interfaces.IMiningAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.BlockHelper;

public class AbilitySkilledMiner
extends AbilityBase
implements IMiningAbility {
    public static final DwarfConfig serverConfig = TrinketsConfig.SERVER.races.dwarf;

    @Override
    public ImmutablePair<Boolean, Float> breakingBlock(EntityLivingBase entity, IBlockState state, BlockPos pos, float originalSpeed, float newSpeed) {
        if (AbilitySkilledMiner.serverConfig.static_mining) {
            ItemStack heldItemStack = entity.func_184614_ca();
            Item heldItem = heldItemStack.func_77973_b();
            int toolLevel = heldItem.getHarvestLevel(heldItemStack, "pickaxe", null, state);
            int level = state.func_177230_c().getHarvestLevel(state);
            float hardness = state.func_185887_b(entity.field_70170_p, pos);
            if (!heldItem.getToolClasses(heldItemStack).isEmpty() && heldItem.getToolClasses(heldItemStack).contains("pickaxe") && (toolLevel >= level || toolLevel == level - 1)) {
                newSpeed = hardness * 4.0f;
            }
        }
        return new ImmutablePair((Object)false, (Object)Float.valueOf(newSpeed));
    }

    @Override
    public ImmutablePair<Boolean, Integer> brokeBlock(EntityLivingBase entity, World world, IBlockState state, BlockPos pos, int expToDrop) {
        boolean silkTouching;
        ItemStack heldItemStack = entity.func_184614_ca();
        Item heldItem = heldItemStack.func_77973_b();
        Block block = state.func_177230_c();
        int blockLevel = block.getHarvestLevel(state);
        int toolLevel = heldItem.getHarvestLevel(heldItemStack, "pickaxe", null, state);
        boolean bl = silkTouching = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)heldItemStack) > 0;
        if (!heldItem.getToolClasses(heldItemStack).isEmpty() && heldItem.getToolClasses(heldItemStack).contains("pickaxe")) {
            if (!silkTouching && AbilitySkilledMiner.serverConfig.BLOCKS.bonus_exp) {
                int bonusExp = AbilitySkilledMiner.serverConfig.BLOCKS.bonus_exp_max;
                int min = AbilitySkilledMiner.serverConfig.BLOCKS.bonus_exp_min;
                int rXP = this.random.nextInt(bonusExp);
                int xp = MathHelper.func_76125_a((int)rXP, (int)min, (int)(rXP + min));
                int exp = state.func_177230_c().getExpDrop(state, (IBlockAccess)entity.field_70170_p, pos, EnchantmentHelper.func_185283_h((EntityLivingBase)entity));
                if (BlockHelper.isBlockInList(world, state, pos, AbilitySkilledMiner.serverConfig.BLOCKS.xPBlocks)) {
                    expToDrop = exp + xp;
                }
                if (AbilitySkilledMiner.serverConfig.BLOCKS.minXpBlocks && BlockHelper.isBlockInList(world, state, pos, AbilitySkilledMiner.serverConfig.BLOCKS.MinBlocks)) {
                    expToDrop = exp + 1;
                }
            }
            if (toolLevel == blockLevel - 1 && AbilitySkilledMiner.serverConfig.skilled_miner) {
                TileEntity tile = world.func_175625_s(pos);
                if (block instanceof BlockOre || block instanceof BlockRedstoneOre || block instanceof BlockQuartz || block instanceof BlockObsidian) {
                    block.func_176206_d(world, pos, state);
                    block.func_180657_a(world, (EntityPlayer)entity, pos, state, tile, heldItemStack);
                    block.func_180637_b(world, pos, expToDrop);
                    expToDrop = 0;
                }
            }
        }
        return new ImmutablePair((Object)false, (Object)expToDrop);
    }
}

