/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities.other;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.tuple.ImmutablePair;
import xzeroair.trinkets.races.titan.config.TitanConfig;
import xzeroair.trinkets.traits.abilities.base.AbilityBase;
import xzeroair.trinkets.traits.abilities.interfaces.IAttackAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IMiningAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ConfigHelper;

public class AbilityLargeHands
extends AbilityBase
implements IAttackAbility,
IMiningAbility {
    public static final TitanConfig serverConfig = TrinketsConfig.SERVER.races.titan;

    @Override
    public float hurtEntity(EntityLivingBase target, DamageSource source, float dmg) {
        if (this.isIndirectDamage(source)) {
            return dmg;
        }
        Entity attacker = source.func_76346_g();
        AxisAlignedBB bb = target.func_174813_aQ().func_186662_g(1.0);
        Predicate Targets = Predicates.and((Predicate)EntitySelectors.field_180132_d, ent -> ent != null && ent.func_70067_L() && ent != attacker && ent != target && ent.func_145782_y() != target.func_145782_y());
        List splash = target.func_130014_f_().func_175647_a(Entity.class, bb, Targets);
        Object sSource = DamageSource.field_76377_j;
        if (attacker instanceof EntityLivingBase) {
            sSource = attacker instanceof EntityPlayer ? new EntityDamageSourceIndirect("player", attacker, attacker) : DamageSource.func_188403_a((Entity)attacker, (EntityLivingBase)((EntityLivingBase)attacker));
        }
        for (Entity hit : splash) {
            hit.func_70097_a(sSource, dmg * 0.25f);
        }
        return dmg;
    }

    @Override
    public ImmutablePair<Boolean, Integer> brokeBlock(EntityLivingBase entity, World world, IBlockState state, BlockPos pos, int expToDrop) {
        if (!(entity instanceof EntityPlayer) || this.isCreativePlayer((Entity)entity)) {
            return null;
        }
        if (!AbilityLargeHands.serverConfig.miningExtend || AbilityLargeHands.serverConfig.miningExtendInverted && !entity.func_70093_af() || !AbilityLargeHands.serverConfig.miningExtendInverted && entity.func_70093_af()) {
            return null;
        }
        for (String s : AbilityLargeHands.serverConfig.miningAoEBlacklist) {
            ConfigHelper.ItemObjectHolder object = ConfigHelper.parseConfigItem(s);
            if (object == null || !ConfigHelper.checkBlockInConfig(state, s)) continue;
            return null;
        }
        BlockPos pos1 = pos.func_177982_a(-1, -1, -1);
        BlockPos pos2 = pos.func_177982_a(1, 1, 1);
        ItemStack heldItemStack = entity instanceof EntityPlayer ? ((EntityPlayer)entity).field_71071_by.func_70448_g() : entity.func_184607_cu();
        Iterable blockList = BlockPos.func_177980_a((BlockPos)pos1, (BlockPos)pos2);
        blockList.forEach(block -> this.shouldHarvestBlock((EntityPlayer)entity, heldItemStack, world, state, pos, (BlockPos)block));
        return new ImmutablePair((Object)false, (Object)expToDrop);
    }

    public void shouldHarvestBlock(EntityPlayer entity, ItemStack harvestTool, World world, IBlockState harvestedBlockState, BlockPos harvestedPos, BlockPos targetPos) {
        boolean redstone2;
        IBlockState targetBlockState = world.func_180495_p(targetPos);
        if (harvestedPos.equals((Object)targetPos) || world.func_175625_s(targetPos) != null || world.func_175623_d(targetPos)) {
            return;
        }
        boolean redstone1 = targetBlockState.func_177230_c() == Blocks.field_150450_ax || targetBlockState.func_177230_c() == Blocks.field_150439_ay;
        boolean bl = redstone2 = harvestedBlockState.func_177230_c() == Blocks.field_150439_ay || harvestedBlockState.func_177230_c() == Blocks.field_150450_ax;
        if (targetBlockState.func_177230_c() != harvestedBlockState.func_177230_c()) {
            if (redstone2) {
                if (!redstone1) {
                    return;
                }
            } else {
                return;
            }
        }
        if (!redstone2 && harvestedBlockState.func_177230_c().func_176201_c(harvestedBlockState) != targetBlockState.func_177230_c().func_176201_c(targetBlockState)) {
            return;
        }
        if (ForgeHooks.canHarvestBlock((Block)targetBlockState.func_177230_c(), (EntityPlayer)entity, (IBlockAccess)world, (BlockPos)targetPos) && targetBlockState.func_177230_c().removedByPlayer(targetBlockState, world, targetPos, entity, true)) {
            targetBlockState.func_177230_c().func_176206_d(world, targetPos, targetBlockState);
            targetBlockState.func_177230_c().func_180657_a(world, entity, targetPos, targetBlockState, world.func_175625_s(targetPos), harvestTool);
        }
    }
}

