/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.config;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.CallHelper;

public class ConfigHelper {
    private static int wildcard = Short.MAX_VALUE;
    private static Map<String, ItemObjectHolder> magicRecoveryItems = new HashMap<String, ItemObjectHolder>();
    private static Map<String, ItemObjectHolder> dragonEyeBlocks = new HashMap<String, ItemObjectHolder>();

    public static double parseItemArmor(ItemStack stack, String[] configList) {
        if (stack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)stack.func_77973_b();
            String regName = armor.getRegistryName().toString().toLowerCase();
            ItemArmor.ArmorMaterial mat = armor.func_82812_d();
            boolean foundEntry = false;
            double itemWeight = TrinketsConfig.SERVER.races.faelis.penalty_amount;
            for (String string : configList) {
                String weightString;
                String[] entry = string.replace("[", ";").replace("]", "").split(";");
                int values = entry.length;
                if (values <= 0) continue;
                String itemOrMaterial = CallHelper.getStringFromArray(entry, 0);
                String regex = "[^*.\\d]";
                String metaOrWeight = CallHelper.getStringFromArray(entry, 1);
                String weight = CallHelper.getStringFromArray(entry, 2);
                if (itemOrMaterial.contains(":")) {
                    String weightString2;
                    if (!regName.contentEquals(itemOrMaterial.toLowerCase())) continue;
                    if (!metaOrWeight.contains(".")) {
                        String weightString3;
                        String metaString = metaOrWeight.replaceAll("[^*\\d]", "");
                        int meta = wildcard;
                        if (!metaString.contains("*")) {
                            meta = Integer.parseInt(metaString);
                        }
                        if (meta != wildcard && stack.func_77952_i() != meta) continue;
                        foundEntry = true;
                        if (values <= 2 || (weightString3 = weight.replaceAll("[^.\\d]", "")).isEmpty()) break;
                        itemWeight = Double.parseDouble(weightString3);
                        break;
                    }
                    foundEntry = true;
                    if (values <= 1 || (weightString2 = metaOrWeight.replaceAll("[^.\\d]", "")).isEmpty()) break;
                    itemWeight = Double.parseDouble(weightString2);
                    break;
                }
                if (!mat.toString().toLowerCase().contentEquals(itemOrMaterial.toLowerCase().replaceFirst("material", ""))) continue;
                String weightOrPart = metaOrWeight.replaceAll("[^.\\d]", "");
                if (!weightOrPart.isEmpty()) {
                    foundEntry = true;
                    itemWeight = Double.parseDouble(weightOrPart);
                    break;
                }
                String partString = metaOrWeight.replaceAll("[^\\D]", "");
                if (partString.isEmpty() || !armor.field_77881_a.func_188450_d().equalsIgnoreCase(partString.replace("boot", "feet").replace("boots", "feet").replace("feets", "feet").replace("leggings", "legs").replace("pants", "legs").replace("chestplate", "chest").replace("shirt", "chest").replace("helm", "head").replace("hat", "head"))) continue;
                foundEntry = true;
                if (values <= 2 || (weightString = weight.replaceAll("[^.\\d]", "")).isEmpty()) break;
                itemWeight = Double.parseDouble(weightString);
                break;
            }
            if (foundEntry) {
                return itemWeight;
            }
            return 0.0;
        }
        return 0.0;
    }

    public static Map<String, ItemObjectHolder> parseConfigList(String[] configList) {
        HashMap<String, ItemObjectHolder> map = new HashMap<String, ItemObjectHolder>();
        for (String item : configList) {
            ItemObjectHolder object = ConfigHelper.parseConfigItem(item);
            if (object == null || object.getObject().isEmpty() || map.containsKey(object.getObject() + ":" + object.getMeta())) continue;
            map.put(object.getObject() + ":" + object.getMeta(), object);
        }
        return map;
    }

    public static boolean checkBlockInConfig(IBlockState state, String configBlock) {
        if (state == null) {
            return false;
        }
        ResourceLocation regName = state.func_177230_c().getRegistryName();
        String modID = regName.func_110624_b();
        String itemID = regName.func_110623_a();
        ItemObjectHolder configObject = ConfigHelper.parseConfigItem(configBlock);
        if (configObject == null) {
            return false;
        }
        boolean modWildcard = configObject.getModID().equalsIgnoreCase("*");
        boolean itemWildcard = configObject.getItemID().equalsIgnoreCase("*");
        if (modWildcard && itemWildcard) {
            return false;
        }
        boolean metaMatches = configObject.getMeta() == wildcard || state.func_177230_c().func_176201_c(state) == configObject.getMeta();
        boolean isObjectCorrect = false;
        if (modWildcard || modID.equalsIgnoreCase(configObject.getModID())) {
            if (itemWildcard) {
                isObjectCorrect = true;
            } else if (!itemWildcard && configObject.getItemID().contains("*")) {
                String regex = configObject.getItemID().replace("*", "");
                boolean startWildcard = configObject.getItemID().startsWith("*");
                boolean endWildcard = configObject.getItemID().endsWith("*");
                isObjectCorrect = startWildcard && endWildcard ? itemID.contains(regex) && metaMatches : (endWildcard ? itemID.startsWith(regex) && metaMatches : (startWildcard ? itemID.endsWith(regex) && metaMatches : false));
            } else {
                isObjectCorrect = itemID.equalsIgnoreCase(configObject.getItemID()) ? metaMatches : false;
            }
        }
        return isObjectCorrect;
    }

    public static boolean checkItemInConfig(ItemStack stack, String configItemStack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        ResourceLocation regName = stack.func_77973_b().getRegistryName();
        String modID = regName.func_110624_b();
        String itemID = regName.func_110623_a();
        ItemObjectHolder configObject = ConfigHelper.parseConfigItem(configItemStack);
        if (configObject == null) {
            return false;
        }
        boolean modWildcard = configObject.getModID().equalsIgnoreCase("*");
        boolean itemWildcard = configObject.getItemID().equalsIgnoreCase("*");
        if (modWildcard && itemWildcard) {
            return false;
        }
        boolean metaMatches = configObject.getMeta() == wildcard || stack.func_77952_i() == configObject.getMeta();
        boolean isObjectCorrect = false;
        if (modWildcard || modID.equalsIgnoreCase(configObject.getModID())) {
            if (itemWildcard) {
                isObjectCorrect = true;
            } else if (!itemWildcard && configObject.getItemID().contains("*")) {
                String regex = configObject.getItemID().replace("*", "");
                boolean startWildcard = configObject.getItemID().startsWith("*");
                boolean endWildcard = configObject.getItemID().endsWith("*");
                isObjectCorrect = startWildcard && endWildcard ? itemID.contains(regex) && metaMatches : (endWildcard ? itemID.startsWith(regex) && metaMatches : (startWildcard ? itemID.endsWith(regex) && metaMatches : false));
            } else {
                isObjectCorrect = itemID.equalsIgnoreCase(configObject.getItemID()) ? metaMatches : false;
            }
        }
        return isObjectCorrect;
    }

    public static ItemObjectHolder parseConfigItem(String configItem) {
        try {
            String[] itemConfig = configItem.replace("|", ";").trim().split(";");
            String params = "";
            int meta = wildcard;
            String itemString = CallHelper.getStringFromArray(itemConfig, 0);
            String metaString = CallHelper.getStringFromArray(itemConfig, 1);
            if (!itemString.isEmpty()) {
                if (!metaString.isEmpty()) {
                    meta = metaString.contentEquals("*") || metaString.contentEquals(wildcard + "") ? wildcard : Integer.parseInt(metaString);
                }
                if (itemConfig.length > 2) {
                    for (int i = 2; i < itemConfig.length; ++i) {
                        String splitter = i == itemConfig.length - 1 ? "" : ";";
                        params = params + itemConfig[i] + splitter;
                    }
                }
                return new ItemObjectHolder(itemString, meta, params.split(";"));
            }
            return null;
        }
        catch (Exception e) {
            Trinkets.log.error("Failed to get ConfigObject: " + configItem);
            return null;
        }
    }

    public static void parseConfigThing(Object obj, String config) {
    }

    public static void initConfigLists() {
        magicRecoveryItems = ConfigHelper.parseConfigList(TrinketsConfig.SERVER.mana.recovery);
    }

    public static Map<String, ItemObjectHolder> getMagicRecoveryItems() {
        if (magicRecoveryItems == null) {
            magicRecoveryItems = ConfigHelper.parseConfigList(TrinketsConfig.SERVER.mana.recovery);
        }
        return magicRecoveryItems;
    }

    public static Map<String, ItemObjectHolder> getDragonsEyeBlocks() {
        if (dragonEyeBlocks == null) {
            dragonEyeBlocks = ConfigHelper.parseConfigList(TrinketsConfig.SERVER.mana.recovery);
        }
        return dragonEyeBlocks;
    }

    public static AttributeHolder parseAttributeConfig(String attribute) {
        try {
            String[] itemConfig = attribute.replace("|", ";").trim().split(";");
            String attributeName = CallHelper.getStringFromArray(itemConfig, 0);
            String attributeValue = CallHelper.getStringFromArray(itemConfig, 1);
            String attributeOperation = CallHelper.getStringFromArray(itemConfig, 2);
            String attributeSaved = CallHelper.getStringFromArray(itemConfig, 3);
            String name = "";
            double amount = 0.0;
            int operation = 0;
            boolean isSaved = true;
            if (!attributeName.isEmpty()) {
                String value;
                if (!attributeValue.isEmpty() && !(value = attributeValue.replaceAll("[^.\\d]", "")).isEmpty()) {
                    amount = Double.parseDouble(value);
                }
                if (!attributeOperation.isEmpty()) {
                    value = attributeOperation.replaceAll("[^\\d]", "");
                    if (!value.isEmpty()) {
                        operation = Integer.parseInt(value);
                    } else if (attributeOperation.equalsIgnoreCase("multiply")) {
                        operation = 2;
                    } else if (attributeOperation.equalsIgnoreCase("multiply_base")) {
                        operation = 1;
                    }
                }
                if (!attributeSaved.isEmpty() && attributeSaved.equalsIgnoreCase("false")) {
                    isSaved = false;
                }
                if (operation < 0) {
                    operation = 0;
                }
                if (operation > 2) {
                    operation = 2;
                }
                return new AttributeHolder("", amount, operation, isSaved);
            }
            return null;
        }
        catch (Exception e) {
            Trinkets.log.error("Failed to get ConfigObject: " + attribute);
            return null;
        }
    }

    public static class AttributeHolder {
        private String name;
        private double amount;
        private int operation;
        private boolean isSaved;

        public AttributeHolder(String name, double amount, int operation, boolean isSaved) {
            this.name = name;
            this.amount = amount;
            this.operation = operation;
            this.isSaved = isSaved;
        }
    }

    public static class ItemObjectHolder {
        private int meta;
        private String[] params;
        private String object;
        private String modID;
        private String itemID;

        public ItemObjectHolder() {
            this.meta = Short.MAX_VALUE;
            this.params = new String[0];
        }

        public ItemObjectHolder(String object, int meta, String ... params) {
            this.object = object;
            this.parseItem(object);
            this.meta = meta;
            this.params = params;
        }

        public String getObject() {
            return this.object;
        }

        public String getModID() {
            return this.modID;
        }

        public String getItemID() {
            return this.itemID;
        }

        public int getMeta() {
            return this.meta;
        }

        public String[] getParams() {
            return this.params;
        }

        public ItemObjectHolder setObject(String object) {
            this.object = object;
            return this;
        }

        public ItemObjectHolder setMeta(int meta) {
            this.meta = meta;
            return this;
        }

        public ItemObjectHolder setParams(String ... params) {
            this.params = params;
            return this;
        }

        private void parseItem(String item) {
            try {
                if (item.isEmpty()) {
                    this.modID = "minecraft";
                    this.itemID = "air";
                    return;
                }
                if (item.contains(":")) {
                    String[] vals = item.split(":");
                    this.modID = !vals[0].isEmpty() ? vals[0] : "minecraft";
                    this.itemID = !vals[1].isEmpty() ? vals[1] : "air";
                } else {
                    this.modID = "minecraft";
                    this.itemID = item;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

