/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.handlers;

import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import xzeroair.trinkets.attributes.JumpAttribute;
import xzeroair.trinkets.attributes.UpdatingAttribute;
import xzeroair.trinkets.races.EntityRace;
import xzeroair.trinkets.races.RaceAttributesWrapper;
import xzeroair.trinkets.util.interfaces.IAttributeConfigHelper;

public class RaceAttributeHandler {
    private UpdatingAttribute armor;
    private UpdatingAttribute attackDamage;
    private UpdatingAttribute attackSpeed;
    private UpdatingAttribute health;
    private UpdatingAttribute knockback;
    private UpdatingAttribute movementSpeed;
    private UpdatingAttribute armorToughness;
    private UpdatingAttribute swimSpeed;
    private UpdatingAttribute luck;
    private UpdatingAttribute reach;
    private UpdatingAttribute jump;
    private UpdatingAttribute stepHeight;
    private RaceAttributesWrapper attributes;

    public RaceAttributeHandler(EntityRace race) {
        this.armor = new UpdatingAttribute(race.getUUID(), SharedMonsterAttributes.field_188791_g).setSavedInNBT(false);
        this.attackDamage = new UpdatingAttribute(race.getUUID(), SharedMonsterAttributes.field_111264_e).setSavedInNBT(false);
        this.attackSpeed = new UpdatingAttribute(race.getUUID(), SharedMonsterAttributes.field_188790_f).setSavedInNBT(false);
        this.health = new UpdatingAttribute(race.getUUID(), SharedMonsterAttributes.field_111267_a).setSavedInNBT(false);
        this.knockback = new UpdatingAttribute(race.getUUID(), SharedMonsterAttributes.field_111266_c).setSavedInNBT(false);
        this.movementSpeed = new UpdatingAttribute(race.getUUID(), SharedMonsterAttributes.field_111263_d).setSavedInNBT(false);
        this.armorToughness = new UpdatingAttribute(race.getUUID(), SharedMonsterAttributes.field_189429_h).setSavedInNBT(false);
        this.swimSpeed = new UpdatingAttribute(race.getUUID(), EntityLivingBase.SWIM_SPEED).setSavedInNBT(false);
        this.luck = new UpdatingAttribute(race.getUUID(), SharedMonsterAttributes.field_188792_h).setSavedInNBT(false);
        this.reach = new UpdatingAttribute(race.getUUID(), EntityPlayer.REACH_DISTANCE).setSavedInNBT(false);
        this.jump = new UpdatingAttribute(race.getUUID(), JumpAttribute.Jump).setSavedInNBT(false);
        this.stepHeight = new UpdatingAttribute(race.getUUID(), JumpAttribute.stepHeight).setSavedInNBT(false);
        this.attributes = race.getRaceAttributes();
    }

    public RaceAttributeHandler(UUID uuid, IAttributeConfigHelper attributeConfig) {
        this.armor = new UpdatingAttribute(uuid, SharedMonsterAttributes.field_188791_g).setSavedInNBT(false);
        this.attackDamage = new UpdatingAttribute(uuid, SharedMonsterAttributes.field_111264_e).setSavedInNBT(false);
        this.attackSpeed = new UpdatingAttribute(uuid, SharedMonsterAttributes.field_188790_f).setSavedInNBT(false);
        this.health = new UpdatingAttribute(uuid, SharedMonsterAttributes.field_111267_a).setSavedInNBT(false);
        this.knockback = new UpdatingAttribute(uuid, SharedMonsterAttributes.field_111266_c).setSavedInNBT(false);
        this.movementSpeed = new UpdatingAttribute(uuid, SharedMonsterAttributes.field_111263_d).setSavedInNBT(false);
        this.armorToughness = new UpdatingAttribute(uuid, SharedMonsterAttributes.field_189429_h).setSavedInNBT(false);
        this.swimSpeed = new UpdatingAttribute(uuid, EntityLivingBase.SWIM_SPEED).setSavedInNBT(false);
        this.luck = new UpdatingAttribute(uuid, SharedMonsterAttributes.field_188792_h).setSavedInNBT(false);
        this.reach = new UpdatingAttribute(uuid, EntityPlayer.REACH_DISTANCE).setSavedInNBT(false);
        this.jump = new UpdatingAttribute(uuid, JumpAttribute.Jump).setSavedInNBT(false);
        this.stepHeight = new UpdatingAttribute(uuid, JumpAttribute.stepHeight).setSavedInNBT(false);
        this.attributes = new RaceAttributesWrapper(attributeConfig);
    }

    private void setArmor(EntityLivingBase entity) {
        if (this.attributes.armorEnabled()) {
            double amount = this.attributes.getArmor();
            int operation = this.attributes.getArmorOperation();
            this.armor.addModifier(entity, amount, operation);
        } else {
            this.armor.removeModifier(entity);
        }
    }

    private void setAttackDamage(EntityLivingBase entity) {
        if (this.attributes.attackDamageEnabled()) {
            double amount = this.attributes.getAttackDamage();
            int operation = this.attributes.getAttackDamageOperation();
            this.attackDamage.addModifier(entity, amount, operation);
        } else {
            this.attackDamage.removeModifier(entity);
        }
    }

    private void setAttackSpeed(EntityLivingBase entity) {
        if (this.attributes.attackSpeedEnabled()) {
            double amount = this.attributes.getAttackSpeed();
            int operation = this.attributes.getAttackSpeedOperation();
            this.attackSpeed.addModifier(entity, amount, operation);
        } else {
            this.attackSpeed.removeModifier(entity);
        }
    }

    private void setHealth(EntityLivingBase entity) {
        if (this.attributes.healthEnabled()) {
            double amount = this.attributes.getHealth();
            int operation = this.attributes.getHealthOperation();
            this.health.addModifier(entity, amount, operation);
        } else {
            this.health.removeModifier(entity);
        }
    }

    private void setKnockback(EntityLivingBase entity) {
        if (this.attributes.knockbackEnabled()) {
            double amount = this.attributes.getKnockback();
            int operation = this.attributes.getKnockbackOperation();
            this.knockback.addModifier(entity, amount, operation);
        } else {
            this.knockback.removeModifier(entity);
        }
    }

    private void setMovementSpeed(EntityLivingBase entity) {
        if (this.attributes.movementSpeedEnabled()) {
            double amount = this.attributes.getMovementSpeed();
            int operation = this.attributes.getMovementSpeedOperation();
            this.movementSpeed.addModifier(entity, amount, operation);
        } else {
            this.movementSpeed.removeModifier(entity);
        }
    }

    private void setArmorToughness(EntityLivingBase entity) {
        if (this.attributes.armorToughnessEnabled()) {
            double amount = this.attributes.getArmorToughness();
            int operation = this.attributes.getArmorToughnessOperation();
            this.armorToughness.addModifier(entity, amount, operation);
        } else {
            this.armorToughness.removeModifier(entity);
        }
    }

    private void setSwimSpeed(EntityLivingBase entity) {
        if (this.attributes.swimSpeedEnabled()) {
            double amount = this.attributes.getSwimSpeed();
            int operation = this.attributes.getSwimSpeedOperation();
            this.swimSpeed.addModifier(entity, amount, operation);
        } else {
            this.swimSpeed.removeModifier(entity);
        }
    }

    private void setLuck(EntityLivingBase entity) {
        if (this.attributes.luckEnabled()) {
            double amount = this.attributes.getLuck();
            int operation = this.attributes.getLuckOperation();
            this.luck.addModifier(entity, amount, operation);
        } else {
            this.luck.removeModifier(entity);
        }
    }

    private void setReach(EntityLivingBase entity) {
        if (this.attributes.reachEnabled()) {
            double amount = this.attributes.getReach();
            int operation = this.attributes.getReachOperation();
            this.reach.addModifier(entity, amount, operation);
        } else {
            this.reach.removeModifier(entity);
        }
    }

    private void setJump(EntityLivingBase entity) {
        if (this.attributes.jumpEnabled()) {
            double amount = this.attributes.getJump();
            int operation = this.attributes.getJumpOperation();
            this.jump.addModifier(entity, amount, operation);
        } else {
            this.jump.removeModifier(entity);
        }
    }

    private void setStepHeight(EntityLivingBase entity) {
        if (this.attributes.stepHeightEnabled()) {
            double amount = this.attributes.getStepHeight();
            int operation = this.attributes.getStepHeightOperation();
            this.stepHeight.addModifier(entity, amount, operation);
        } else {
            this.stepHeight.removeModifier(entity);
        }
    }

    public void addAttributes(EntityLivingBase entity) {
        this.setArmor(entity);
        this.setArmorToughness(entity);
        this.setAttackDamage(entity);
        this.setAttackSpeed(entity);
        this.setHealth(entity);
        this.setKnockback(entity);
        this.setMovementSpeed(entity);
        this.setSwimSpeed(entity);
        this.setLuck(entity);
        if (entity instanceof EntityPlayer) {
            this.setReach(entity);
        }
        this.setJump(entity);
        this.setStepHeight(entity);
    }

    public void removeAttibutes(EntityLivingBase entity) {
        this.armor.removeModifier(entity);
        this.attackDamage.removeModifier(entity);
        this.attackSpeed.removeModifier(entity);
        this.health.removeModifier(entity);
        this.knockback.removeModifier(entity);
        this.movementSpeed.removeModifier(entity);
        this.armorToughness.removeModifier(entity);
        this.swimSpeed.removeModifier(entity);
        this.luck.removeModifier(entity);
        if (entity instanceof EntityPlayer) {
            this.reach.removeModifier(entity);
        }
        this.jump.removeModifier(entity);
        this.stepHeight.removeModifier(entity);
    }
}

