/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.helpers;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CallHelper {
    public static String combineStringArray(String[] array) {
        if (array.length > 0) {
            String combinedArray = "";
            for (int i = array.length - 1; i >= 0; --i) {
                combinedArray = array[i] + ", " + combinedArray;
            }
            return combinedArray;
        }
        return "";
    }

    public static String[] deconstructStringArray(String string) {
        String[] stringArray = string.split(", ");
        return stringArray;
    }

    public static String getStringFromArray(String[] array, int index) {
        if (index >= 0 && index < array.length) {
            return array[index];
        }
        return "";
    }

    public static String formatConfigString(Object ... options) {
        String returnString = "";
        for (Object obj : options) {
            if (!returnString.isEmpty()) {
                returnString = returnString + ";";
            }
            if (obj instanceof String) {
                returnString = returnString + obj;
            }
            if (obj instanceof Boolean) {
                returnString = returnString + "b=" + obj;
            }
            if (obj instanceof Integer) {
                returnString = returnString + "i=" + obj;
            }
            if (obj instanceof Float) {
                returnString = returnString + "f=" + obj;
            }
            if (!(obj instanceof Double)) continue;
            returnString = returnString + "d=" + obj;
        }
        return returnString;
    }

    public static double getDoubleFromString(String string) {
        if (string.startsWith("d=")) {
            try {
                return Double.parseDouble(string.replaceFirst("d=", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0.0;
    }

    public static int getIntegerFromString(String string) {
        if (string.startsWith("i=")) {
            try {
                return Integer.parseInt(string.replaceFirst("i=", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Integer.MIN_VALUE;
    }

    public static float getFloatFromString(String string) {
        if (string.startsWith("f=")) {
            try {
                return Float.parseFloat(string.replaceFirst("f=", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public static boolean getBooleanFromString(String string) {
        if (string.startsWith("b=")) {
            try {
                return Boolean.parseBoolean(string.replaceFirst("b=", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static void sendMessageToPlayer(Entity entity, String msg, boolean onScreen) {
        if (entity instanceof EntityPlayer && !msg.isEmpty()) {
            TextComponentString message = new TextComponentString(msg);
            ((EntityPlayer)entity).func_146105_b((ITextComponent)message, onScreen);
        }
    }
}

