/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.helpers;

public class ColorHelper {
    private String hexColor;
    private int decimalColor;
    private float r = 1.0f;
    private float g = 1.0f;
    private float b = 1.0f;
    private float a = 1.0f;

    public ColorHelper setAlpha(float f) {
        this.a = f;
        return this;
    }

    public ColorHelper setColor(String string) {
        if (string.startsWith("#")) {
            this.hexColor = string;
            this.setHexColor();
        } else if (!string.replaceAll("[\\D]", "").isEmpty()) {
            this.decimalColor = Integer.parseInt(string.replaceAll("[\\D]", ""));
            this.setDecimalColor();
        }
        return this;
    }

    public ColorHelper setColor(int color) {
        this.decimalColor = color;
        this.hexColor = this.convertColorToHexadeimal(this.decimalColor);
        this.r = (float)((this.decimalColor & 0xFF0000) >> 16) / 255.0f;
        this.g = (float)((this.decimalColor & 0xFF00) >> 8) / 255.0f;
        this.b = (float)((this.decimalColor & 0xFF) >> 0) / 255.0f;
        return this;
    }

    public ColorHelper setColorFromRGB(int r, int g, int b) {
        this.setColor(0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
        this.setHexColor(this.convertColorToHexadeimal(this.decimalColor));
        return this;
    }

    private ColorHelper setColorFromRGBFloat(float r, float g, float b) {
        this.setColorFromRGB((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
        return this;
    }

    public ColorHelper setRed(float r) {
        this.setColorFromRGBFloat(r, this.g, this.b);
        return this;
    }

    public ColorHelper setGreen(float g) {
        this.setColorFromRGBFloat(this.r, g, this.b);
        return this;
    }

    public ColorHelper setBlue(float b) {
        this.setColorFromRGBFloat(this.r, this.g, b);
        return this;
    }

    public int getDecimal() {
        return this.decimalColor;
    }

    public String getHex() {
        return this.hexColor;
    }

    private String convertColorToHexadeimal(int color) {
        String hex = Integer.toHexString(color & 0xFFFFFF);
        if (hex.length() < 6) {
            if (hex.length() == 5) {
                hex = "0" + hex;
            }
            if (hex.length() == 4) {
                hex = "00" + hex;
            }
            if (hex.length() == 3) {
                hex = "000" + hex;
            }
        }
        hex = "#" + hex;
        return hex;
    }

    private int getDecimalFromHex(String color) {
        if (!color.isEmpty()) {
            boolean CheckforHash = !color.startsWith("#");
            this.hexColor = CheckforHash ? "#" + color : color.toLowerCase();
            try {
                int length = this.hexColor.length();
                if (this.hexColor.length() >= 7) {
                    length = 7;
                }
                int i = Integer.decode(this.hexColor.substring(0, length));
                return i;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private void setHexColor(String color) {
        if (!color.isEmpty()) {
            boolean CheckforHash = !color.startsWith("#");
            this.hexColor = CheckforHash ? "#" + color : color.toLowerCase();
            try {
                int i;
                int length = this.hexColor.length();
                if (this.hexColor.length() >= 7) {
                    length = 7;
                }
                this.decimalColor = i = Integer.decode(this.hexColor.substring(0, length)).intValue();
                this.r = (float)((i & 0xFF0000) >> 16) / 255.0f;
                this.g = (float)((i & 0xFF00) >> 8) / 255.0f;
                this.b = (float)((i & 0xFF) >> 0) / 255.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void setHexColor() {
        if (!this.hexColor.isEmpty()) {
            boolean CheckforHash = !this.hexColor.startsWith("#");
            this.hexColor = CheckforHash ? "#" + this.hexColor : this.hexColor.toLowerCase();
            try {
                int i;
                int length = this.hexColor.length();
                if (this.hexColor.length() >= 7) {
                    length = 7;
                }
                this.decimalColor = i = Integer.decode(this.hexColor.substring(0, length)).intValue();
                this.r = (float)((i & 0xFF0000) >> 16) / 255.0f;
                this.g = (float)((i & 0xFF00) >> 8) / 255.0f;
                this.b = (float)((i & 0xFF) >> 0) / 255.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void setDecimalColor() {
        this.hexColor = this.convertColorToHexadeimal(this.decimalColor);
        this.r = (float)((this.decimalColor & 0xFF0000) >> 16) / 255.0f;
        this.g = (float)((this.decimalColor & 0xFF00) >> 8) / 255.0f;
        this.b = (float)((this.decimalColor & 0xFF) >> 0) / 255.0f;
    }

    public float getRed() {
        return this.r;
    }

    public float getGreen() {
        return this.g;
    }

    public float getBlue() {
        return this.b;
    }

    public float getAlpha() {
        return this.a;
    }
}

