/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.helpers;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import xzeroair.trinkets.Trinkets;

public class RayTraceHelper {
    private static final Predicate<Entity> Targets = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, ent -> ent != null && ent.func_70067_L()});
    private static List<Vec3d> points = new ArrayList<Vec3d>();
    private static Vec3d first;
    private static Vec3d second;
    private static Vec3d third;
    private static Vec3d forth;

    public static RayTraceResult rayTrace(EntityLivingBase entity, double distance) {
        Vec3d start = entity.func_174824_e(1.0f);
        Vec3d lookVec = entity.func_70040_Z();
        Vec3d end = start.func_72441_c(lookVec.field_72450_a * distance, lookVec.field_72448_b * distance, lookVec.field_72449_c * distance);
        RayTraceResult result = RayTraceHelper.getRaytraceResult(entity, start, end, distance);
        return result;
    }

    private static RayTraceResult getRaytraceResult(EntityLivingBase entity, Vec3d start, Vec3d end, double distance) {
        Entity hitEntity;
        BlockPos pos;
        RayTraceResult result = entity.field_70170_p.func_147447_a(start, end, false, true, false);
        Vec3d lookVec = entity.func_70040_Z();
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && entity.field_70170_p.func_180495_p(pos = result.func_178782_a()).func_185890_d((IBlockAccess)entity.field_70170_p, pos) != Block.field_185506_k) {
            distance = result.field_72307_f.func_72438_d(start);
            end = start.func_72441_c(lookVec.field_72450_a * distance, lookVec.field_72448_b * distance, lookVec.field_72449_c * distance);
        }
        if ((hitEntity = RayTraceHelper.findEntityOnPath(entity, start, end, distance)) != null) {
            result = new RayTraceResult(hitEntity);
        }
        return result;
    }

    protected static Entity findEntityOnPath(EntityLivingBase entity, Vec3d start, Vec3d end, double distance) {
        Vec3d lookVec = entity.func_70040_Z();
        List targets = entity.field_70170_p.func_175674_a((Entity)entity, entity.func_174813_aQ().func_72321_a(lookVec.field_72450_a * distance, lookVec.field_72448_b * distance, lookVec.field_72449_c * distance).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, ent -> ent != null && ent.func_70067_L()));
        ArrayList<Pair> hitTargets = new ArrayList<Pair>();
        for (Entity target : targets) {
            double d3;
            AxisAlignedBB targetBB = target.func_174813_aQ().func_186662_g((double)target.func_70111_Y());
            if (targetBB.func_72318_a(start)) {
                hitTargets.add(Pair.of((Object)target, (Object)0.0));
                continue;
            }
            RayTraceResult targetResult = targetBB.func_72327_a(start, end);
            if (targetResult == null || !((d3 = start.func_72438_d(targetResult.field_72307_f)) < distance)) continue;
            hitTargets.add(Pair.of((Object)target, (Object)d3));
        }
        if (!hitTargets.isEmpty()) {
            hitTargets.sort(Comparator.comparing(Pair::getRight));
            Entity hitEntity = (Entity)((Pair)hitTargets.stream().findFirst().get()).getLeft();
            return hitEntity;
        }
        return null;
    }

    protected static Entity findEntityOnPath(EntityLivingBase entity, Vec3d start, Vec3d end) {
        Entity hitEntity = null;
        List list = entity.field_70170_p.func_175674_a((Entity)entity, entity.func_174813_aQ().func_72321_a(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y).func_186662_g(1.0), Targets);
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            if (entity1 == entity || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            hitEntity = entity1;
            d0 = d1;
        }
        return hitEntity;
    }

    public static void rayTraceEntity(Beam beam, Function<Entity, Boolean> consumer) {
        Vec3d start = beam.getStart();
        Vec3d lookVec = beam.getLookVec();
        Vec3d end = beam.getEnd();
        double dist = beam.getDist();
        World world = beam.getWorld();
        EntityLivingBase player = beam.getEntity();
        List targets = world.func_175674_a((Entity)player, player.func_174813_aQ().func_72321_a(lookVec.field_72450_a * dist, lookVec.field_72448_b * dist, lookVec.field_72449_c * dist).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, ent -> ent != null && ent.func_70067_L()));
        ArrayList<Pair> hitTargets = new ArrayList<Pair>();
        for (Entity target : targets) {
            double d3;
            AxisAlignedBB targetBB = target.func_174813_aQ().func_186662_g((double)target.func_70111_Y());
            if (targetBB.func_72318_a(start)) {
                hitTargets.add(Pair.of((Object)target, (Object)0.0));
                continue;
            }
            RayTraceResult targetResult = targetBB.func_72327_a(start, end);
            if (targetResult == null || !((d3 = start.func_72438_d(targetResult.field_72307_f)) < dist)) continue;
            hitTargets.add(Pair.of((Object)target, (Object)d3));
        }
        if (!hitTargets.isEmpty()) {
            hitTargets.sort(Comparator.comparing(Pair::getRight));
            hitTargets.stream().filter(pair -> (Boolean)consumer.apply((Entity)pair.getLeft())).findFirst();
        } else {
            consumer.apply(null);
        }
    }

    public static void drawLightning(Vec3d start, Vec3d end, World world, double dist, double density, float intensity) {
        int color = 2515356;
        Trinkets.proxy.renderEffect(1, world, start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c, 2515356, 0.9f, intensity);
        Trinkets.proxy.renderEffect(2, world, start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c, 2515356, 0.9f, intensity);
    }

    public static void drawPath(Vec3d start, Vec3d end, World world, Beam beam, int color, double density) {
        Random rand = new Random();
        double dist = beam.getDist();
        double r1 = rand.nextDouble() * (double)(rand.nextBoolean() ? -1 : 1);
        double r2 = rand.nextDouble() * (double)(rand.nextBoolean() ? -1 : 1);
        double r3 = rand.nextDouble() * (double)(rand.nextBoolean() ? -1 : 1);
        first = start;
        for (double done = 0.0; done < dist; done += density) {
            double alpha = done / dist;
            double x = RayTraceHelper.interpolate(end.field_72450_a + 0.5, start.field_72450_a, alpha);
            double y = RayTraceHelper.interpolate(end.field_72448_b + 0.5, start.field_72448_b, alpha);
            double z = RayTraceHelper.interpolate(end.field_72449_c + 0.5, start.field_72449_c, alpha);
            int widthRange = rand.nextInt(6) * (rand.nextBoolean() ? -1 : 1);
            int widthRange2 = rand.nextInt(3) * (rand.nextBoolean() ? -1 : 1);
            int widthRange3 = rand.nextInt(6) * (rand.nextBoolean() ? -1 : 1);
            double t1 = (float)widthRange * 0.1f;
            double t2 = (float)widthRange2 * 0.1f;
            double t3 = (float)widthRange3 * 0.1f;
            second = new Vec3d(x + r1, y + r2, z + r3);
            if (world.field_72995_K) {
                // empty if block
            }
            first = second;
        }
    }

    public static double interpolate(double start, double end, double alpha) {
        return start + (end - start) * alpha;
    }

    public static double interpolateReverse(double start, double end, double alpha) {
        return end + (end - start) * alpha;
    }

    public static class Beam {
        private final World world;
        private final EntityLivingBase player;
        private final double maxDist;
        private Vec3d start;
        private Vec3d lookVec;
        private Vec3d end;
        private double dist;
        private double accuracy;
        private final boolean canBreak;
        private final Random rand = new Random();

        public Beam(World world, EntityLivingBase player, double maxDist, double accuracy, boolean canBreak) {
            this.world = world;
            this.player = player;
            this.maxDist = maxDist;
            accuracy /= 2.0;
            this.canBreak = canBreak;
            this.calculate();
        }

        private void calculate() {
            BlockPos pos;
            float prevYaw = this.player.field_70177_z;
            float prevPitch = this.player.field_70125_A;
            this.start = this.player.func_174824_e(1.0f);
            this.player.field_70177_z = (float)((double)this.player.field_70177_z + (2.0 * this.accuracy * this.rand.nextDouble() - this.accuracy));
            this.player.field_70177_z %= 360.0f;
            this.player.field_70125_A = (float)((double)this.player.field_70125_A + (2.0 * this.accuracy * this.rand.nextDouble() - this.accuracy));
            this.lookVec = this.player.func_70040_Z();
            this.player.field_70177_z = prevYaw;
            this.player.field_70125_A = prevPitch;
            this.end = this.start.func_72441_c(this.lookVec.field_72450_a * this.maxDist, this.lookVec.field_72448_b * this.maxDist, this.lookVec.field_72449_c * this.maxDist);
            RayTraceResult result = this.world.func_72933_a(this.start, this.end);
            this.dist = this.maxDist;
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && this.world.func_180495_p(pos = result.func_178782_a()).func_185890_d((IBlockAccess)this.world, pos) != Block.field_185506_k) {
                if (!this.canBreak || !this.world.field_72995_K) {
                    // empty if block
                }
                this.dist = result.field_72307_f.func_72438_d(this.start);
                this.end = this.start.func_72441_c(this.lookVec.field_72450_a * this.dist, this.lookVec.field_72448_b * this.dist, this.lookVec.field_72449_c * this.dist);
            }
        }

        public Vec3d getStart() {
            return this.start;
        }

        public Vec3d getLookVec() {
            return this.lookVec;
        }

        public Vec3d getEnd() {
            return this.end;
        }

        public double getDist() {
            return this.dist;
        }

        public World getWorld() {
            return this.world;
        }

        public EntityLivingBase getEntity() {
            return this.player;
        }

        public double getMaxDist() {
            return this.maxDist;
        }
    }
}

