/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.helpers;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.attributes.AttributeConfigWrapper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.init.ModPotionTypes;
import xzeroair.trinkets.items.base.TrinketRaceBase;
import xzeroair.trinkets.items.foods.Mana_Crystal;
import xzeroair.trinkets.items.foods.Mana_Reagent;
import xzeroair.trinkets.items.trinkets.TrinketArcingOrb;
import xzeroair.trinkets.items.trinkets.TrinketDamageShield;
import xzeroair.trinkets.items.trinkets.TrinketDragonsEye;
import xzeroair.trinkets.items.trinkets.TrinketEnderTiara;
import xzeroair.trinkets.items.trinkets.TrinketFaelisClaws;
import xzeroair.trinkets.items.trinkets.TrinketGreaterInertia;
import xzeroair.trinkets.items.trinkets.TrinketInertiaNull;
import xzeroair.trinkets.items.trinkets.TrinketPoisonStone;
import xzeroair.trinkets.items.trinkets.TrinketPolarized;
import xzeroair.trinkets.items.trinkets.TrinketSeaStone;
import xzeroair.trinkets.items.trinkets.TrinketWitherRing;
import xzeroair.trinkets.races.dwarf.config.DwarfConfig;
import xzeroair.trinkets.races.elf.config.ElfConfig;
import xzeroair.trinkets.races.fairy.config.FairyConfig;
import xzeroair.trinkets.races.titan.config.TitanConfig;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigArcingOrb;
import xzeroair.trinkets.util.config.trinkets.ConfigDamageShield;
import xzeroair.trinkets.util.config.trinkets.ConfigDragonsEye;
import xzeroair.trinkets.util.config.trinkets.ConfigEnderCrown;
import xzeroair.trinkets.util.config.trinkets.ConfigFaelisClaw;
import xzeroair.trinkets.util.config.trinkets.ConfigPoisonStone;
import xzeroair.trinkets.util.config.trinkets.ConfigPolarizedStone;
import xzeroair.trinkets.util.config.trinkets.ConfigSeaStone;
import xzeroair.trinkets.util.config.trinkets.ConfigWitherRing;
import xzeroair.trinkets.util.helpers.CallHelper;
import xzeroair.trinkets.util.helpers.OreTrackingHelper;

public class TranslationHelper {
    private static TextFormatting black = TextFormatting.BLACK;
    private static TextFormatting white = TextFormatting.WHITE;
    private static TextFormatting red = TextFormatting.RED;
    private static TextFormatting dRed = TextFormatting.DARK_RED;
    private static TextFormatting blue = TextFormatting.BLUE;
    private static TextFormatting dBlue = TextFormatting.DARK_BLUE;
    private static TextFormatting green = TextFormatting.GREEN;
    private static TextFormatting dGreen = TextFormatting.DARK_GREEN;
    private static TextFormatting lPurple = TextFormatting.LIGHT_PURPLE;
    private static TextFormatting dPurple = TextFormatting.DARK_PURPLE;
    private static TextFormatting yellow = TextFormatting.YELLOW;
    private static TextFormatting aqua = TextFormatting.AQUA;
    private static TextFormatting dAqua = TextFormatting.DARK_AQUA;
    private static TextFormatting gray = TextFormatting.GRAY;
    private static TextFormatting dGray = TextFormatting.DARK_GRAY;
    private static TextFormatting gold = TextFormatting.GOLD;
    private static TextFormatting ST = TextFormatting.STRIKETHROUGH;
    private static TextFormatting UL = TextFormatting.UNDERLINE;
    private static TextFormatting italic = TextFormatting.ITALIC;
    private static TextFormatting bold = TextFormatting.BOLD;
    private static TextFormatting reset = TextFormatting.RESET;
    private static List<KeyEntry> keys;

    public static <T> void initTranslation(T object) {
        if (keys == null) {
            keys = new ArrayList<KeyEntry>();
        }
        if (!keys.isEmpty()) {
            keys.clear();
        }
        keys.add(new KeyEntry(TranslationHelper.isKeyBind("denvkb"), true, ModKeyBindings.DRAGONS_EYE_ABILITY.getDisplayName()));
        keys.add(new KeyEntry(TranslationHelper.isKeyBind("deofkb"), true, ModKeyBindings.DRAGONS_EYE_TARGET.getDisplayName()));
        keys.add(new KeyEntry(TranslationHelper.isKeyBind("arckb"), true, ModKeyBindings.ARCING_ORB_ABILITY.getDisplayName()));
        keys.add(new KeyEntry(TranslationHelper.isKeyBind("pskb"), true, ModKeyBindings.POLARIZED_STONE_ABILITY.getDisplayName()));
        keys.add(new KeyEntry(TranslationHelper.isKeyBind("rakb"), true, ModKeyBindings.RACE_ABILITY.getDisplayName()));
        keys.add(new KeyEntry(TranslationHelper.isKeyBind("auxkb"), true, ModKeyBindings.AUX_KEY.getDisplayName()));
        boolean isItemStack = object instanceof ItemStack;
        boolean isItem = object instanceof Item;
        if (isItemStack || isItem) {
            ItemStack stack;
            ItemStack itemStack = stack = isItemStack ? (ItemStack)object : ItemStack.field_190927_a;
            Item item = isItem ? (Item)object : (stack != null && !stack.func_190926_b() ? stack.func_77973_b() : null);
            TrinketsConfig.xServer.TrinketItems itemCfg = TrinketsConfig.SERVER.Items;
            if (item instanceof TrinketWitherRing) {
                keys.add(new KeyEntry(TranslationHelper.isOption("witherchance"), itemCfg.WITHER_RING.wither, MathHelper.func_76131_a((float)(1.0f / (float)itemCfg.WITHER_RING.wither_chance * 100.0f), (float)-2.1474836E9f, (float)2.1474836E9f) + "%"));
                keys.add(new KeyEntry(TranslationHelper.isOption("witherduration"), itemCfg.WITHER_RING.wither, itemCfg.WITHER_RING.wither_duration));
                keys.add(new KeyEntry(TranslationHelper.isOption("leechamount"), itemCfg.WITHER_RING.leech, Float.valueOf(itemCfg.WITHER_RING.leech_amount)));
            }
            if (item instanceof TrinketDragonsEye) {
                // empty if block
            }
        }
    }

    private static String isKeyBind(String key) {
        return "*" + key + ":";
    }

    private static String isOption(String key) {
        return "$" + key + ":";
    }

    private static String isLang(String key) {
        return "@" + key + ":";
    }

    public static String formatAddVariables(String string) {
        TranslationHelper.initTranslation(null);
        if (keys != null) {
            for (KeyEntry key : keys) {
                if (TranslationHelper.hasLangReplacement(key.key(), string)) {
                    string = TranslationHelper.langKeyReplace(string, key.enabled(), key.key(), key.option());
                }
                if (TranslationHelper.hasKey(key.key(), string)) {
                    string = TranslationHelper.optionReplace(string, key.enabled(), key.key(), key.option());
                }
                if (!TranslationHelper.hasKeyBind(key.key(), string)) continue;
                string = TranslationHelper.optionReplace(string, key.enabled(), key.key(), key.option());
            }
        }
        return string;
    }

    private static boolean hasKey(String key, String string) {
        return string.contains(key);
    }

    private static boolean hasKeyBind(String key, String string) {
        return string.contains("*" + key.toLowerCase() + ":");
    }

    private static boolean hasOption(String key, String string) {
        return string.contains("$" + key.toLowerCase() + ":");
    }

    private static boolean hasLangReplacement(String key, String string) {
        return string.contains("@" + key.replace("@", "").replace(":", "").toLowerCase() + ":");
    }

    private static String langKeyReplace(String string, boolean enabled, String key, String replacementKey) {
        if (enabled) {
            String translatedKey = new TextComponentTranslation(replacementKey, new Object[0]).func_150254_d();
            return string.replace(key, translatedKey);
        }
        return string.replace(key, "");
    }

    private static String optionReplace(String string, boolean enabled, String key, String Variable) {
        if (enabled) {
            return string.replace(key, Variable);
        }
        return string.replace(key, "");
    }

    private static boolean isStringEmpty(String string) {
        return string.replace("\u00ef\u00bf\u00bdr", "").replace("\u00ef\u00bf\u00bd6", "").replace("\u00ef\u00bf\u00bd", "").replace("\u00c2\u00a7r", "").replaceAll(" ", "").isEmpty();
    }

    public static void addToolTips(String translationKey, List<String> tooltips) {
        for (int i = 1; i < 10; ++i) {
            String string;
            TextComponentTranslation tooltip = new TextComponentTranslation(translationKey.toLowerCase() + ".tooltip" + i, new Object[0]);
            if (tooltip.func_150261_e().contentEquals(tooltip.func_150268_i()) || tooltip.func_150260_c().isEmpty() || (string = TranslationHelper.formatLangKeys(tooltip)) == null || TranslationHelper.isStringEmpty(string)) continue;
            tooltips.add(string);
        }
    }

    public static String formatLangKeys(TextComponentTranslation string) {
        String addOptions = TranslationHelper.formatAddVariables(string.func_150254_d());
        String addColor = TranslationHelper.addTextColorFromLangKey(addOptions);
        return addColor;
    }

    public static void addTooltips(ItemStack stack, @Nullable World world, List<String> tooltip) {
        if (world == null) {
            return;
        }
        for (int i = 1; i < 10; ++i) {
            String string;
            TextComponentTranslation info = new TextComponentTranslation(stack.func_77977_a() + ".tooltip" + i, new Object[0]);
            if (info.func_150261_e().contentEquals(info.func_150268_i()) || info.func_150260_c().isEmpty() || (string = TranslationHelper.formatLangKeys(stack, info)) == null || TranslationHelper.isStringEmpty(string)) continue;
            tooltip.add(string);
        }
        TranslationHelper.addModCompatTooltips(stack, world, tooltip);
    }

    public static void addPotionTooltips(ItemStack stack, @Nullable World world, List<String> tooltip) {
        if (world == null) {
            return;
        }
        if (stack.func_77973_b().equals(Items.field_151068_bn)) {
            PotionType pot = PotionUtils.func_185191_c((ItemStack)stack);
            for (int i = 1; i < 10; ++i) {
                String string;
                TextComponentTranslation info = new TextComponentTranslation("xat." + stack.func_77977_a() + "." + pot.getRegistryName().func_110623_a() + ".tooltip" + i, new Object[0]);
                if (info.func_150261_e().contentEquals(info.func_150268_i()) || info.func_150260_c().isEmpty() || (string = TranslationHelper.formatLangKeys(stack, info)) == null || TranslationHelper.isStringEmpty(string)) continue;
                tooltip.add(string);
            }
        }
    }

    public static void addModCompatTooltips(ItemStack stack, @Nullable World world, List<String> tooltip) {
        if (world == null) {
            return;
        }
        TextComponentTranslation ctrl = new TextComponentTranslation("xat.holdctrl", new Object[0]);
        TextComponentTranslation CompatTan = new TextComponentTranslation(stack.func_77977_a() + ".compat.tan", new Object[0]);
        TextComponentTranslation CompatFA = new TextComponentTranslation(stack.func_77977_a() + ".compat.firstaid", new Object[0]);
        TextComponentTranslation CompatEV = new TextComponentTranslation(stack.func_77977_a() + ".compat.enhancedvisuals", new Object[0]);
        boolean tanEmpty = CompatTan.func_150261_e().contentEquals(CompatTan.func_150268_i()) || CompatTan.func_150260_c().isEmpty();
        boolean evEmpty = CompatEV.func_150261_e().contentEquals(CompatEV.func_150268_i()) || CompatEV.func_150260_c().isEmpty();
        boolean faEmpty = CompatFA.func_150261_e().contentEquals(CompatFA.func_150268_i()) || CompatFA.func_150260_c().isEmpty();
        String TAN = TranslationHelper.formatLangKeys(stack, CompatTan);
        String EV = TranslationHelper.formatLangKeys(stack, CompatEV);
        String FA = TranslationHelper.formatLangKeys(stack, CompatFA);
        if (GuiScreen.func_146271_m()) {
            String string;
            if (Loader.isModLoaded((String)"toughasnails") && TrinketsConfig.compat.toughasnails && !tanEmpty && !TranslationHelper.isStringEmpty(string = TranslationHelper.formatLangKeys(stack, CompatTan))) {
                tooltip.add(string + gold + " (Tough as Nails)");
            }
            if (Loader.isModLoaded((String)"firstaid") && !faEmpty && !TranslationHelper.isStringEmpty(string = TranslationHelper.formatLangKeys(stack, CompatFA))) {
                tooltip.add(string + gold + " (First Aid)");
            }
            if (Loader.isModLoaded((String)"enhancedvisuals") && TrinketsConfig.compat.enhancedvisuals && !evEmpty && !TranslationHelper.isStringEmpty(string = TranslationHelper.formatLangKeys(stack, CompatEV))) {
                tooltip.add(string + gold + " (Enhanced Visuals)");
            }
        } else if (!tanEmpty && !TranslationHelper.isStringEmpty(TAN) || !evEmpty && !TranslationHelper.isStringEmpty(EV) || !faEmpty && !TranslationHelper.isStringEmpty(FA)) {
            tooltip.add(TextFormatting.RESET + "" + dGray + TranslationHelper.addTextColorFromLangKey(ctrl.func_150254_d()));
        }
    }

    public static void addOtherTooltips(AttributeConfigWrapper attributes, List<String> tooltip) {
        TextComponentTranslation shift = new TextComponentTranslation("xat.holdshift", new Object[0]);
        TextComponentTranslation whenworn = new TextComponentTranslation("xat.onequip", new Object[0]);
        if (GuiScreen.func_146272_n()) {
            if (attributes.armorEnabled() || attributes.armorToughnessEnabled() || attributes.attackSpeedEnabled() || attributes.attackDamageEnabled() || attributes.healthEnabled() || attributes.knockbackEnabled() || attributes.luckEnabled() || attributes.movementSpeedEnabled() || attributes.reachEnabled() || attributes.swimSpeedEnabled() || attributes.jumpEnabled() || attributes.stepHeightEnabled()) {
                tooltip.add(TextFormatting.RESET + TranslationHelper.addTextColorFromLangKey(whenworn.func_150254_d()));
                TranslationHelper.addAttributeTooltips(attributes, tooltip);
            }
        } else if (attributes.armorEnabled() || attributes.armorToughnessEnabled() || attributes.attackSpeedEnabled() || attributes.attackDamageEnabled() || attributes.healthEnabled() || attributes.knockbackEnabled() || attributes.luckEnabled() || attributes.movementSpeedEnabled() || attributes.reachEnabled() || attributes.swimSpeedEnabled() || attributes.jumpEnabled() || attributes.stepHeightEnabled()) {
            tooltip.add(TextFormatting.RESET + "" + dGray + TranslationHelper.addTextColorFromLangKey(shift.func_150254_d()));
        }
    }

    public static String TrinketOptionsKeyTranslate(ItemStack stack, String string) {
        PotionType pot;
        String key1;
        String key3;
        String key2;
        String key;
        String Key2;
        String Key;
        Object config;
        boolean isCapNull;
        TrinketProperties iCap = Capabilities.getTrinketProperties(stack);
        boolean bl = isCapNull = iCap == null;
        if (stack.func_77973_b() instanceof TrinketWitherRing) {
            config = TrinketsConfig.SERVER.Items.WITHER_RING;
            Key = "wither";
            Key2 = "leech";
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigWitherRing)config).wither, "wither", string);
            string = TranslationHelper.VariableReplace(((ConfigWitherRing)config).wither, "witherchance", MathHelper.func_76131_a((float)(1.0f / (float)((ConfigWitherRing)config).wither_chance * 100.0f), (float)-2.1474836E9f, (float)2.1474836E9f) + "%", string);
            string = TranslationHelper.VariableReplace(((ConfigWitherRing)config).enabled, "wither", TranslationHelper.booleanCheckTranslation(((ConfigWitherRing)config).wither), string);
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigWitherRing)config).leech, "leech", string);
            string = TranslationHelper.VariableReplace(((ConfigWitherRing)config).leech, "leechamount", (double)((ConfigWitherRing)config).leech_amount * 0.5 + "", string);
            string = TranslationHelper.VariableReplace(((ConfigWitherRing)config).enabled, "leech", TranslationHelper.booleanCheckTranslation(((ConfigWitherRing)config).leech), string);
        }
        if (stack.func_77973_b() instanceof TrinketDamageShield) {
            config = TrinketsConfig.SERVER.Items.DAMAGE_SHIELD;
            Key = "explosionresist";
            Key2 = "damageignored";
            String Key3 = "headshots";
            String Key4 = "soheffect";
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigDamageShield)config).explosion_resist, "explosionresist", string);
            string = TranslationHelper.VariableReplace(((ConfigDamageShield)config).enabled, "explosionresist", TranslationHelper.booleanCheckTranslation(((ConfigDamageShield)config).explosion_resist), string);
            string = TranslationHelper.VariableReplace(((ConfigDamageShield)config).explosion_resist, "explosionresistamount", 100.0f - ((ConfigDamageShield)config).explosion_amount * 100.0f + "%", string);
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigDamageShield)config).damage_ignore, "damageignored", string);
            string = TranslationHelper.VariableReplace(((ConfigDamageShield)config).enabled, "damageignored", TranslationHelper.booleanCheckTranslation(((ConfigDamageShield)config).damage_ignore), string);
            int hitcount = 0;
            if (TrinketHelper.getTagCompoundSafe(stack).func_74764_b("hitcount")) {
                hitcount = TrinketHelper.getTagCompoundSafe(stack).func_74762_e("hitcount");
            }
            string = TranslationHelper.VariableReplace(((ConfigDamageShield)config).damage_ignore, "damageignoredhitcount", hitcount + "/" + ((ConfigDamageShield)config).hits, string);
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigDamageShield)config).compat.firstaid.chance_ignore, "headshots", string);
            string = TranslationHelper.VariableReplace(((ConfigDamageShield)config).enabled, "headshots", TranslationHelper.booleanCheckTranslation(((ConfigDamageShield)config).compat.firstaid.chance_ignore), string);
            string = TranslationHelper.VariableReplace(((ConfigDamageShield)config).compat.firstaid.chance_ignore, "headshotchance", MathHelper.func_76131_a((float)(1.0f / (float)((ConfigDamageShield)config).compat.firstaid.chance_headshots * 100.0f), (float)-2.1474836E9f, (float)2.1474836E9f) + "%", string);
            Potion peffect = Potion.func_180142_b((String)((ConfigDamageShield)config).potionEffect);
            string = peffect != null ? TranslationHelper.VariableReplace(((ConfigDamageShield)config).enabled, "soheffect", I18n.func_135052_a((String)peffect.func_76393_a(), (Object[])new Object[0]), string) : TranslationHelper.VariableReplace(false, "soheffect", "", string);
        }
        if (stack.func_77973_b() instanceof TrinketRaceBase) {
            String Key3;
            Object config2;
            TrinketRaceBase rr = (TrinketRaceBase)stack.func_77973_b();
            string = TranslationHelper.VariableReplace(rr.ItemEnabled(), "rsize", rr.getRacialTraits().getRaceSize() + "%", string);
            if (rr.getRacialTraits().equals(EntityRaces.fairy)) {
                config2 = TrinketsConfig.SERVER.races.fairy;
                Key3 = "creativeflight";
                string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((FairyConfig)config2).creative_flight, "creativeflight", string);
                string = TranslationHelper.VariableReplace(true, "creativeflight", TranslationHelper.booleanCheckTranslation(((FairyConfig)config2).creative_flight), string);
            }
            if (rr.getRacialTraits().equals(EntityRaces.dwarf)) {
                config2 = TrinketsConfig.SERVER.races.dwarf;
                Key3 = "fortune";
                String Key22 = "skilledminer";
                String Key32 = "staticminer";
                string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((DwarfConfig)config2).fortune, "fortune", string);
                string = TranslationHelper.VariableReplace(true, "fortune", TranslationHelper.booleanCheckTranslation(((DwarfConfig)config2).fortune), string);
                string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((DwarfConfig)config2).skilled_miner, "skilledminer", string);
                string = TranslationHelper.VariableReplace(true, "skilledminer", TranslationHelper.booleanCheckTranslation(((DwarfConfig)config2).skilled_miner), string);
                string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((DwarfConfig)config2).static_mining, "staticminer", string);
                string = TranslationHelper.VariableReplace(true, "staticminer", TranslationHelper.booleanCheckTranslation(((DwarfConfig)config2).static_mining), string);
            }
            if (rr.getRacialTraits().equals(EntityRaces.elf)) {
                config2 = TrinketsConfig.SERVER.races.elf;
                Key3 = "chargeshot";
                string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ElfConfig)config2).charge_shot, "chargeshot", string);
            }
            if (rr.getRacialTraits().equals(EntityRaces.dragon)) {
                String breathKey = ModKeyBindings.RACE_ABILITY.getDisplayName();
                string = string.replace("*breathkb:", breathKey + "");
                String Key4 = "nightvision";
                string = TranslationHelper.VariableReplace(false, "nightvision", TranslationHelper.toggleCheckTranslation(false), string);
            }
            if (rr.getRacialTraits().equals(EntityRaces.titan)) {
                config2 = TrinketsConfig.SERVER.races.titan;
                String sinks = ModKeyBindings.RACE_ABILITY.getDisplayName();
                string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((TitanConfig)config2).sink, "heavy", string);
            }
        }
        if (stack.func_77973_b() instanceof TrinketDragonsEye) {
            boolean looking;
            config = TrinketsConfig.SERVER.Items.DRAGON_EYE;
            Key = "treasurefinder";
            String Key3 = "heatimmune";
            String Key4 = "nightvision";
            String Key5 = "looking";
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigDragonsEye)config).oreFinder, "treasurefinder", string);
            string = TranslationHelper.VariableReplace(((ConfigDragonsEye)config).enabled, "treasurefinder", TranslationHelper.booleanCheckTranslation(((ConfigDragonsEye)config).oreFinder), string);
            boolean bl2 = looking = !isCapNull && iCap.Target() >= 0;
            if (((ConfigDragonsEye)config).oreFinder) {
                int index = looking ? iCap.Target() : -1;
                string = TranslationHelper.translateDragonEyeTarget(string, index);
            }
            boolean heatImmune = ((ConfigDragonsEye)config).compat.tan.immuneToHeat && TrinketsConfig.compat.toughasnails;
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), heatImmune, "heatimmune", string);
            string = TranslationHelper.VariableReplace(((ConfigDragonsEye)config).enabled, "heatimmune", TranslationHelper.booleanCheckTranslation(heatImmune), string);
            string = TranslationHelper.VariableReplace(((ConfigDragonsEye)config).oreFinder, "looking", TranslationHelper.toggleCheckTranslation(looking), string);
            String DragonsEyeKeybindNV = ModKeyBindings.DRAGONS_EYE_ABILITY.getDisplayName();
            String DragonsEyeKeybindOF = ModKeyBindings.DRAGONS_EYE_TARGET.getDisplayName();
            string = string.replace("*denvkb:", DragonsEyeKeybindNV + "").replace("*deofkb:", DragonsEyeKeybindOF + "");
        }
        if (stack.func_77973_b() instanceof TrinketInertiaNull) {
            String inertiaNullFD = "" + (100.0f - TrinketsConfig.SERVER.Items.INERTIA_NULL.falldamage_amount * 100.0f) + "%";
            string = string.replace("$inertianullfd:", inertiaNullFD + "");
        }
        if (stack.func_77973_b() instanceof TrinketGreaterInertia) {
            String greaterInertiaFD = "" + (100.0f - TrinketsConfig.SERVER.Items.GREATER_INERTIA.falldamage_amount * 100.0f) + "%";
            string = string.replace("$greaterinertiafd:", greaterInertiaFD + "");
        }
        if (stack.func_77973_b() instanceof TrinketSeaStone) {
            config = TrinketsConfig.SERVER.Items.SEA_STONE;
            key = "bubbles";
            key2 = "betterswimming";
            key3 = "tanthirst";
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigSeaStone)config).underwater_breathing, "bubbles", string);
            string = TranslationHelper.VariableReplace(((ConfigSeaStone)config).underwater_breathing, "bubbles", TrinketsConfig.SERVER.Items.SEA_STONE.always_full ? "10" : "1", string);
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigSeaStone)config).Swim_Tweaks, "betterswimming", string);
            string = TranslationHelper.VariableReplace(((ConfigSeaStone)config).Swim_Tweaks, "betterswimming", TranslationHelper.booleanCheckTranslation(((ConfigSeaStone)config).Swim_Tweaks), string);
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigSeaStone)config).compat.tan.prevent_thirst, "tanthirst", string);
            string = TranslationHelper.VariableReplace(TrinketsConfig.compat.toughasnails, "tanthirst", TranslationHelper.booleanCheckTranslation(((ConfigSeaStone)config).compat.tan.prevent_thirst), string);
        }
        if (stack.func_77973_b() instanceof TrinketPolarized) {
            config = TrinketsConfig.SERVER.Items.POLARIZED_STONE;
            key = "collect";
            key2 = "collectxp";
            key3 = "repel";
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigPolarizedStone)config).enabled, "collect", string);
            boolean collectMode = stack.func_77952_i() == 1 || stack.func_77952_i() == 3;
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigPolarizedStone)config).collectXP, "collectxp", string);
            string = TranslationHelper.VariableReplace(((ConfigPolarizedStone)config).collectXP, "collectxp", TranslationHelper.booleanCheckTranslation(((ConfigPolarizedStone)config).collectXP), string);
            string = TranslationHelper.VariableReplace(((ConfigPolarizedStone)config).repell, "collecttoggle", TranslationHelper.toggleCheckTranslation(collectMode), string);
            boolean repelMode = stack.func_77952_i() == 2 || stack.func_77952_i() == 3;
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigPolarizedStone)config).repell, "repel", string);
            string = TranslationHelper.VariableReplace(((ConfigPolarizedStone)config).repell, "collectxp", TranslationHelper.booleanCheckTranslation(((ConfigPolarizedStone)config).repell), string);
            string = TranslationHelper.VariableReplace(((ConfigPolarizedStone)config).repell, "repeltoggle", TranslationHelper.toggleCheckTranslation(repelMode), string);
            String PolarizedStoneKeybind = ModKeyBindings.POLARIZED_STONE_ABILITY.getDisplayName();
            string = string.replace("*magnetkb:", PolarizedStoneKeybind + "");
        }
        if (stack.func_77973_b() instanceof TrinketPoisonStone) {
            config = TrinketsConfig.SERVER.Items.POISON_STONE;
            boolean PoisonChance = ((ConfigPoisonStone)config).poison;
            String key4 = "poison";
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), PoisonChance, "poison", string);
            string = TranslationHelper.VariableReplace(((ConfigPoisonStone)config).enabled, "poison", TranslationHelper.toggleCheckTranslation(PoisonChance), string);
            string = TranslationHelper.VariableReplace(PoisonChance, "poisonchance", MathHelper.func_76131_a((float)(1.0f / (float)((ConfigPoisonStone)config).poison_chance * 100.0f), (float)-2.1474836E9f, (float)2.1474836E9f) + "%", string);
            boolean bonusDamage = ((ConfigPoisonStone)config).bonus_damage;
            String key22 = "bonusdamage";
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), bonusDamage, "bonusdamage", string);
            string = TranslationHelper.VariableReplace(((ConfigPoisonStone)config).enabled, "bonusdamage", TranslationHelper.toggleCheckTranslation(bonusDamage), string);
            float pa = ((ConfigPoisonStone)config).bonus_damage_amount <= 0.0f ? ((ConfigPoisonStone)config).bonus_damage_amount : ((ConfigPoisonStone)config).bonus_damage_amount - 1.0f;
            string = TranslationHelper.VariableReplace(PoisonChance, "damagemultiplier", TranslationHelper.translateAttributeValue(1, pa), string);
        }
        if (stack.func_77973_b() instanceof TrinketEnderTiara) {
            config = TrinketsConfig.SERVER.Items.ENDER_CROWN;
            String key5 = "damageignored";
            key1 = "endermenchance";
            String key23 = "endermenfollow";
            String key32 = "waterhurts";
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigEnderCrown)config).dmgChance, "damageignored", string);
            string = TranslationHelper.VariableReplace(((ConfigEnderCrown)config).enabled, "damageignored", TranslationHelper.toggleCheckTranslation(((ConfigEnderCrown)config).dmgChance), string);
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigEnderCrown)config).spawnChance, "endermenchance", string);
            string = TranslationHelper.VariableReplace(((ConfigEnderCrown)config).enabled, "endermenchance", TranslationHelper.toggleCheckTranslation(((ConfigEnderCrown)config).spawnChance), string);
            string = TranslationHelper.VariableReplace(((ConfigEnderCrown)config).dmgChance || ((ConfigEnderCrown)config).spawnChance, "chance", MathHelper.func_76131_a((float)(1.0f / (float)((ConfigEnderCrown)config).chance * 100.0f), (float)-2.1474836E9f, (float)2.1474836E9f) + "%", string);
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigEnderCrown)config).Follow, "endermenfollow", string);
            string = TranslationHelper.VariableReplace(((ConfigEnderCrown)config).enabled, "endermenfollow", TranslationHelper.toggleCheckTranslation(((ConfigEnderCrown)config).Follow), string);
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigEnderCrown)config).water_hurts, "waterhurts", string);
            string = TranslationHelper.VariableReplace(((ConfigEnderCrown)config).enabled, "waterhurts", TranslationHelper.booleanCheckTranslation(((ConfigEnderCrown)config).water_hurts), string);
        }
        if (stack.func_77973_b() instanceof TrinketArcingOrb) {
            config = TrinketsConfig.SERVER.Items.ARCING_ORB;
            String key6 = "dodge";
            key1 = "dodgecost";
            String key24 = "dodgestun";
            String key33 = "boltattack";
            String key4 = "boltcost";
            String key5 = "boltdamage";
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigArcingOrb)config).dodgeAbility, "dodge", string);
            string = TranslationHelper.VariableReplace(((ConfigArcingOrb)config).enabled, "dodge", TranslationHelper.toggleCheckTranslation(((ConfigArcingOrb)config).dodgeAbility), string);
            string = TranslationHelper.VariableReplace(((ConfigArcingOrb)config).enabled, "dodgecost", ((ConfigArcingOrb)config).dodgeCost + "", string);
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigArcingOrb)config).dodgeStuns, "dodgestun", string);
            string = TranslationHelper.VariableReplace(((ConfigArcingOrb)config).enabled, "dodgestun", TranslationHelper.booleanCheckTranslation(((ConfigArcingOrb)config).dodgeStuns), string);
            string = TranslationHelper.TranslationKeyReplace(stack.func_77977_a(), ((ConfigArcingOrb)config).attackAbility, "boltattack", string);
            string = TranslationHelper.VariableReplace(((ConfigArcingOrb)config).enabled, "boltattack", TranslationHelper.toggleCheckTranslation(((ConfigArcingOrb)config).attackAbility), string);
            string = TranslationHelper.VariableReplace(((ConfigArcingOrb)config).enabled, "boltcost", ((ConfigArcingOrb)config).attackCost + "", string);
            string = TranslationHelper.VariableReplace(((ConfigArcingOrb)config).enabled, "boltdamage", ((ConfigArcingOrb)config).attackDmg + "", string);
            String ArcingOrbKeybindBoltAttack = ModKeyBindings.ARCING_ORB_ABILITY.getDisplayName();
            string = string.replace("*arckb:", ArcingOrbKeybindBoltAttack + "");
        }
        if (stack.func_77973_b() instanceof TrinketFaelisClaws) {
            config = TrinketsConfig.SERVER.Items.FAELIS_CLAW;
            string = TranslationHelper.VariableReplace(true, "clawbleed", ((ConfigFaelisClaw)config).duration + "", string);
        }
        if (stack.func_77973_b() instanceof Mana_Crystal) {
            string = TranslationHelper.VariableReplace(true, "MPMax", "10", string);
        }
        if (stack.func_77973_b() instanceof Mana_Reagent) {
            string = TranslationHelper.VariableReplace(true, "MPMax", "10", string);
        }
        if (stack.func_77973_b().equals(Items.field_151068_bn) && ModPotionTypes.TrinketPotionTypes.containsValue(pot = PotionUtils.func_185191_c((ItemStack)stack))) {
            string = string.replace("$humanticks:", (float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.human.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f + "").replace("$fairyticks:", (float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.fairy.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f + "").replace("$dwarfticks:", (float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.dwarf.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f + "").replace("$titanticks:", (float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.titan.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f + "").replace("$goblinticks:", (float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.goblin.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f + "").replace("$elfticks:", (float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.elf.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f + "").replace("$faelisticks:", (float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.faelis.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f + "");
        }
        String AuxKeybind = ModKeyBindings.AUX_KEY.getDisplayName();
        return string.replace("*auxkb:", AuxKeybind + "");
    }

    public static String TranslationKeyReplace(String itemKey, boolean enabled, String key, String translation) {
        if (enabled) {
            String translatedKey = new TextComponentTranslation(itemKey + "." + key, new Object[0]).func_150254_d();
            return translation.replace("@" + key.toLowerCase() + ":", translatedKey);
        }
        return translation.replace("@" + key.toLowerCase() + ":", "");
    }

    public static String VariableReplace(boolean enabled, String key, String Variable, String translation) {
        if (enabled) {
            return translation.replace("$" + key.toLowerCase() + ":", Variable);
        }
        return translation.replace("$" + key.toLowerCase() + ":", "");
    }

    public static String booleanCheckTranslation(boolean bool) {
        TextComponentTranslation enabled = new TextComponentTranslation("xat.tooltip.enabled", new Object[0]);
        TextComponentTranslation disabled = new TextComponentTranslation("xat.tooltip.disabled", new Object[0]);
        if (bool) {
            return enabled.func_150254_d();
        }
        return disabled.func_150254_d();
    }

    public static String toggleCheckTranslation(boolean bool) {
        TextComponentTranslation on = new TextComponentTranslation("xat.tooltip.on", new Object[0]);
        TextComponentTranslation off = new TextComponentTranslation("xat.tooltip.off", new Object[0]);
        if (bool) {
            return on.func_150254_d();
        }
        return off.func_150254_d();
    }

    public static String addTextColorFromLangKey(String string) {
        return string.replace("#black:", "" + black).replace("#white:", "" + white).replace("#red:", "" + red).replace("#darkred:", "" + dRed).replace("#blue:", "" + blue).replace("#darkblue:", "" + dBlue).replace("#green:", "" + green).replace("#darkgreen:", "" + dGreen).replace("#lightpurple:", "" + lPurple).replace("#darkpurple:", "" + dPurple).replace("#yellow:", "" + yellow).replace("#aqua:", "" + aqua).replace("#darkaqua:", "" + dAqua).replace("#gray:", "" + gray).replace("#darkgray:", "" + dGray).replace("#gold:", "" + gold).replace("#strikethrough:", "" + ST).replace("#underline:", "" + UL).replace("#italic:", "" + italic).replace("#bold:", "" + bold).replace("#reset:", "" + reset);
    }

    public static String formatLangKeys(ItemStack stack, TextComponentTranslation string) {
        String addOptions = TranslationHelper.TrinketOptionsKeyTranslate(stack, string.func_150254_d());
        String addColor = TranslationHelper.addTextColorFromLangKey(addOptions);
        return addColor;
    }

    public static String translateDragonEyeTarget(String string, int targetID) {
        ConfigDragonsEye config = TrinketsConfig.SERVER.Items.DRAGON_EYE;
        String Key1 = "$target:";
        String Key5 = "looking";
        if (config.oreFinder) {
            String target = CallHelper.getStringFromArray(TrinketsConfig.SERVER.Items.DRAGON_EYE.BLOCKS.Blocks, targetID).replace("[", ";").replace("]", "");
            String[] itemConfig = target.split(";");
            String itemString = CallHelper.getStringFromArray(itemConfig, 0);
            String metaString = itemString.contains(":") ? CallHelper.getStringFromArray(itemConfig, 1) : "";
            String translatedTarget = OreTrackingHelper.translateOreName(itemString, metaString);
            NonNullList targetStack = OreDictionary.getOres((String)itemString, (boolean)false);
            if (!targetStack.isEmpty()) {
                translatedTarget = ((ItemStack)targetStack.get(0)).func_82833_r();
            }
            String getName = itemString.contains(":") ? OreTrackingHelper.translateOreName(itemString, metaString) : translatedTarget.replace("ore", "").replace("Ore", "");
            String dragonsEyeTarget = targetID >= 0 ? getName.replace("Oak Chest", "Chest").replace("Chest", "Treasure Chests").trim() : "None";
            string = TranslationHelper.VariableReplace(config.oreFinder, "looking", TranslationHelper.toggleCheckTranslation(targetID >= 0), string);
            string = TranslationHelper.addTextColorFromLangKey(string);
            return string.replace("$target:", dragonsEyeTarget + "");
        }
        return string.replace("$target:", "");
    }

    public static String translateAttributeValue(int OP, double Amount) {
        double TranslatedAmount = Amount;
        String string = "";
        string = OP > 0 ? ((TranslatedAmount = (double)Math.round(Amount * 100.0)) > 0.0 ? "+" + TranslatedAmount + "%" : "" + TranslatedAmount + "%") : (TranslatedAmount > 0.0 ? "+" + TranslatedAmount : "" + TranslatedAmount);
        String color = TranslatedAmount > 0.0 ? "" + green : "" + red;
        return color + string;
    }

    public static void addAttributeTooltips(AttributeConfigWrapper attributes, List<String> tooltip) {
        String string;
        double Amount;
        int OP;
        if (attributes.attackSpeedEnabled()) {
            OP = attributes.getAttackSpeedOperation();
            Amount = attributes.getAttackSpeed();
            string = TranslationHelper.translateAttributeValue(OP, Amount);
            String attackspeed = I18n.func_135052_a((String)"xat.tooltip.attackspeed", (Object[])new Object[0]);
            tooltip.add(string + " " + blue + attackspeed);
        }
        if (attributes.attackDamageEnabled()) {
            OP = attributes.getAttackDamageOperation();
            Amount = attributes.getAttackDamage();
            string = TranslationHelper.translateAttributeValue(OP, Amount);
            String attackdamage = I18n.func_135052_a((String)"xat.tooltip.attackdamage", (Object[])new Object[0]);
            tooltip.add(string + " " + blue + attackdamage);
        }
        if (attributes.healthEnabled()) {
            OP = attributes.getHealthOperation();
            Amount = attributes.getHealth();
            string = TranslationHelper.translateAttributeValue(OP, Amount);
            String health = I18n.func_135052_a((String)"xat.tooltip.health", (Object[])new Object[0]);
            tooltip.add(string + " " + blue + health);
        }
        if (attributes.armorEnabled()) {
            OP = attributes.getArmorOperation();
            Amount = attributes.getArmor();
            string = TranslationHelper.translateAttributeValue(OP, Amount);
            String armor = I18n.func_135052_a((String)"xat.tooltip.armor", (Object[])new Object[0]);
            tooltip.add(string + " " + blue + armor);
        }
        if (attributes.armorToughnessEnabled()) {
            OP = attributes.getArmorToughnessOperation();
            Amount = attributes.getArmorToughness();
            string = TranslationHelper.translateAttributeValue(OP, Amount);
            String toughness = I18n.func_135052_a((String)"xat.tooltip.toughness", (Object[])new Object[0]);
            tooltip.add(string + " " + blue + toughness);
        }
        if (attributes.knockbackEnabled()) {
            OP = attributes.getKnockbackOperation();
            Amount = attributes.getKnockback();
            string = TranslationHelper.translateAttributeValue(OP, Amount);
            String knockbackresist = I18n.func_135052_a((String)"xat.tooltip.knockbackresist", (Object[])new Object[0]);
            tooltip.add(string + " " + blue + knockbackresist);
        }
        if (attributes.movementSpeedEnabled()) {
            OP = attributes.getMovementSpeedOperation();
            Amount = attributes.getMovementSpeed();
            string = TranslationHelper.translateAttributeValue(OP, Amount);
            String movementspeed = I18n.func_135052_a((String)"xat.tooltip.movementspeed", (Object[])new Object[0]);
            tooltip.add(string + " " + blue + movementspeed);
        }
        if (attributes.luckEnabled()) {
            OP = attributes.getLuckOperation();
            Amount = attributes.getLuck();
            string = TranslationHelper.translateAttributeValue(OP, Amount);
            String luck = I18n.func_135052_a((String)"xat.tooltip.luck", (Object[])new Object[0]);
            tooltip.add(string + " " + blue + luck);
        }
        if (attributes.swimSpeedEnabled()) {
            OP = attributes.getSwimSpeedOperation();
            Amount = attributes.getSwimSpeed();
            string = TranslationHelper.translateAttributeValue(OP, Amount);
            String swimspeed = I18n.func_135052_a((String)"xat.tooltip.swimspeed", (Object[])new Object[0]);
            tooltip.add(string + " " + blue + swimspeed);
        }
        if (attributes.reachEnabled()) {
            OP = attributes.getReachOperation();
            Amount = attributes.getReach();
            string = TranslationHelper.translateAttributeValue(OP, Amount);
            String reach = I18n.func_135052_a((String)"xat.tooltip.reach", (Object[])new Object[0]);
            tooltip.add(string + " " + blue + reach);
        }
        if (attributes.jumpEnabled()) {
            OP = attributes.getJumpOperation();
            Amount = attributes.getJump();
            string = TranslationHelper.translateAttributeValue(OP, Amount);
            String jumpheight = I18n.func_135052_a((String)"xat.tooltip.jumpheight", (Object[])new Object[0]);
            tooltip.add(string + " " + blue + jumpheight);
        }
        if (attributes.stepHeightEnabled()) {
            OP = attributes.getStepHeightOperation();
            Amount = attributes.getStepHeight();
            string = TranslationHelper.translateAttributeValue(OP, Amount);
            String stepheight = I18n.func_135052_a((String)"xat.tooltip.stepheight", (Object[])new Object[0]);
            tooltip.add(string + " " + blue + stepheight);
        }
    }

    public static double parseDoubleSafely(String d) {
        String number = d.replaceAll("[^.\\d]", "");
        if (!number.isEmpty()) {
            try {
                return Double.parseDouble(number);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0.0;
    }

    private static class KeyEntry {
        private String key;
        private String option = "";
        private boolean enabled = false;

        public <T> KeyEntry(String key, T option) {
            this.key = key;
            this.option = option + "";
        }

        public <T> KeyEntry(String key, boolean enabled, T option) {
            this(key, option);
            this.enabled = enabled;
        }

        public String key() {
            return this.key;
        }

        public String option() {
            return this.option;
        }

        public boolean enabled() {
            return this.enabled;
        }
    }
}

