/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.registry;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xzeroair.trinkets.init.ModBlocks;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.init.ModPotionTypes;
import xzeroair.trinkets.tileentities.TileEntityMoonRose;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;
import xzeroair.trinkets.util.interfaces.IsModelLoaded;

@Mod.EventBusSubscriber(modid="xat")
public class ModItemRegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.crafting.ITEMS.toArray(new Item[0]));
        if (TrinketsConfig.SERVER.Food.foods_enabled) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.foods.ITEMS.toArray(new Item[0]));
        }
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.misc.ITEMS.toArray(new Item[0]));
        if (Loader.isModLoaded((String)"baubles") && !TrinketsConfig.compat.xatItemsInTrinketGuiOnly) {
            for (Item item : ModItems.baubles.ITEMS) {
                if (!(item instanceof IAccessoryInterface) || !((IAccessoryInterface)item).ItemEnabled()) continue;
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
        } else {
            for (Item item : ModItems.trinkets.ITEMS) {
                if (!(item instanceof IAccessoryInterface) || !((IAccessoryInterface)item).ItemEnabled()) continue;
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
            for (Item item : ModItems.RaceTrinkets.ITEMS) {
                if (!(item instanceof IAccessoryInterface) || !((IAccessoryInterface)item).ItemEnabled()) continue;
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.Flowers.BLOCKS.toArray(new Block[0]));
        GameRegistry.registerTileEntity(TileEntityMoonRose.class, (ResourceLocation)new ResourceLocation("xat:moon_rose"));
    }

    @SubscribeEvent
    public static void onPotionRegister(RegistryEvent.Register<PotionType> event) {
        if (TrinketsConfig.SERVER.Potion.potions_enabled) {
            ModPotionTypes.registerPotionTypes();
        }
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ModItems.misc.ITEMS) {
            if (!(item instanceof IsModelLoaded)) continue;
            ((IsModelLoaded)item).registerModels();
        }
        for (Item item : ModItems.crafting.ITEMS) {
            if (!(item instanceof IsModelLoaded)) continue;
            ((IsModelLoaded)item).registerModels();
        }
        for (Block block : ModBlocks.Flowers.BLOCKS) {
            if (!(block instanceof IsModelLoaded)) continue;
            ((IsModelLoaded)block).registerModels();
        }
        if (TrinketsConfig.SERVER.Food.foods_enabled) {
            for (Item item : ModItems.foods.ITEMS) {
                if (!(item instanceof IsModelLoaded)) continue;
                ((IsModelLoaded)item).registerModels();
            }
        }
        if (Loader.isModLoaded((String)"baubles") && !TrinketsConfig.compat.xatItemsInTrinketGuiOnly) {
            for (Item item : ModItems.baubles.ITEMS) {
                if (!(item instanceof IsModelLoaded)) continue;
                ((IsModelLoaded)item).registerModels();
            }
        } else {
            for (Item item : ModItems.trinkets.ITEMS) {
                if (!(item instanceof IsModelLoaded)) continue;
                ((IsModelLoaded)item).registerModels();
            }
            for (Item item : ModItems.RaceTrinkets.ITEMS) {
                if (!(item instanceof IsModelLoaded)) continue;
                ((IsModelLoaded)item).registerModels();
            }
        }
    }
}

