/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.effects;

import c4.corpsecomplex.CorpseComplex;
import c4.corpsecomplex.common.Module;
import c4.corpsecomplex.common.modules.effects.MoriModule;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.logging.log4j.Level;

public class EffectsModule
extends Module {
    private static ArrayList<String[]> effects;
    private static ArrayList<String[]> customCureEffects;
    private static String[] cfgCureList;
    private static boolean cfgEnabled;

    @SubscribeEvent
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish evt) {
        EntityLivingBase entityLivingBase = evt.getEntityLiving();
        if (!entityLivingBase.field_70170_p.field_72995_K && cfgCureList.length > 0) {
            entityLivingBase.curePotionEffects(evt.getItem());
        }
    }

    @SubscribeEvent
    public void onPlayerRespawnFinish(PlayerEvent.PlayerRespawnEvent e) {
        if (!e.player.field_70170_p.field_72995_K && !e.isEndConquered()) {
            EntityPlayer player = e.player;
            EffectsModule.addPotionEffects(player, effects, false);
            EffectsModule.addPotionEffects(player, customCureEffects, true);
        }
    }

    public EffectsModule() {
        super("Effects", "Add potions effects that will be applied to players on respawn");
        this.submoduleClasses = new ArrayList();
        this.addSubmodule(MoriModule.class);
    }

    @Override
    public void loadModuleConfig() {
        this.setCategoryComment();
        cfgEnabled = this.getBool("Enable Effects Module", false, "Set to true to enable effects module", true);
        cfgCureList = this.getStringList("Curative Items", new String[]{"minecraft:milk_bucket"}, "List of items that will be used by 'Curable Respawn Effects'", false);
        String[] cfgEffects = this.getStringList("Uncurable Respawn Effects", new String[]{"minecraft:mining_fatigue 30 4"}, "List of effects to apply to player on respawn\nFormat: [effect] [duration(secs)] [power]", false);
        String[] cfgCustomCureEffects = this.getStringList("Curable Respawn Effects", new String[0], "List of effects to apply to players on respawn that can be cured by the curing items list\nFormat: [effect] [duration(secs)] [power]", false);
        effects = new ArrayList<String[]>(EffectsModule.initEffectsList(cfgEffects));
        customCureEffects = new ArrayList<String[]>(EffectsModule.initEffectsList(cfgCustomCureEffects));
    }

    @Override
    public void initPropOrder() {
        this.propOrder = new ArrayList<String>(Collections.singletonList("Enable Effects Module"));
    }

    @Override
    public void setEnabled() {
        this.enabled = cfgEnabled;
    }

    private static void addPotionEffects(EntityPlayer player, ArrayList<String[]> effectsToApply, boolean useCureList) {
        if (effectsToApply.isEmpty()) {
            return;
        }
        for (String[] s : effectsToApply) {
            Potion potion = Potion.func_180142_b((String)s[0]);
            if (potion == null) continue;
            int duration = Integer.parseInt(s[1]) * 20;
            int amp = Integer.parseInt(s[2]) - 1;
            PotionEffect potionEffect = new PotionEffect(potion, duration, amp);
            if (useCureList) {
                ArrayList<ItemStack> cureList = new ArrayList<ItemStack>();
                for (String s1 : cfgCureList) {
                    Item item = Item.func_111206_d((String)s1);
                    if (item == null) continue;
                    cureList.add(new ItemStack(item));
                }
                potionEffect.setCurativeItems(cureList);
            } else {
                potionEffect.setCurativeItems(new ArrayList(0));
            }
            player.func_70690_d(potionEffect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String[]> initEffectsList(String[] effectsList) {
        ArrayList<String[]> effectsToApply = new ArrayList<String[]>();
        for (String s : effectsList) {
            String[] elements = s.split("\\s+");
            String[] effectAttributes = new String[3];
            int i = 0;
            int j = 0;
            try {
                i = Integer.parseInt(elements[1]);
                j = Integer.parseInt(elements[2]);
            }
            catch (Exception e1) {
                CorpseComplex.logger.log(Level.ERROR, "Problem parsing respawn effects list!", (Throwable)e1);
            }
            finally {
                elements[1] = Integer.toString(Math.max(1, Math.min(i, 1600)));
                elements[2] = Integer.toString(Math.max(1, Math.min(j, 10)));
                effectAttributes[0] = elements[0];
                effectAttributes[1] = elements[1];
                effectAttributes[2] = elements[2];
            }
            effectsToApply.add(effectAttributes);
        }
        return effectsToApply;
    }
}

