/*
 * Decompiled with CFR 0.152.
 */
package mcjty.fxcontrol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mcjty.fxcontrol.FxControl;
import mcjty.fxcontrol.rules.EffectRule;
import mcjty.fxcontrol.rules.HarvestRule;
import mcjty.fxcontrol.rules.LeftClickRule;
import mcjty.fxcontrol.rules.PlaceRule;
import mcjty.fxcontrol.rules.RightClickRule;
import org.apache.logging.log4j.Level;

public class RulesManager {
    private static String path;
    public static List<EffectRule> effectRules;
    public static List<HarvestRule> harvestRules;
    public static List<PlaceRule> placeRules;
    public static List<RightClickRule> rightclickRules;
    public static List<LeftClickRule> leftclickRules;

    public static void reloadRules() {
        effectRules.clear();
        harvestRules.clear();
        placeRules.clear();
        rightclickRules.clear();
        leftclickRules.clear();
        RulesManager.readAllRules();
    }

    public static void setRulePath(File directory) {
        path = directory.getPath();
    }

    public static void readRules() {
        RulesManager.readAllRules();
    }

    private static boolean exists(String file) {
        File f = new File(file);
        return f.exists() && !f.isDirectory();
    }

    private static void readAllRules() {
        RulesManager.readRules(path, "effects.json", EffectRule::parse, effectRules);
        RulesManager.readRules(path, "breakevents.json", HarvestRule::parse, harvestRules);
        RulesManager.readRules(path, "placeevents.json", PlaceRule::parse, placeRules);
        RulesManager.readRules(path, "rightclicks.json", RightClickRule::parse, rightclickRules);
        RulesManager.readRules(path, "leftclicks.json", LeftClickRule::parse, leftclickRules);
    }

    private static <T> void readRules(String path, String filename, Function<JsonElement, T> parser, List<T> rules) {
        JsonElement element = RulesManager.getRootElement(path, filename);
        if (element == null) {
            return;
        }
        int i = 0;
        for (JsonElement entry : element.getAsJsonArray()) {
            T rule = parser.apply(entry);
            if (rule != null) {
                rules.add(rule);
            } else {
                FxControl.setup.getLogger().log(Level.ERROR, "Rule " + i + " in " + filename + " is invalid, skipping!");
            }
            ++i;
        }
        FxControl.setup.getLogger().log(Level.INFO, "Loaded " + i + " rules!");
    }

    private static JsonElement getRootElement(String path, String filename) {
        BufferedReader br;
        File file = path == null ? new File(filename) : new File(path + File.separator + "fxcontrol", filename);
        if (!file.exists()) {
            RulesManager.makeEmptyRuleFile(file);
            return null;
        }
        FxControl.setup.getLogger().log(Level.INFO, "Reading rules from " + filename);
        FileInputStream inputstream = null;
        try {
            inputstream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            FxControl.setup.getLogger().log(Level.ERROR, "Error reading " + filename + "!");
            return null;
        }
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)inputstream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            FxControl.setup.getLogger().log(Level.ERROR, "Error reading " + filename + "!");
            return null;
        }
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse((Reader)br);
        return element;
    }

    private static void makeEmptyRuleFile(File file) {
        PrintWriter writer;
        try {
            writer = new PrintWriter(file);
        }
        catch (FileNotFoundException e) {
            FxControl.setup.getLogger().log(Level.ERROR, "Error writing " + file.getName() + "!");
            return;
        }
        JsonArray array = new JsonArray();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        writer.print(gson.toJson((JsonElement)array));
        writer.close();
    }

    static {
        effectRules = new ArrayList<EffectRule>();
        harvestRules = new ArrayList<HarvestRule>();
        placeRules = new ArrayList<PlaceRule>();
        rightclickRules = new ArrayList<RightClickRule>();
        leftclickRules = new ArrayList<LeftClickRule>();
    }
}

