/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.trumpetskeleton;

import com.jamieswhiteshirt.trumpetskeleton.common.CommonProxy;
import com.jamieswhiteshirt.trumpetskeleton.common.TrumpetSkeletonItems;
import com.jamieswhiteshirt.trumpetskeleton.common.TrumpetSkeletonSoundEvents;
import com.jamieswhiteshirt.trumpetskeleton.common.entity.EntityTrumpetSkeleton;
import com.jamieswhiteshirt.trumpetskeleton.common.item.ItemTrumpet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="trumpetskeleton", version="1.12-1.0.2.1", acceptedMinecraftVersions="[1.12,1.13)", dependencies="required-after:forge@[14.21.1.2387,)", name="Trumpet Skeleton")
public class TrumpetSkeleton {
    public static final String MODID = "trumpetskeleton";
    public static final String VERSION = "1.12-1.0.2.1";
    public static final ResourceLocation ENTITIES_TRUMPET_SKELETON_LOOT_TABLE = new ResourceLocation("trumpetskeleton", "entities/trumpet_skeleton");
    @Mod.Instance
    public static TrumpetSkeleton instance;
    @SidedProxy(clientSide="com.jamieswhiteshirt.trumpetskeleton.client.ClientProxy", serverSide="com.jamieswhiteshirt.trumpetskeleton.server.ServerProxy", modId="trumpetskeleton")
    public static CommonProxy proxy;
    public static final Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        LootTableList.func_186375_a((ResourceLocation)ENTITIES_TRUMPET_SKELETON_LOOT_TABLE);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        EntityParrot.registerMimicSound(EntityTrumpetSkeleton.class, (SoundEvent)TrumpetSkeletonSoundEvents.E_PARROT_IM_TRUMPET_SKELETON);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{((Item)new ItemTrumpet().func_77655_b("trumpetskeleton.trumpet").setRegistryName(MODID, "trumpet")).func_77637_a(CreativeTabs.field_78026_f)});
    }

    @SubscribeEvent
    public void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{(SoundEvent)new SoundEvent(new ResourceLocation(MODID, "entity.trumpet_skeleton.ambient")).setRegistryName(new ResourceLocation(MODID, "entity.trumpet_skeleton.ambient")), (SoundEvent)new SoundEvent(new ResourceLocation(MODID, "item.trumpet.use")).setRegistryName(new ResourceLocation(MODID, "item.trumpet.use")), (SoundEvent)new SoundEvent(new ResourceLocation(MODID, "entity.parrot.imitate.trumpet_skeleton")).setRegistryName(new ResourceLocation(MODID, "entity.parrot.imitate.trumpet_skeleton"))});
    }

    @SubscribeEvent
    public void registerEntityEntries(RegistryEvent.Register<EntityEntry> event) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "trumpet_skeleton"), EntityTrumpetSkeleton.class, (String)"trumpetskeleton.TrumpetSkeleton", (int)0, (Object)this, (int)80, (int)3, (boolean)false, (int)0xC1C1C1, (int)0xFCFC00);
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            for (Biome.SpawnListEntry entry : new ArrayList(biome.func_76747_a(EnumCreatureType.MONSTER))) {
                if (entry.field_76300_b != EntitySkeleton.class) continue;
                EntityRegistry.addSpawn(EntityTrumpetSkeleton.class, (int)(entry.field_76292_a / 4), (int)entry.field_76301_c, (int)entry.field_76299_d, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{biome});
            }
        }
    }

    public static void scare(World world, EntityLivingBase user) {
        if (!world.field_72995_K) {
            List spookedEntities = world.func_72872_a(EntityLivingBase.class, user.func_174813_aQ().func_186662_g(10.0));
            for (EntityLivingBase spookedEntity : spookedEntities) {
                if (spookedEntity == user) continue;
                double deltaX = spookedEntity.field_70165_t - user.field_70165_t + world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble();
                double deltaZ = spookedEntity.field_70161_v - user.field_70161_v + world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble();
                double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                spookedEntity.field_70133_I = true;
                spookedEntity.func_70024_g(0.5 * deltaX / distance, 5.0 / (10.0 + distance), 0.5 * deltaZ / distance);
                spookedEntity.func_70604_c(user);
            }
        }
    }

    @SubscribeEvent
    public void onActiveItemUseTick(LivingEntityUseItemEvent.Tick event) {
        ItemStack stack = event.getItem();
        if (stack.func_77973_b() == TrumpetSkeletonItems.TRUMPET) {
            if (event.getDuration() == stack.func_77988_m() - 10) {
                EntityLivingBase user = event.getEntityLiving();
                World world = user.field_70170_p;
                user.func_184185_a(TrumpetSkeletonSoundEvents.ITEM_TRUMPET_USE, 1.0f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                TrumpetSkeleton.scare(world, user);
                stack.func_77972_a(1, user);
            } else if (event.getDuration() <= stack.func_77988_m() - 15) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        EntityPlayer player;
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && (player = (EntityPlayer)entity).func_184607_cu().func_77973_b() == TrumpetSkeletonItems.TRUMPET && event.getSound() == SoundEvents.field_187537_bA) {
            event.setCanceled(true);
        }
    }

    static {
        logger = LogManager.getLogger((String)MODID);
    }
}

