/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.proxy;

import ejektaflex.bountiful.Bountiful;
import ejektaflex.bountiful.api.block.ITileEntityBountyBoard;
import ejektaflex.bountiful.api.events.PopulateBountyBoardEvent;
import ejektaflex.bountiful.api.ext.ExtMiscKt;
import ejektaflex.bountiful.api.logic.IPickCommon;
import ejektaflex.bountiful.api.logic.pickable.PickableEntry;
import ejektaflex.bountiful.api.logic.picked.PickedEntry;
import ejektaflex.bountiful.api.logic.picked.PickedEntryStack;
import ejektaflex.bountiful.api.stats.BountifulStats;
import ejektaflex.bountiful.cap.CapManager;
import ejektaflex.bountiful.cap.GlobBoardProvider;
import ejektaflex.bountiful.cap.IGlobalBoard;
import ejektaflex.bountiful.cap.Storage;
import ejektaflex.bountiful.config.BountifulIO;
import ejektaflex.bountiful.data.BountyData;
import ejektaflex.bountiful.data.DefaultData;
import ejektaflex.bountiful.item.ItemBounty;
import ejektaflex.bountiful.logic.BountyChecker;
import ejektaflex.bountiful.logic.BountyHolder;
import ejektaflex.bountiful.proxy.CommonProxy;
import ejektaflex.bountiful.proxy.IProxy;
import ejektaflex.bountiful.registry.BountyRegistry;
import ejektaflex.bountiful.registry.RewardRegistry;
import ejektaflex.bountiful.worldgen.VillageBoardComponent;
import ejektaflex.bountiful.worldgen.VillageBoardCreationHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lejektaflex/bountiful/proxy/CommonProxy;", "Lejektaflex/bountiful/proxy/IProxy;", "()V", "attachCaps", "", "e", "Lnet/minecraftforge/event/AttachCapabilitiesEvent;", "Lnet/minecraft/world/World;", "entityLivingDeath", "Lnet/minecraftforge/event/entity/living/LivingDeathEvent;", "onBoardPost", "Lejektaflex/bountiful/api/events/PopulateBountyBoardEvent;", "onWorldTick", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$WorldTickEvent;", "postInit", "Lnet/minecraftforge/fml/common/event/FMLPostInitializationEvent;", "preInit", "Lnet/minecraftforge/fml/common/event/FMLPreInitializationEvent;", "Bountiful"})
public class CommonProxy
implements IProxy {
    @Override
    public void preInit(@NotNull FMLPreInitializationEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        CapabilityManager.INSTANCE.register(IGlobalBoard.class, (Capability.IStorage)new Storage(), (Callable)preInit.1.INSTANCE);
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageBoardCreationHandler());
        MapGenStructureIO.func_143031_a(VillageBoardComponent.class, (String)VillageBoardComponent.Companion.getVILLAGE_BOARD_ID().toString());
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void entityLivingDeath(@NotNull LivingDeathEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        DamageSource damageSource = e.getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)damageSource, (String)"e.source");
        if (damageSource.func_76346_g() instanceof EntityPlayer) {
            void $receiver$iv$iv;
            DamageSource damageSource2 = e.getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)damageSource2, (String)"e.source");
            Entity entity = damageSource2.func_76346_g();
            if (entity == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
            }
            EntityPlayer player = (EntityPlayer)entity;
            NonNullList nonNullList = player.field_71071_by.field_70462_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)nonNullList, (String)"player.inventory.mainInventory");
            Iterable $receiver$iv = (Iterable)nonNullList;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                ItemStack it;
                ItemStack itemStack = it = (ItemStack)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"it");
                if (!(itemStack.func_77973_b() instanceof ItemBounty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List bountyStacks = (List)destination$iv$iv;
            $receiver$iv = bountyStacks;
            if (!$receiver$iv.isEmpty()) {
                $receiver$iv = bountyStacks;
                for (Object element$iv : $receiver$iv) {
                    ItemStack stack;
                    ItemStack itemStack = stack = (ItemStack)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                    if (!BountyData.Companion.isValidBounty(itemStack)) continue;
                    BountyData data = BountyData.Companion.from(stack);
                    EntityLivingBase entityLivingBase = e.getEntityLiving();
                    Intrinsics.checkExpressionValueIsNotNull((Object)entityLivingBase, (String)"e.entityLiving");
                    BountyChecker.INSTANCE.tryTakeEntities(player, data, stack, entityLivingBase);
                }
            }
        }
    }

    @SubscribeEvent
    public final void onWorldTick(@NotNull TickEvent.WorldTickEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (!e.world.field_72995_K && Bountiful.INSTANCE.getConfig().getGlobalBounties() && e.phase == TickEvent.Phase.END) {
            World world = e.world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"e.world");
            Capability<IGlobalBoard> capability = CapManager.INSTANCE.getCAP_BOARD();
            if (capability == null) {
                Intrinsics.throwNpe();
            }
            ExtMiscKt.ifHasCapability(world, capability, (Function1)new Function1<IGlobalBoard, Unit>(e){
                final /* synthetic */ TickEvent.WorldTickEvent $e;

                public final void invoke(@NotNull IGlobalBoard $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    BountyHolder bountyHolder = $receiver.getHolder();
                    World world = this.$e.world;
                    Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"e.world");
                    bountyHolder.update(world, null);
                }
                {
                    this.$e = worldTickEvent;
                    super(1);
                }
            });
        }
    }

    @SubscribeEvent
    public final void attachCaps(@NotNull AttachCapabilitiesEvent<World> e) {
        Intrinsics.checkParameterIsNotNull(e, (String)"e");
        e.addCapability(new ResourceLocation("bountiful", "GlobalData"), (ICapabilityProvider)new GlobBoardProvider());
    }

    @SubscribeEvent
    public final void onBoardPost(@NotNull PopulateBountyBoardEvent e) {
        block1: {
            ITileEntityBountyBoard iTileEntityBountyBoard;
            ITileEntityBountyBoard it;
            Intrinsics.checkParameterIsNotNull((Object)((Object)e), (String)"e");
            if (!e.getStack().func_77942_o()) {
                e.setCanceled(true);
            }
            ITileEntityBountyBoard iTileEntityBountyBoard2 = e.getBoard();
            if (iTileEntityBountyBoard2 == null || !(it = (iTileEntityBountyBoard = iTileEntityBountyBoard2)).getNewBoard()) break block1;
            it.setNewBoard(false);
            e.setCanceled(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postInit(@NotNull FMLPostInitializationEvent e) {
        IPickCommon it;
        Object element$iv;
        Collection<PickedEntry> collection;
        Collection $receiver$iv$iv;
        void $receiver$iv;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        String it2 = string = "bounties.json";
        BountifulIO.INSTANCE.populateConfigFolder(Bountiful.INSTANCE.getConfigDir(), DefaultData.INSTANCE.getEntries().getItems(), it2);
        Iterable<IPickCommon> invalids = BountifulIO.INSTANCE.hotReloadBounties();
        Collection collection2 = invalids;
        if (!collection2.isEmpty()) {
            throw (Throwable)new Exception("'bountiful/bounties.json' contains one or more invalid bounties. Invalid bounty objectives: " + invalids);
        }
        int minObjectives22 = Bountiful.INSTANCE.getConfig().getBountyAmountRange().getLast();
        if (BountyRegistry.INSTANCE.getItems().size() < minObjectives22) {
            throw (Throwable)new Exception("Config file needs more bounties! Must have at least " + minObjectives22 + " bounty objectives to choose from, according to the current config.");
        }
        it2 = string = "rewards.json";
        invalids = DefaultData.INSTANCE.getRewards().getItems();
        File minObjectives22 = Bountiful.INSTANCE.getConfigDir();
        BountifulIO $i$a$1$let = BountifulIO.INSTANCE;
        void var7_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void item;
            PickedEntryStack pickedEntryStack = (PickedEntryStack)item$iv$iv;
            collection = destination$iv$iv;
            PickedEntry pickedEntry = item.getGenericPick();
            collection.add(pickedEntry);
        }
        collection = (List)destination$iv$iv;
        $i$a$1$let.populateConfigFolder(minObjectives22, (List<? extends Object>)collection, it2);
        invalids = BountifulIO.INSTANCE.hotReloadRewards();
        $receiver$iv$iv = invalids;
        if (!$receiver$iv$iv.isEmpty()) {
            throw (Throwable)new Exception("'bountiful/rewards.json' contains one or more invalid rewards. Invalid rewards: " + invalids);
        }
        BountifulStats.INSTANCE.register();
        string = "Bounties: " + BountyRegistry.INSTANCE.getItems().size();
        System.out.println((Object)string);
        Object $receiver$iv2 = BountyRegistry.INSTANCE.getItems();
        Iterator iterator = $receiver$iv2.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (PickableEntry)element$iv;
            System.out.println(it);
        }
        $receiver$iv2 = "Rewards: " + RewardRegistry.INSTANCE.getItems().size();
        System.out.println($receiver$iv2);
        $receiver$iv2 = RewardRegistry.INSTANCE.getItems();
        iterator = $receiver$iv2.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (PickedEntryStack)element$iv;
            System.out.println(it);
        }
    }

    @Override
    public void init(@NotNull FMLInitializationEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        IProxy.DefaultImpls.init(this, e);
    }
}

