/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.asm;

import com.charles445.simpledifficulty.asm.ShadowMap;
import com.charles445.simpledifficulty.asm.helper.ASMHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class SimpleDifficultyASM
implements IClassTransformer {
    Logger logger = LogManager.getLogger((String)"SimpleDifficultyASM");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.startsWith("com.charles445.simpledifficulty.compat.mod.")) {
            return this.redirectShadowed(basicClass);
        }
        return basicClass;
    }

    public byte[] redirectShadowed(byte[] basicClass) {
        ClassNode clazzNode = ASMHelper.readClassFromBytes(basicClass);
        List annotations = clazzNode.visibleAnnotations;
        if (annotations == null) {
            return basicClass;
        }
        boolean hasAnnotation = false;
        for (AnnotationNode annotation : annotations) {
            if (annotation == null || !"Lcom/charles445/simpledifficulty/compat/HasShadows;".equals(annotation.desc)) continue;
            this.logger.info("Found class with shadows: " + clazzNode.name);
            if (clazzNode.interfaces != null) {
                ArrayList<String> readdedInterfaces = new ArrayList<String>();
                Iterator it = clazzNode.interfaces.iterator();
                while (it.hasNext()) {
                    readdedInterfaces.add(this.swapOwner((String)it.next()));
                    it.remove();
                }
                for (String iface : readdedInterfaces) {
                    clazzNode.interfaces.add(iface);
                }
            }
            if (clazzNode.fields != null) {
                for (FieldNode fNode : clazzNode.fields) {
                    fNode.desc = this.swapDesc(fNode.desc);
                }
            }
            if (clazzNode.methods != null) {
                for (MethodNode mNode : clazzNode.methods) {
                    mNode.desc = this.swapDesc(mNode.desc);
                    if (mNode.localVariables != null) {
                        for (LocalVariableNode lvn : mNode.localVariables) {
                            lvn.desc = this.swapDesc(lvn.desc);
                        }
                    }
                    if (mNode.instructions == null) continue;
                    for (AbstractInsnNode anchor = mNode.instructions.getFirst(); anchor != null; anchor = anchor.getNext()) {
                        this.shadowInsnNode(anchor);
                    }
                }
            }
            this.logger.info("Rewriting class with shadows: " + clazzNode.name);
            return ASMHelper.writeClassToBytes(clazzNode, 1);
        }
        return basicClass;
    }

    public void shadowInsnNode(AbstractInsnNode anchor) {
        int type = anchor.getType();
        if (type == 4) {
            FieldInsnNode node = (FieldInsnNode)anchor;
            node.owner = this.swapOwner(node.owner);
            node.desc = this.swapDesc(node.desc);
        } else if (type == 5) {
            MethodInsnNode node = (MethodInsnNode)anchor;
            node.owner = this.swapOwner(node.owner);
            node.desc = this.swapDesc(node.desc);
        } else if (type == 3) {
            TypeInsnNode node = (TypeInsnNode)anchor;
            node.desc = this.swapOwner(node.desc);
        } else if (type == 14) {
            Iterator it;
            ArrayList<String> replaceList;
            FrameNode frame = (FrameNode)anchor;
            if (frame.local != null) {
                replaceList = new ArrayList<String>();
                it = replaceList.iterator();
                while (it.hasNext()) {
                    for (int i = 0; i < frame.local.size(); ++i) {
                        Object e = frame.local.get(i);
                        if (e instanceof String) {
                            replaceList.add(this.swapOwner((String)e));
                        } else {
                            replaceList.add((String)e);
                        }
                        it.remove();
                    }
                }
                for (Object e : replaceList) {
                    frame.local.add(e);
                }
            }
            if (frame.stack != null) {
                replaceList = new ArrayList();
                it = replaceList.iterator();
                while (it.hasNext()) {
                    for (int i = 0; i < frame.stack.size(); ++i) {
                        Object e = frame.stack.get(i);
                        if (e instanceof String) {
                            replaceList.add(this.swapOwner((String)e));
                        } else {
                            replaceList.add((String)e);
                        }
                        it.remove();
                    }
                }
                for (Object e : replaceList) {
                    frame.stack.add(e);
                }
            }
        }
    }

    @Nullable
    private String swapOwner(String owner) {
        if (owner == null) {
            return null;
        }
        String swap = ShadowMap.ownerMap.get(owner);
        if (swap != null) {
            return swap;
        }
        return owner;
    }

    @Nullable
    private String swapDesc(String desc) {
        if (desc == null) {
            return null;
        }
        String result = desc;
        for (Map.Entry<String, String> entry : ShadowMap.descMap.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

