/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.capability;

import com.charles445.simpledifficulty.api.SDDamageSources;
import com.charles445.simpledifficulty.api.thirst.IThirstCapability;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.util.DamageUtil;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ThirstCapability
implements IThirstCapability {
    private float exhaustion = 0.0f;
    private int thirst = 20;
    private float saturation = 5.0f;
    private int ticktimer = 0;
    private int damagecounter = 0;
    private int oldthirst = 0;
    private float oldsaturation = 0.0f;
    Vector3d position = null;
    private int packetTimer = 0;

    @Override
    public void tickUpdate(EntityPlayer player, World world, TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.START) {
            ++this.packetTimer;
            return;
        }
        if (this.position == null) {
            this.position = new Vector3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
        Vector3d newPosition = new Vector3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        this.position.sub((Tuple3d)newPosition);
        this.position.absolute();
        int moveDistance = (int)Math.round(this.position.length() * 100.0);
        this.position = newPosition;
        if (moveDistance > 1000) {
            moveDistance = 0;
        }
        if (moveDistance > 0) {
            float moveSensitivity = (float)ModConfig.server.thirst.thirstBaseMovement;
            if (player.func_70090_H() || player.func_70055_a(Material.field_151586_h)) {
                moveSensitivity = (float)ModConfig.server.thirst.thirstSwimmingMovement;
            } else if (player.field_70122_E) {
                moveSensitivity = player.func_70051_ag() ? (float)ModConfig.server.thirst.thirstSprintingMovement : (float)ModConfig.server.thirst.thirstWalkingMovement;
            }
            this.addThirstExhaustion(moveSensitivity * 0.01f * (float)moveDistance);
        }
        if (this.getThirstExhaustion() > (float)ModConfig.server.thirst.thirstExhaustionLimit) {
            this.addThirstExhaustion(-1.0f * (float)ModConfig.server.thirst.thirstExhaustionLimit);
            if (this.getThirstSaturation() > 0.0f) {
                this.addThirstSaturation(-1.0f);
            } else if (DamageUtil.isModDangerous(world)) {
                this.addThirstLevel(-1);
            }
        }
        if (this.getThirstLevel() <= 0) {
            this.addThirstTickTimer(1);
            if (this.getThirstTickTimer() >= 80) {
                this.setThirstTickTimer(0);
                if (DamageUtil.isModDangerous(world) && DamageUtil.healthAboveDifficulty(world, player)) {
                    float thirstDamageToApply = 1.0f + 1.0f * (float)this.getThirstDamageCounter() * (float)ModConfig.server.thirst.thirstDamageScaling;
                    player.func_70097_a(SDDamageSources.DEHYDRATION, thirstDamageToApply);
                    this.addThirstDamageCounter(1);
                }
            }
        } else {
            this.setThirstTickTimer(0);
            this.setThirstDamageCounter(0);
        }
    }

    private void checkSprint(EntityPlayer player) {
        if (player.func_70051_ag() && this.getThirstLevel() <= 6) {
            player.func_70031_b(false);
        }
    }

    @Override
    public boolean isDirty() {
        return this.thirst != this.oldthirst || this.saturation != this.oldsaturation;
    }

    @Override
    public void setClean() {
        this.oldthirst = this.thirst;
        this.oldsaturation = this.saturation;
    }

    @Override
    public float getThirstExhaustion() {
        return this.exhaustion;
    }

    @Override
    public int getThirstLevel() {
        return this.thirst;
    }

    @Override
    public float getThirstSaturation() {
        return this.saturation;
    }

    @Override
    public int getThirstTickTimer() {
        return this.ticktimer;
    }

    @Override
    public int getThirstDamageCounter() {
        return this.damagecounter;
    }

    @Override
    public void setThirstExhaustion(float exhaustion) {
        this.exhaustion = Math.max(exhaustion, 0.0f);
        if (!Float.isFinite(this.exhaustion)) {
            this.exhaustion = 0.0f;
        }
    }

    @Override
    public void setThirstLevel(int thirst) {
        this.thirst = MathHelper.func_76125_a((int)thirst, (int)0, (int)20);
    }

    @Override
    public void setThirstSaturation(float saturation) {
        this.saturation = MathHelper.func_76131_a((float)saturation, (float)0.0f, (float)20.0f);
        if (!Float.isFinite(this.saturation)) {
            this.saturation = 0.0f;
        }
    }

    @Override
    public void setThirstTickTimer(int ticktimer) {
        this.ticktimer = ticktimer;
    }

    @Override
    public void setThirstDamageCounter(int damagecounter) {
        this.damagecounter = damagecounter;
    }

    @Override
    public void addThirstExhaustion(float exhaustion) {
        this.setThirstExhaustion(this.getThirstExhaustion() + exhaustion);
    }

    @Override
    public void addThirstLevel(int thirst) {
        this.setThirstLevel(this.getThirstLevel() + thirst);
    }

    @Override
    public void addThirstSaturation(float saturation) {
        this.setThirstSaturation(this.getThirstSaturation() + saturation);
    }

    @Override
    public void addThirstTickTimer(int ticktimer) {
        this.setThirstTickTimer(this.getThirstTickTimer() + ticktimer);
    }

    @Override
    public void addThirstDamageCounter(int damagecounter) {
        this.setThirstDamageCounter(this.getThirstDamageCounter() + damagecounter);
    }

    @Override
    public boolean isThirsty() {
        return this.getThirstLevel() < 20;
    }

    @Override
    public int getPacketTimer() {
        return this.packetTimer;
    }
}

