/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.command;

import com.charles445.simpledifficulty.SimpleDifficulty;
import com.charles445.simpledifficulty.api.SDCapabilities;
import com.charles445.simpledifficulty.api.config.JsonConfig;
import com.charles445.simpledifficulty.api.config.json.JsonItemIdentity;
import com.charles445.simpledifficulty.api.config.json.JsonPropertyValue;
import com.charles445.simpledifficulty.api.temperature.ITemperatureCapability;
import com.charles445.simpledifficulty.api.thirst.IThirstCapability;
import com.charles445.simpledifficulty.config.JsonConfigInternal;
import com.charles445.simpledifficulty.config.JsonFileName;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class CommandSimpleDifficulty
extends CommandBase {
    private final List<String> tabCompletionsCommands = Arrays.asList("help", "exportJson", "reloadJson", "addArmor", "addBlock", "addConsumableTemperature", "addConsumableThirst", "addDimension", "addFluid", "addHeldItem", "nbt", "setThirst", "setTemperature");
    private final String commandUsage = "/simpledifficulty help";
    private final String listOfCommands = "   help <command>\n   exportJson\n   reloadJson\n   addArmor <temperature>\n   addBlock <temperature>\n   addConsumableTemperature <group> <temperature> <duration>\n   addConsumableThirst <amount> <saturation> <thirstyChance>\n   addDimension <temperature>\n   addFluid <temperature>\n   addHeldItem <temperature>\n   nbt\n   setThirst <thirst> <saturation>\n   setTemperature <temperature>";
    private final String warn_notPlayerAdmin = "You do not have permission, or are not a player ingame!";
    private final String warn_invalidArgs = "Invalid Arguments";
    private final String warn_noItem = "Not holding an item!";
    private final String exportJsonReminder = "(Don't forget to exportJson !)";

    public List<String> func_71514_a() {
        return Arrays.asList("sd");
    }

    public String func_71517_b() {
        return "simpledifficulty";
    }

    public int func_82362_a() {
        return 0;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/simpledifficulty help";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandSimpleDifficulty.func_175762_a((String[])args, this.tabCompletionsCommands);
        }
        if (args.length == 0) {
            return this.tabCompletionsCommands;
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.help(sender);
            return;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "reloadjson": {
                this.updateJson(server, sender, args);
                break;
            }
            case "exportjson": {
                this.exportJson(server, sender, args);
                break;
            }
            case "addarmor": {
                this.addArmor(server, sender, args);
                break;
            }
            case "addblock": {
                this.addBlock(server, sender, args);
                break;
            }
            case "addconsumabletemperature": {
                this.addConsumableTemperature(server, sender, args);
                break;
            }
            case "addconsumablethirst": {
                this.addConsumableThirst(server, sender, args);
                break;
            }
            case "adddimension": {
                this.addDimension(server, sender, args);
                break;
            }
            case "addfluid": {
                this.addFluid(server, sender, args);
                break;
            }
            case "addhelditem": {
                this.addHeldItem(server, sender, args);
                break;
            }
            case "nbt": {
                this.tagToString(server, sender, args);
                break;
            }
            case "setthirst": {
                this.setThirst(server, sender, args);
                break;
            }
            case "settemperature": {
                this.setTemperature(server, sender, args);
                break;
            }
            case "help": {
                this.helpCommand(server, sender, args);
                break;
            }
            default: {
                this.help(sender);
            }
        }
    }

    private void helpCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 2) {
            this.message(sender, "   help <command>\n   exportJson\n   reloadJson\n   addArmor <temperature>\n   addBlock <temperature>\n   addConsumableTemperature <group> <temperature> <duration>\n   addConsumableThirst <amount> <saturation> <thirstyChance>\n   addDimension <temperature>\n   addFluid <temperature>\n   addHeldItem <temperature>\n   nbt\n   setThirst <thirst> <saturation>\n   setTemperature <temperature>");
            return;
        }
        switch (args[1].toLowerCase()) {
            case "help": {
                this.message(sender, "If you need more help, you can contact the mod author on CurseForge or GitHub");
                return;
            }
            case "exportjson": {
                this.message(sender, "Exports your in-game JSON changes to the config folder");
                return;
            }
            case "reloadjson": {
                this.message(sender, "Discards any unexported in-game JSON changes.\nReloads the JSON from the config folder");
                return;
            }
            case "addarmor": {
                this.message(sender, "Adds the held armor to the armor JSON\n(changes temperature when worn)\nAdd argument --nbt to include NBT tag\nAdd argument --clear to remove the item from JSON first (ignores metadata and nbt)");
                return;
            }
            case "addblock": {
                this.message(sender, "Adds the held block to the block JSON\n(changes temperature when near the block)\nAdd argument --clear to remove the block from JSON first (ignores metadata and state)");
                return;
            }
            case "addconsumabletemperature": {
                this.message(sender, "Adds the held item to the consumableTemperature JSON\n(modifies temperature over time when consumed)\nAdd argument --nbt to include NBT tag\nAdd argument --clear to remove the item from JSON first (ignores metadata and nbt)");
                return;
            }
            case "addconsumablethirst": {
                this.message(sender, "Adds the held item to the consumableThirst JSON\n(replenishes thirst when consumed)\nAdd argument --nbt to include NBT tag\nAdd argument --clear to remove the item from JSON first (ignores metadata and nbt)");
                return;
            }
            case "adddimension": {
                this.message(sender, "Adds the dimension the player is in to the dimensionTemperature JSON");
                return;
            }
            case "addfluid": {
                this.message(sender, "Adds the held fluid item to the fluid JSON\n(changes temperature when inside the fluid)");
                return;
            }
            case "addhelditem": {
                this.message(sender, "Adds the held item to the heldItems JSON\n(changes player temperature when held in mainhand or offhand)\nAdd argument --nbt to include NBT tag\nAdd argument --clear to remove the item from JSON first (ignores metadata and nbt)");
                return;
            }
            case "nbt": {
                this.message(sender, "Gets an item's NBT tag as a string for config use");
                return;
            }
            case "setthirst": {
                this.message(sender, "Sets the player's thirst");
                return;
            }
            case "settemperature": {
                this.message(sender, "Sets the player's temperature");
                return;
            }
        }
        this.message(sender, "/simpledifficulty help <command> \n(Replace <command> with a simpledifficulty command name)");
    }

    private void setThirst(MinecraftServer server, ICommandSender sender, String[] args) {
        if (this.isAdminPlayer(sender)) {
            try {
                if (args.length < 2) {
                    this.message(sender, "Invalid Arguments <modid>");
                    return;
                }
                EntityPlayer player = (EntityPlayer)sender.func_174793_f();
                IThirstCapability capability = SDCapabilities.getThirstData(player);
                capability.setThirstLevel(Integer.parseInt(args[1]));
                if (args.length >= 3) {
                    capability.setThirstSaturation(Float.parseFloat(args[2]));
                }
            }
            catch (NumberFormatException e) {
                this.message(sender, "Invalid Arguments <thirst> <saturation>");
                return;
            }
        }
    }

    private void setTemperature(MinecraftServer server, ICommandSender sender, String[] args) {
        if (this.isAdminPlayer(sender)) {
            try {
                if (args.length < 2) {
                    this.message(sender, "Invalid Arguments <temperature>");
                    return;
                }
                EntityPlayer player = (EntityPlayer)sender.func_174793_f();
                ITemperatureCapability capability = SDCapabilities.getTemperatureData(player);
                capability.setTemperatureLevel(Integer.parseInt(args[1]));
            }
            catch (NumberFormatException e) {
                this.message(sender, "Invalid Arguments <temperature>");
                return;
            }
        }
    }

    private void tagToString(MinecraftServer server, ICommandSender sender, String[] args) {
        if (this.isAdminPlayer(sender)) {
            EntityPlayer player = (EntityPlayer)sender.func_174793_f();
            ItemStack stack = player.func_184614_ca();
            if (stack.func_190926_b()) {
                this.message(sender, "Not holding an item!");
                return;
            }
            if (stack.func_77942_o()) {
                NBTTagCompound compound = stack.func_77978_p();
                String compString = compound.toString();
                TextComponentString tc = new TextComponentString(compString);
                int metadata = this.getMetadataFromStack(stack);
                Style style = new Style();
                style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/sdcopyidentity " + metadata + " " + compString));
                style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to copy identity to clipboard")));
                tc.func_150255_a(style);
                sender.func_145747_a((ITextComponent)tc);
            } else {
                this.message(sender, "This item has no NBT tag.");
            }
        } else {
            this.message(sender, "You do not have permission, or are not a player ingame!");
        }
    }

    private int getMetadataFromStack(ItemStack stack) {
        return stack.func_77981_g() ? stack.func_77960_j() : -1;
    }

    private void addBlock(MinecraftServer server, ICommandSender sender, String[] args) {
        if (this.isAdminPlayer(sender)) {
            if (args.length < 2) {
                this.message(sender, "Invalid Arguments <temperature>");
                return;
            }
            try {
                boolean accepted;
                float temperature = Float.parseFloat(args[1]);
                EntityPlayer player = (EntityPlayer)sender.func_174793_f();
                ItemStack stack = player.func_184614_ca();
                if (stack.func_190926_b()) {
                    this.message(sender, "Not holding an item!");
                    return;
                }
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                if (block == Blocks.field_150350_a) {
                    FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
                    if (fluidStack != null) {
                        block = fluidStack.getFluid().getBlock();
                        if (block == Blocks.field_150350_a) {
                            this.message(sender, "Couldn't find block for fluid!");
                            return;
                        }
                        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                            block = Blocks.field_150356_k;
                            JsonConfig.registerBlockTemperature((Block)Blocks.field_150353_l, temperature, new JsonPropertyValue[0]);
                        } else if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                            block = Blocks.field_150358_i;
                            JsonConfig.registerBlockTemperature((Block)Blocks.field_150355_j, temperature, new JsonPropertyValue[0]);
                        }
                    } else {
                        this.message(sender, "Couldn't find block for item!");
                        return;
                    }
                }
                if (this.hasClearArgument(args)) {
                    JsonConfig.blockTemperatures.remove(block.getRegistryName().toString());
                    this.message(sender, "Removed from JSON");
                }
                if (accepted = JsonConfig.registerBlockTemperature(block, temperature, new JsonPropertyValue[0])) {
                    this.message(sender, "Added block to " + (Object)((Object)JsonFileName.blockTemperatures) + "!\n" + "(Don't forget to exportJson !)");
                }
                this.message(sender, "Block has properties information in the JSON, use the JSON instead!");
            }
            catch (NumberFormatException e) {
                this.message(sender, "Invalid Arguments <temperature>");
                return;
            }
        } else {
            this.message(sender, "You do not have permission, or are not a player ingame!");
        }
    }

    private void addDimension(MinecraftServer server, ICommandSender sender, String[] args) {
        if (this.isAdminPlayer(sender)) {
            if (args.length < 2) {
                this.message(sender, "Invalid Arguments <temperature>");
                return;
            }
            try {
                float temperature = Float.parseFloat(args[1]);
                EntityPlayer player = (EntityPlayer)sender.func_174793_f();
                World world = player.field_70170_p;
                if (world == null) {
                    return;
                }
                JsonConfig.registerDimensionTemperature(world.field_73011_w.getDimension(), temperature);
                this.message(sender, "Added dimension to " + (Object)((Object)JsonFileName.dimensionTemperature) + "!\n" + "(Don't forget to exportJson !)");
            }
            catch (NumberFormatException e) {
                this.message(sender, "Invalid Arguments <temperature>");
                return;
            }
        } else {
            this.message(sender, "You do not have permission, or are not a player ingame!");
        }
    }

    private void addFluid(MinecraftServer server, ICommandSender sender, String[] args) {
        if (this.isAdminPlayer(sender)) {
            if (args.length < 2) {
                this.message(sender, "Invalid Arguments <temperature>");
                return;
            }
            try {
                float temperature = Float.parseFloat(args[1]);
                EntityPlayer player = (EntityPlayer)sender.func_174793_f();
                ItemStack stack = player.func_184614_ca();
                if (stack.func_190926_b()) {
                    this.message(sender, "Not holding an item!");
                    return;
                }
                FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
                if (fluidStack == null) {
                    this.message(sender, "Couldn't find the item's fluid!");
                    return;
                }
                JsonConfig.registerFluidTemperature(fluidStack.getFluid().getName(), temperature);
                this.message(sender, "Added fluid to " + (Object)((Object)JsonFileName.consumableThirst) + "!\n" + "(Don't forget to exportJson !)");
            }
            catch (NumberFormatException e) {
                this.message(sender, "Invalid Arguments <temperature>");
                return;
            }
        } else {
            this.message(sender, "You do not have permission, or are not a player ingame!");
        }
    }

    private void addConsumableThirst(MinecraftServer server, ICommandSender sender, String[] args) {
        if (this.isAdminPlayer(sender)) {
            if (args.length < 4) {
                this.message(sender, "Invalid Arguments <amount> <saturation> <thirstyChance>");
                return;
            }
            try {
                boolean nbtArgument;
                int amount = Integer.parseInt(args[1]);
                float saturation = Float.parseFloat(args[2]);
                float thirstyChance = Float.parseFloat(args[3]);
                EntityPlayer player = (EntityPlayer)sender.func_174793_f();
                ItemStack stack = player.func_184614_ca();
                if (stack.func_190926_b()) {
                    this.message(sender, "Not holding an item!");
                    return;
                }
                if (this.hasClearArgument(args)) {
                    JsonConfig.consumableThirst.remove(this.getRegistryName(stack));
                    this.message(sender, "Removed from JSON");
                }
                if ((nbtArgument = this.hasNBTArgument(args)) && stack.func_77942_o()) {
                    JsonConfig.registerConsumableThirst(this.getRegistryName(stack), amount, saturation, thirstyChance, this.getFullIdentity(stack));
                    this.message(sender, "Added consumable item with nbt to " + (Object)((Object)JsonFileName.consumableThirst) + "!\n" + "(Don't forget to exportJson !)");
                }
                JsonConfig.registerConsumableThirst(stack, amount, saturation, thirstyChance);
                this.message(sender, "Added consumable item to " + (Object)((Object)JsonFileName.consumableThirst) + "!\n" + "(Don't forget to exportJson !)");
            }
            catch (NumberFormatException e) {
                this.message(sender, "Invalid Arguments <amount> <saturation> <thirstyChance>");
                return;
            }
        } else {
            this.message(sender, "You do not have permission, or are not a player ingame!");
        }
    }

    private void addHeldItem(MinecraftServer server, ICommandSender sender, String[] args) {
        if (this.isAdminPlayer(sender)) {
            if (args.length < 2) {
                this.message(sender, "Invalid Arguments <temperature>");
                return;
            }
            try {
                boolean nbtArgument;
                float temperature = Float.parseFloat(args[1]);
                EntityPlayer player = (EntityPlayer)sender.func_174793_f();
                ItemStack stack = player.func_184614_ca();
                if (stack.func_190926_b()) {
                    this.message(sender, "Not holding an item!");
                    return;
                }
                if (this.hasClearArgument(args)) {
                    JsonConfig.heldItemTemperatures.remove(this.getRegistryName(stack));
                    this.message(sender, "Removed from JSON");
                }
                if ((nbtArgument = this.hasNBTArgument(args)) && stack.func_77942_o()) {
                    JsonConfig.registerHeldItem(this.getRegistryName(stack), temperature, this.getFullIdentity(stack));
                    this.message(sender, "Added held item with nbt to " + (Object)((Object)JsonFileName.heldItemTemperatures) + "!\n" + "(Don't forget to exportJson !)");
                }
                JsonConfig.registerHeldItem(stack, temperature);
                this.message(sender, "Added held item to " + (Object)((Object)JsonFileName.heldItemTemperatures) + "!\n" + "(Don't forget to exportJson !)");
            }
            catch (NumberFormatException e) {
                this.message(sender, "Invalid Arguments <temperature>");
                return;
            }
        } else {
            this.message(sender, "You do not have permission, or are not a player ingame!");
        }
    }

    private void addConsumableTemperature(MinecraftServer server, ICommandSender sender, String[] args) {
        if (this.isAdminPlayer(sender)) {
            if (args.length < 4) {
                this.message(sender, "Invalid Arguments <group> <temperature> <duration>");
                return;
            }
            try {
                boolean nbtArgument;
                String group = args[1];
                float temperature = Float.parseFloat(args[2]);
                int duration = Integer.parseInt(args[3]);
                group = group.replaceAll("\"", "");
                EntityPlayer player = (EntityPlayer)sender.func_174793_f();
                ItemStack stack = player.func_184614_ca();
                if (stack.func_190926_b()) {
                    this.message(sender, "Not holding an item!");
                    return;
                }
                if (this.hasClearArgument(args)) {
                    JsonConfig.consumableTemperature.remove(this.getRegistryName(stack));
                    this.message(sender, "Removed from JSON");
                }
                if ((nbtArgument = this.hasNBTArgument(args)) && stack.func_77942_o()) {
                    JsonConfig.registerConsumableTemperature(group, this.getRegistryName(stack), temperature, duration, this.getFullIdentity(stack));
                    this.message(sender, "Added consumable item with nbt to " + (Object)((Object)JsonFileName.consumableTemperature) + "!\n" + "(Don't forget to exportJson !)");
                }
                JsonConfig.registerConsumableTemperature(group, stack, temperature, duration);
                this.message(sender, "Added consumable item to " + (Object)((Object)JsonFileName.consumableTemperature) + "!\n" + "(Don't forget to exportJson !)");
            }
            catch (NumberFormatException e) {
                this.message(sender, "Invalid Arguments <group> <temperature> <duration>");
                return;
            }
        } else {
            this.message(sender, "You do not have permission, or are not a player ingame!");
        }
    }

    private void addArmor(MinecraftServer server, ICommandSender sender, String[] args) {
        if (this.isAdminPlayer(sender)) {
            if (args.length < 2) {
                this.message(sender, "Invalid Arguments <temperature>");
                return;
            }
            try {
                boolean nbtArgument;
                float temperature = Float.parseFloat(args[1]);
                EntityPlayer player = (EntityPlayer)sender.func_174793_f();
                ItemStack stack = player.func_184614_ca();
                if (stack.func_190926_b()) {
                    this.message(sender, "Not holding an item!");
                    return;
                }
                if (this.hasClearArgument(args)) {
                    JsonConfig.armorTemperatures.remove(this.getRegistryName(stack));
                    this.message(sender, "Removed from JSON");
                }
                if ((nbtArgument = this.hasNBTArgument(args)) && stack.func_77942_o()) {
                    JsonConfig.registerArmorTemperature(this.getRegistryName(stack), temperature, this.getFullIdentity(stack));
                    this.message(sender, "Added armor with nbt to " + (Object)((Object)JsonFileName.armorTemperatures) + "!\n" + "(Don't forget to exportJson !)");
                }
                JsonConfig.registerArmorTemperature(stack, temperature);
                this.message(sender, "Added armor to " + (Object)((Object)JsonFileName.armorTemperatures) + "!\n" + "(Don't forget to exportJson !)");
            }
            catch (NumberFormatException e) {
                this.message(sender, "Invalid Arguments <temperature>");
                return;
            }
        } else {
            this.message(sender, "You do not have permission, or are not a player ingame!");
        }
    }

    private String getRegistryName(ItemStack stack) {
        return stack.func_77973_b().getRegistryName().toString();
    }

    private JsonItemIdentity getFullIdentity(ItemStack stack) {
        if (stack.func_77942_o()) {
            return new JsonItemIdentity(this.getMetadataFromStack(stack), stack.func_77978_p().toString());
        }
        return new JsonItemIdentity(this.getMetadataFromStack(stack));
    }

    private void exportJson(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (this.hasPermissionLevel(sender, 4)) {
            this.message(sender, "Exporting SimpleDifficulty JSON");
            String result = JsonConfigInternal.manuallyExportAll();
            this.message(sender, result);
        }
    }

    private void updateJson(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (this.hasPermissionLevel(sender, 4)) {
            this.message(sender, "Reloading SimpleDifficulty JSON");
            JsonConfigInternal.jsonErrors.clear();
            JsonConfigInternal.clearContainers();
            JsonConfigInternal.postInit(SimpleDifficulty.jsonDirectory);
            for (String s : JsonConfigInternal.jsonErrors) {
                sender.func_145747_a((ITextComponent)new TextComponentString(s));
            }
        }
    }

    private boolean isAdminPlayer(ICommandSender sender) {
        return this.hasPermissionLevel(sender, 4) && sender.func_174793_f() instanceof EntityPlayer;
    }

    private void help(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
    }

    private void message(ICommandSender sender, String message) {
        sender.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    private boolean hasPermissionLevel(ICommandSender sender, int permLevel) {
        return sender.func_70003_b(permLevel, "simpledifficulty");
    }

    private boolean hasNBTArgument(String[] input) {
        return this.hasArgument("--nbt", input);
    }

    private boolean hasClearArgument(String[] input) {
        return this.hasArgument("--clear", input);
    }

    private boolean hasArgument(String argument, String[] input) {
        if (input == null) {
            return false;
        }
        for (String s : input) {
            if (!s.equals(argument)) continue;
            return true;
        }
        return false;
    }
}

