/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.handler;

import com.charles445.simpledifficulty.api.SDCapabilities;
import com.charles445.simpledifficulty.api.config.QuickConfig;
import com.charles445.simpledifficulty.api.temperature.ITemperatureCapability;
import com.charles445.simpledifficulty.api.thirst.IThirstCapability;
import com.charles445.simpledifficulty.capability.TemperatureProvider;
import com.charles445.simpledifficulty.capability.ThirstProvider;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.network.MessageUpdateTemperature;
import com.charles445.simpledifficulty.network.MessageUpdateThirst;
import com.charles445.simpledifficulty.network.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityHandler {
    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("simpledifficulty", "temperature"), (ICapabilityProvider)new TemperatureProvider(SDCapabilities.TEMPERATURE));
            event.addCapability(new ResourceLocation("simpledifficulty", "thirst"), (ICapabilityProvider)new ThirstProvider(SDCapabilities.THIRST));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        int packetTimerThreshold = ModConfig.server.miscellaneous.routinePacketDelay;
        if (QuickConfig.isTemperatureEnabled()) {
            ITemperatureCapability temperatureCapability = SDCapabilities.getTemperatureData(player);
            temperatureCapability.tickUpdate(player, world, event.phase);
            if (event.phase == TickEvent.Phase.START && (temperatureCapability.isDirty() || temperatureCapability.getPacketTimer() % packetTimerThreshold == 0)) {
                temperatureCapability.setClean();
                this.sendTemperatureUpdate((EntityPlayerMP)player);
            }
        }
        if (QuickConfig.isThirstEnabled() && !this.shouldPlayerSkipThirst(player)) {
            IThirstCapability thirstCapability = SDCapabilities.getThirstData(player);
            thirstCapability.tickUpdate(player, world, event.phase);
            if (event.phase == TickEvent.Phase.START && (thirstCapability.isDirty() || thirstCapability.getPacketTimer() % packetTimerThreshold == 0)) {
                thirstCapability.setClean();
                this.sendThirstUpdate((EntityPlayerMP)player);
            }
        }
    }

    private boolean shouldPlayerSkipThirst(EntityPlayer player) {
        return player.func_175149_v() || player.func_184812_l_();
    }

    private void sendTemperatureUpdate(EntityPlayerMP player) {
        Capability<ITemperatureCapability> capability = SDCapabilities.TEMPERATURE;
        MessageUpdateTemperature message = new MessageUpdateTemperature(capability.getStorage().writeNBT(capability, (Object)SDCapabilities.getTemperatureData((EntityPlayer)player), null));
        PacketHandler.instance.sendTo((IMessage)message, player);
    }

    private void sendThirstUpdate(EntityPlayerMP player) {
        Capability<IThirstCapability> capability = SDCapabilities.THIRST;
        MessageUpdateThirst message = new MessageUpdateThirst(capability.getStorage().writeNBT(capability, (Object)SDCapabilities.getThirstData((EntityPlayer)player), null));
        PacketHandler.instance.sendTo((IMessage)message, player);
    }
}

