/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.potion;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PotionBase
extends Potion {
    protected int xOffset = 0;
    protected int yOffset = 0;
    protected boolean drawHUD = true;
    protected boolean drawInventory = true;
    protected boolean drawInventoryText = true;

    public abstract ResourceLocation getTexture();

    public PotionBase() {
        super(false, 0xFFFFFF);
    }

    public PotionBase(boolean isBadEffect, int liquidColor) {
        super(isBadEffect, liquidColor);
    }

    protected ResourceLocation formatTexture(String s) {
        return new ResourceLocation("simpledifficulty", "textures/potions/" + s + ".png");
    }

    public boolean func_76400_d() {
        return this.drawHUD;
    }

    public void removePotionCoreEffect(EntityLivingBase entity, Potion potion) {
        if (entity.func_70644_a(potion) && entity.func_70660_b(potion).func_76459_b() > 1) {
            entity.func_184589_d(potion);
            entity.func_70690_d(new PotionEffect(potion, 1));
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return this.isReadyVar(duration, amplifier, 50);
    }

    public boolean isReadyVar(int duration, int amplifier, int var) {
        int k = var >> amplifier;
        if (k > 0) {
            return duration % k == 0;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(PotionEffect effect, Gui gui, int x, int y, float z) {
        this.renderInventoryEffect(x, y, effect, Minecraft.func_71410_x());
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
        if (this.getTexture() != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTexture());
            Gui.func_146110_a((int)(x + this.xOffset + 6), (int)(y + this.yOffset + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(PotionEffect effect, Gui gui, int x, int y, float z, float alpha) {
        this.renderHUDEffect(x, y, effect, Minecraft.func_71410_x(), alpha);
    }

    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        if (this.getTexture() != null) {
            mc.func_110434_K().func_110577_a(this.getTexture());
            Gui.func_146110_a((int)(x + this.xOffset + 3), (int)(y + this.yOffset + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
        }
    }

    public boolean shouldRenderHUD(PotionEffect effect) {
        return this.drawHUD;
    }

    public boolean shouldRender(PotionEffect effect) {
        return this.drawInventory;
    }

    public boolean shouldRenderInvText(PotionEffect effect) {
        return this.drawInventoryText;
    }
}

