/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanhudbaubles.client.gui;

import com.oblivioussp.spartanhudbaubles.client.gui.AlignmentHelper;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class HudElement {
    protected boolean isEnabled = true;
    protected int width;
    protected int height;

    public HudElement(int elementWidth, int elementHeight) {
        this.width = elementWidth;
        this.height = elementHeight;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getAlignedX(AlignmentHelper.Alignment align, int offset, ScaledResolution res) {
        switch (align.getHorizontal()) {
            case LEFT: {
                return offset;
            }
            case CENTER: {
                return res.func_78326_a() / 2 - this.width / 2 + offset;
            }
            case RIGHT: {
                return res.func_78326_a() - this.width + offset;
            }
        }
        return 0;
    }

    public int getAlignedY(AlignmentHelper.Alignment align, int offset, ScaledResolution res) {
        switch (align.getVertical()) {
            case TOP: {
                return offset;
            }
            case CENTER: {
                switch (align.getHorizontal()) {
                    case CENTER: {
                        return res.func_78328_b() / 2 + 26 + offset;
                    }
                }
                return res.func_78328_b() / 2 - this.height / 2 + offset;
            }
            case BOTTOM: {
                switch (align.getHorizontal()) {
                    case CENTER: {
                        return res.func_78328_b() - this.height - 65 + offset;
                    }
                }
                return res.func_78328_b() - this.height + offset;
            }
        }
        return 0;
    }

    public abstract void render();
}

