/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import team.creative.enhancedvisuals.common.handler.VisualHandlers;

public class DamagePacket
extends CreativeCorePacket {
    public String attackerClass;
    public ItemStack stack;
    public float damage;
    public float distance;
    public boolean fire;
    public String source;

    public DamagePacket(LivingDamageEvent event) {
        this.damage = event.getAmount();
        Entity attacker = event.getSource().func_76364_f();
        this.fire = event.getSource().func_76347_k();
        if (attacker instanceof EntityLiving || attacker instanceof EntityArrow) {
            this.attackerClass = attacker.getClass().getName().toLowerCase();
            this.source = "attacker";
            if (attacker instanceof EntityLiving && ((EntityLiving)attacker).func_184614_ca() != null) {
                this.stack = ((EntityLiving)attacker).func_184614_ca();
            }
        } else {
            this.source = event.getSource().field_76373_n;
        }
    }

    public DamagePacket() {
    }

    public void writeBytes(ByteBuf buf) {
        if (this.attackerClass != null) {
            buf.writeBoolean(true);
            DamagePacket.writeString((ByteBuf)buf, (String)this.attackerClass);
        } else {
            buf.writeBoolean(false);
        }
        if (this.stack != null) {
            buf.writeBoolean(true);
            DamagePacket.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeFloat(this.damage);
        buf.writeFloat(this.distance);
        DamagePacket.writeString((ByteBuf)buf, (String)this.source);
        buf.writeBoolean(this.fire);
    }

    public void readBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.attackerClass = DamagePacket.readString((ByteBuf)buf);
        }
        if (buf.readBoolean()) {
            this.stack = DamagePacket.readItemStack((ByteBuf)buf);
        }
        this.damage = buf.readFloat();
        this.distance = buf.readFloat();
        this.source = DamagePacket.readString((ByteBuf)buf);
        this.fire = buf.readBoolean();
    }

    public void executeClient(EntityPlayer player) {
        if (VisualHandlers.DAMAGE.isEnabled(player)) {
            VisualHandlers.DAMAGE.playerDamaged(player, this);
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

