/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.aurora;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.aurora.AuroraFactory;
import org.orecruncher.dsurround.client.aurora.Panel;
import org.orecruncher.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class AuroraBand {
    protected static final float ANGLE1 = 0.19634955f;
    protected static final float ANGLE2 = MathStuff.toRadians((float)12.857142f);
    protected static final float AURORA_SPEED = 0.75f;
    public static final float AURORA_AMPLITUDE = 18.0f;
    protected final Random random;
    protected Panel[] nodes;
    protected float cycle = 0.0f;
    protected int alphaLimit = 128;
    protected int length;
    protected float nodeLength;
    protected float nodeWidth;

    public AuroraBand(Random random, AuroraFactory.AuroraGeometry geo, boolean noTaper, boolean fixedHeight) {
        this.random = random;
        this.preset(geo);
        this.generateBands(noTaper, fixedHeight);
        this.translate(0.0f);
    }

    protected AuroraBand(Panel[] nodes, AuroraBand band) {
        this.random = band.random;
        this.nodes = nodes;
        this.cycle = band.cycle;
        this.length = band.length;
        this.nodeLength = band.nodeLength;
        this.nodeWidth = band.nodeWidth;
        this.alphaLimit = band.alphaLimit;
        this.translate(0.0f);
    }

    public int getAlphaLimit() {
        return this.alphaLimit;
    }

    @Nonnull
    public Panel[] getNodeList() {
        return this.nodes;
    }

    public float getNodeWidth() {
        return this.nodeWidth;
    }

    public float getCycle() {
        return this.cycle;
    }

    public void update() {
        float f;
        this.cycle += 0.75f;
        if (f >= 360.0f) {
            this.cycle -= 360.0f;
        }
    }

    public AuroraBand copy(int offset) {
        Panel[] newNodes = new Panel[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            newNodes[i] = new Panel(this.nodes[i], offset);
        }
        return new AuroraBand(newNodes, this);
    }

    public void translate(float partialTick) {
        float c = this.cycle + 0.75f * partialTick;
        for (int i = 0; i < this.nodes.length; ++i) {
            float f = MathStuff.cos((float)MathStuff.toRadians((float)((float)(i << 3) + c)));
            Panel node = this.nodes[i];
            node.dZ = f * 18.0f;
            node.dY = f * 3.0f;
            float mZ = node.getModdedZ();
            node.tetZ = mZ + node.sinDeg90;
            node.tetZ2 = mZ + node.sinDeg270;
        }
    }

    protected void preset(AuroraFactory.AuroraGeometry geo) {
        this.length = geo.length;
        this.nodeLength = geo.nodeLength;
        this.nodeWidth = geo.nodeWidth;
        this.alphaLimit = geo.alphaLimit;
    }

    protected void generateBands(boolean noTaper, boolean fixedHeight) {
        this.nodes = this.populate(fixedHeight);
        float factor = (float)Math.PI / ((float)this.length / 4.0f);
        int lowerBound = this.length / 8 + 1;
        int upperBound = this.length * 7 / 8 - 1;
        int count = 0;
        for (int i = 0; i < this.length; ++i) {
            float width = noTaper ? this.nodeWidth : (i < lowerBound ? MathStuff.sin((float)(factor * (float)count++)) * this.nodeWidth : (i > upperBound ? MathStuff.sin((float)(factor * (float)count--)) * this.nodeWidth : this.nodeWidth));
            this.nodes[i].setWidth(width);
        }
    }

    @Nonnull
    protected Panel[] populate(boolean fixedHeight) {
        float angle;
        Panel[] nodeList = new Panel[this.length];
        int bound = this.length / 2 - 1;
        float angleTotal = 0.0f;
        for (int i = this.length / 8 / 2 - 1; i >= 0; --i) {
            angle = (this.random.nextFloat() - 0.5f) * 8.0f;
            if (MathStuff.abs((float)(angleTotal += angle)) > 180.0f) {
                angle = -angle;
                angleTotal += angle;
            }
            for (int k = 7; k >= 0; --k) {
                int idx = i * 8 + k;
                if (idx == bound) {
                    float amplitude = fixedHeight ? 18.0f : 7.0f + this.random.nextFloat();
                    nodeList[idx] = new Panel(0.0f, amplitude, 0.0f, angle);
                    continue;
                }
                float y = fixedHeight ? 18.0f : (i == 0 ? MathStuff.sin((float)(0.19634955f * (float)k)) * 7.0f + this.random.nextFloat() / 2.0f : 10.0f + this.random.nextFloat() * 5.0f);
                Panel node = nodeList[idx + 1];
                float subAngle = node.angle + angle;
                float subAngleRads = MathStuff.toRadians((float)subAngle);
                float z = node.posZ - MathStuff.sin((float)subAngleRads) * this.nodeLength;
                float x = node.posX - MathStuff.cos((float)subAngleRads) * this.nodeLength;
                nodeList[idx] = new Panel(x, y, z, subAngle);
            }
        }
        angleTotal = 0.0f;
        for (int j = this.length / 8 / 2; j < this.length / 8; ++j) {
            angle = (this.random.nextFloat() - 0.5f) * 8.0f;
            if (MathStuff.abs((float)(angleTotal += angle)) > 180.0f) {
                angle = -angle;
                angleTotal += angle;
            }
            for (int h = 0; h < 8; ++h) {
                float y = fixedHeight ? 18.0f : (j == this.length / 8 - 1 ? MathStuff.cos((float)(ANGLE2 * (float)h)) * 7.0f + this.random.nextFloat() / 2.0f : 10.0f + this.random.nextFloat() * 5.0f);
                Panel node = nodeList[j * 8 + h - 1];
                float subAngle = node.angle + angle;
                float subAngleRads = MathStuff.toRadians((float)subAngle);
                float z = node.posZ + MathStuff.sin((float)subAngleRads) * this.nodeLength;
                float x = node.posX + MathStuff.cos((float)subAngleRads) * this.nodeLength;
                nodeList[j * 8 + h] = new Panel(x, y, z, subAngle);
            }
        }
        return nodeList;
    }
}

