/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.effects;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.effects.EntityEffect;
import org.orecruncher.dsurround.client.effects.EntityEffectStateBase;
import org.orecruncher.dsurround.client.effects.IEntityEffectHandlerState;
import org.orecruncher.dsurround.client.effects.IParticleHelper;
import org.orecruncher.dsurround.client.effects.ISoundHelper;
import org.orecruncher.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public class EntityEffectHandler
extends EntityEffectStateBase
implements IEntityEffectHandlerState {
    protected final ObjectArray<EntityEffect> activeEffects;
    protected boolean isAlive = true;
    protected double rangeToPlayer;

    protected EntityEffectHandler(@Nonnull Entity entity) {
        super(entity);
        this.activeEffects = null;
    }

    public EntityEffectHandler(@Nonnull Entity entity, @Nonnull IParticleHelper ph, @Nonnull ISoundHelper sh) {
        super(entity, ph, sh);
        this.activeEffects = null;
    }

    public EntityEffectHandler(@Nonnull Entity entity, @Nonnull ObjectArray<EntityEffect> effects2, @Nonnull IParticleHelper ph, @Nonnull ISoundHelper sh) {
        super(entity, ph, sh);
        this.activeEffects = effects2;
        for (EntityEffect ee : this.activeEffects) {
            ee.initialize(this);
        }
    }

    public void update() {
        Entity entity;
        if (!this.isAlive()) {
            return;
        }
        this.isAlive = this.isSubjectAlive();
        if (this.activeEffects != null && (entity = (Entity)this.subject.get()) != null) {
            EntityPlayerSP player2 = Minecraft.func_71410_x().field_71439_g;
            this.rangeToPlayer = entity.func_70068_e((Entity)player2);
            for (int i = 0; i < this.activeEffects.size(); ++i) {
                EntityEffect e = (EntityEffect)this.activeEffects.get(i);
                if (!this.isAlive && !e.receiveLastCall()) continue;
                e.update(entity);
            }
        }
    }

    public boolean isDummy() {
        return false;
    }

    @Nonnull
    public List<String> getAttachedEffects() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.activeEffects.size() == 0) {
            result.add("No effects");
        } else {
            for (EntityEffect e : this.activeEffects) {
                result.add(e.toString());
            }
        }
        return result;
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    public static class Dummy
    extends EntityEffectHandler {
        public Dummy(@Nonnull Entity entity) {
            super(entity);
        }

        @Override
        public void update() {
        }

        @Override
        public boolean isDummy() {
            return true;
        }

        @Override
        @Nonnull
        public List<String> getAttachedEffects() {
            return ImmutableList.of((Object)"Dummy EffectHandler");
        }
    }
}

