/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx.particle;

import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.particle.ParticleBase;
import org.orecruncher.lib.Color;
import org.orecruncher.lib.gfx.OpenGlState;

@SideOnly(value=Side.CLIENT)
public class ParticleTextPopOff
extends ParticleBase {
    protected static final float GRAVITY = 0.8f;
    protected static final float SIZE = 3.0f;
    protected static final int LIFESPAN = 12;
    protected static final double BOUNCE_STRENGTH = 1.5;
    protected static final int SHADOW_COLOR = Color.BLACK.rgbWithAlpha(1.0f);
    protected int renderColor = Color.WHITE.rgbWithAlpha(1.0f);
    protected boolean grow = true;
    protected String text;
    protected float drawX;
    protected float drawY;

    public ParticleTextPopOff(World world, String text, Color color, double x, double y, double z) {
        this(world, text, color, x, y, z, 0.001, 0.07500000000000001, 0.001);
    }

    public ParticleTextPopOff(World world, String text, Color color, double x, double y, double z, double dX, double dY, double dZ) {
        super(world, x, y, z, dX, dY, dZ);
        this.renderColor = color.rgbWithAlpha(1.0f);
        this.field_187129_i = dX;
        this.field_187130_j = dY;
        this.field_187131_k = dZ;
        float dist = MathHelper.func_76133_a((double)(this.field_187129_i * this.field_187129_i + this.field_187130_j * this.field_187130_j + this.field_187131_k * this.field_187131_k));
        this.field_187129_i = this.field_187129_i / (double)dist * 0.12;
        this.field_187130_j = this.field_187130_j / (double)dist * 0.12;
        this.field_187131_k = this.field_187131_k / (double)dist * 0.12;
        this.field_70548_b = 1.5f;
        this.field_70549_c = 1.5f;
        this.field_70545_g = 0.8f;
        this.field_70544_f = 3.0f;
        this.field_70547_e = 12;
        this.setText(text);
    }

    public ParticleTextPopOff setText(@Nonnull String text) {
        this.text = text;
        this.drawX = -MathHelper.func_76141_d((float)((float)this.font.func_78256_a(this.text) / 2.0f)) + 1;
        this.drawY = -MathHelper.func_76141_d((float)((float)this.font.field_78288_b / 2.0f)) + 1;
        return this;
    }

    public ParticleTextPopOff setColor(@Nonnull Color color) {
        this.renderColor = color.rgbWithAlpha(1.0f);
        return this;
    }

    public void func_180434_a(@Nonnull BufferBuilder worldRendererIn, @Nonnull Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float pitch = this.manager.field_78732_j * (float)(this.isThirdPersonView() ? -1 : 1);
        float yaw = -this.manager.field_78735_i;
        float locX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - this.interpX());
        float locY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - this.interpY());
        float locZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - this.interpZ());
        OpenGlState glState = OpenGlState.push();
        GlStateManager.func_179109_b((float)locX, (float)locY, (float)locZ);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)((double)this.field_70544_f * 0.008), (double)((double)this.field_70544_f * 0.008), (double)((double)this.field_70544_f * 0.008));
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.003662109f);
        this.font.func_175065_a(this.text, this.drawX, this.drawY, SHADOW_COLOR, false);
        GlStateManager.func_179109_b((float)-0.3f, (float)-0.3f, (float)-0.001f);
        this.font.func_175065_a(this.text, this.drawX, this.drawY, this.renderColor, false);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)OpenGlHelper.lastBrightnessX, (float)OpenGlHelper.lastBrightnessY);
        OpenGlState.pop((OpenGlState)glState);
        if (this.grow) {
            this.field_70544_f *= 1.08f;
            if ((double)this.field_70544_f > 9.0) {
                this.grow = false;
            }
        } else {
            this.field_70544_f *= 0.96f;
        }
    }

    public boolean func_187111_c() {
        return true;
    }

    public int func_70537_b() {
        return 3;
    }
}

