/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.acoustics;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.registry.acoustics.EventType;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.acoustics.IOptions;
import org.orecruncher.dsurround.registry.acoustics.ISoundPlayer;

@SideOnly(value=Side.CLIENT)
public class SimpleAcoustic
implements IAcoustic {
    protected SoundEvent sound;
    protected float volMin = 1.0f;
    protected float volMax = 1.0f;
    protected float pitchMin = 1.0f;
    protected float pitchMax = 1.0f;
    protected IOptions outputOptions;

    public SimpleAcoustic() {
    }

    public SimpleAcoustic(@Nonnull SoundEvent evt) {
        this.sound = evt;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.sound != null ? this.sound.func_187503_a().toString() : "<UNKNOWN>";
    }

    @Override
    public void playSound(@Nonnull ISoundPlayer player2, @Nonnull Vec3d location, @Nullable EventType event, @Nullable IOptions inputOptions) {
        if (this.sound == null) {
            return;
        }
        float volume = this.generateVolume(player2.getRNG());
        float pitch = this.generatePitch(player2.getRNG());
        if (inputOptions != null) {
            if (inputOptions.getGlidingVolume() > 0.0f) {
                volume = this.volMin + (this.volMax - this.volMin) * inputOptions.getGlidingVolume();
            }
            if (inputOptions.getGlidingPitch() > 0.0f) {
                pitch = this.pitchMin + (this.pitchMax - this.pitchMin) * inputOptions.getGlidingPitch();
            }
            volume *= inputOptions.getVolumeScale();
            pitch *= inputOptions.getPitchScale();
        }
        player2.playSound(location, this.sound, volume, pitch, this.outputOptions);
    }

    private float generateVolume(@Nonnull Random rng) {
        return this.randAB(rng, this.volMin, this.volMax);
    }

    private float generatePitch(@Nonnull Random rng) {
        return this.randAB(rng, this.pitchMin, this.pitchMax);
    }

    private float randAB(@Nonnull Random rng, float a, float b) {
        if (a >= b) {
            return a;
        }
        return a + rng.nextFloat() * (b - a);
    }

    public void setSound(@Nullable SoundEvent sound2) {
        this.sound = sound2;
    }

    public void setVolMin(float volMin) {
        this.volMin = volMin;
    }

    public void setVolMax(float volMax) {
        this.volMax = volMax;
    }

    public void setPitchMin(float pitchMin) {
        this.pitchMin = pitchMin;
    }

    public void setPitchMax(float pitchMax) {
        this.pitchMax = pitchMax;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append('[');
        builder.append("vMin:").append(this.volMin).append(',');
        builder.append("vMax:").append(this.volMax).append(',');
        builder.append("pMin:").append(this.pitchMax).append(',');
        builder.append("pMax:").append(this.pitchMax);
        builder.append(']');
        return builder.toString();
    }
}

