/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.item;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lain.mods.cos.api.CosArmorAPI;
import lain.mods.cos.api.inventory.CAStacksBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.client.sound.Sounds;
import org.orecruncher.dsurround.lib.compat.ModEnvironment;
import org.orecruncher.dsurround.registry.RegistryManager;

@SideOnly(value=Side.CLIENT)
public enum ItemClass {
    EMPTY(null),
    NONE(null, null, Sounds.UTILITY_EQUIP, false),
    LEATHER(Sounds.LEATHER_ARMOR_EQUIP, true),
    CHAIN(Sounds.CHAIN_ARMOR_EQUIP, true),
    CRYSTAL(Sounds.CRYSTAL_ARMOR_EQUIP, true),
    PLATE(Sounds.PLATE_ARMOR_EQUIP, true),
    SHIELD(Sounds.TOOL_SWING, Sounds.SHIELD_USE, Sounds.SHIELD_EQUIP, false),
    SWORD(Sounds.SWORD_SWING, null, ModOptions.sound.swordEquipAsTool ? Sounds.TOOL_EQUIP : Sounds.SWORD_EQUIP, false),
    AXE(Sounds.AXE_SWING, null, Sounds.AXE_EQUIP, false),
    BOW(Sounds.TOOL_SWING, Sounds.BOW_PULL, Sounds.BOW_EQUIP, false),
    TOOL(Sounds.TOOL_SWING, null, Sounds.TOOL_EQUIP, false),
    FOOD(null, null, Sounds.FOOD_EQUIP, false),
    BOOK(Sounds.BOOK_EQUIP, Sounds.BOOK_EQUIP, Sounds.BOOK_EQUIP, false),
    POTION(Sounds.POTION_EQUIP, Sounds.POTION_EQUIP, Sounds.POTION_EQUIP, false);

    private final SoundEffect swing;
    private final SoundEffect use;
    private final SoundEffect equip;
    private final boolean isArmor;

    private ItemClass(SoundEffect sound2) {
        this(sound2, sound2, sound2, false);
    }

    private ItemClass(SoundEffect sound2, boolean isArmor) {
        this(sound2, sound2, sound2, isArmor);
    }

    private ItemClass(@Nullable SoundEffect swing, SoundEffect use, SoundEffect equip, boolean isArmor) {
        this.swing = swing;
        this.use = use;
        this.equip = equip;
        this.isArmor = isArmor;
    }

    @Nullable
    SoundEffect getSwingSound() {
        return this.swing;
    }

    @Nullable
    SoundEffect getUseSound() {
        return this.use;
    }

    @Nullable
    SoundEffect getEquipSound() {
        return this.equip;
    }

    public boolean isArmor() {
        return this.isArmor;
    }

    @Nonnull
    private static ItemStack resolveSlot(@Nonnull EntityLivingBase e, @Nonnull EntityEquipmentSlot slot) {
        ItemStack stack;
        CAStacksBase slots;
        if (ModEnvironment.CosmeticArmorReworked.isLoaded() && (slots = CosArmorAPI.getCAStacksClient((UUID)e.getPersistentID())) != null && !(stack = slots.getStackInSlot(slot.func_188454_b())).func_190926_b()) {
            return stack;
        }
        return e.func_184582_a(slot);
    }

    public static ItemStack effectiveArmorStack(@Nonnull EntityLivingBase entity) {
        ItemClass legsic;
        ItemStack chest = ItemClass.resolveSlot(entity, EntityEquipmentSlot.CHEST);
        ItemStack legs = ItemClass.resolveSlot(entity, EntityEquipmentSlot.LEGS);
        ItemClass chestic = RegistryManager.ITEMS.getItemClass(chest).getItemClass();
        return chestic.compareTo(legsic = RegistryManager.ITEMS.getItemClass(legs).getItemClass()) > 0 ? chest.func_77946_l() : legs.func_77946_l();
    }

    public static ItemStack footArmorStack(@Nonnull EntityLivingBase entity) {
        return ItemClass.resolveSlot(entity, EntityEquipmentSlot.FEET);
    }
}

