/*
 * Decompiled with CFR 0.152.
 */
package bqtweaker.client.gui;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IFieldFilter;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.controls.io.ValueFuncIO;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelHBarFill;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.resources.colors.GuiColorPulse;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.GuiColorTransition;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.party.GuiPartyManage;
import betterquesting.core.BetterQuesting;
import betterquesting.network.handlers.NetPartyAction;
import betterquesting.questing.party.PartyInvitations;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.LifeDatabase;
import bqtweaker.client.gui.panels.PanelPlayerPortraitOverride;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.input.Keyboard;

public class GuiPartyCreateOverride
extends GuiScreenCanvas
implements IPEventListener,
INeedsRefresh {
    private PanelTextField<String> flName;
    private CanvasScrolling invitePanel;
    private PanelVScrollBar inviteScroll;
    private UUID playerID;

    public GuiPartyCreateOverride(GuiScreen parent) {
        super(parent);
    }

    public void refreshGui() {
        DBEntry curParty = PartyManager.INSTANCE.getParty(this.playerID);
        if (curParty != null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiPartyManage(this.parent));
            return;
        }
        this.refreshInvites();
    }

    public void initPanel() {
        super.initPanel();
        this.playerID = QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g);
        DBEntry curParty = PartyManager.INSTANCE.getParty(this.playerID);
        if (curParty != null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiPartyManage(this.parent));
            return;
        }
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel((IGuiPanel)cvBackground);
        cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate((String)"gui.back", (Object[])new Object[0])));
        PanelTextBox txTitle = new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate((String)"betterquesting.title.party_none", (Object[])new Object[0])).setAlignment(1);
        txTitle.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel((IGuiPanel)txTitle);
        CanvasEmpty cvLeftHalf = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(16, 32, 8, 32), 0));
        cvBackground.addPanel((IGuiPanel)cvLeftHalf);
        PanelPlayerPortraitOverride pnPortrait = new PanelPlayerPortraitOverride((IGuiRect)new GuiTransform(GuiAlign.TOP_CENTER, -32, 0, 64, 64, 0), (AbstractClientPlayer)this.field_146297_k.field_71439_g).setDepth(-16.0f);
        cvLeftHalf.addPanel((IGuiPanel)pnPortrait);
        cvLeftHalf.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.TOP_CENTER, 16, 48, 24, 24, 0), (IGuiTexture)new ItemTexture(new BigItemStack(BetterQuesting.extraLife, LifeDatabase.INSTANCE.getLives(QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g))), true, true).setDepth(32.0f)));
        PanelTextBox txName = new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(16, -44, 16, 28), 0), QuestTranslation.translate((String)"betterquesting.gui.name", (Object[])new Object[0]));
        txName.setColor(PresetColor.TEXT_HEADER.getColor());
        cvLeftHalf.addPanel((IGuiPanel)txName);
        this.flName = new PanelTextField((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(16, -32, 16, 16), 0), "New Party", (IFieldFilter)FieldFilterString.INSTANCE);
        cvLeftHalf.addPanel(this.flName);
        PanelButton btnCreate = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(16, -16, 16, 0), 0), 1, QuestTranslation.translate((String)"betterquesting.btn.party_new", (Object[])new Object[0]));
        cvLeftHalf.addPanel((IGuiPanel)btnCreate);
        CanvasEmpty cvRightHalf = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 32, 16, 32), 0));
        cvBackground.addPanel((IGuiPanel)cvRightHalf);
        this.invitePanel = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 16, 8, 0), 0));
        cvRightHalf.addPanel((IGuiPanel)this.invitePanel);
        this.inviteScroll = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 16, 0, 0), 0));
        cvRightHalf.addPanel((IGuiPanel)this.inviteScroll);
        this.invitePanel.setScrollDriverY((IValueIO)this.inviteScroll);
        PanelTextBox txInvite = new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -16), 0), QuestTranslation.translate((String)"betterquesting.gui.party_invites", (Object[])new Object[0])).setAlignment(1);
        txInvite.setColor(PresetColor.TEXT_HEADER.getColor());
        cvRightHalf.addPanel((IGuiPanel)txInvite);
        this.refreshInvites();
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 32, 0, 0, 0);
        ls0.setParent(cvBackground.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -32, 0, 0, 0);
        le0.setParent(cvBackground.getTransform());
        PanelLine paLine0 = new PanelLine((IGuiRect)ls0, (IGuiRect)le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel((IGuiPanel)paLine0);
    }

    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1) {
            NBTTagCompound payload = new NBTTagCompound();
            payload.func_74768_a("action", 0);
            payload.func_74778_a("name", this.flName.getRawText());
            NetPartyAction.sendAction((NBTTagCompound)payload);
        } else if (btn.getButtonID() == 2 && btn instanceof PanelButtonStorage) {
            NBTTagCompound payload = new NBTTagCompound();
            payload.func_74768_a("action", 4);
            payload.func_74768_a("partyID", ((Integer)((PanelButtonStorage)btn).getStoredValue()).intValue());
            NetPartyAction.sendAction((NBTTagCompound)payload);
        }
    }

    private void refreshInvites() {
        this.invitePanel.resetCanvas();
        int cvWidth = this.invitePanel.getTransform().getWidth();
        List invites = PartyInvitations.INSTANCE.getPartyInvites(this.playerID);
        int elSize = RenderUtils.getStringWidth((String)"...", (FontRenderer)this.field_146297_k.field_71466_p);
        for (int i = 0; i < invites.size(); ++i) {
            String pName;
            int pid = (Integer)((Map.Entry)invites.get(i)).getKey();
            if (pid < 0) continue;
            long exp = (Long)((Map.Entry)invites.get(i)).getValue();
            IParty party = (IParty)PartyManager.INSTANCE.getValue(pid);
            PanelButtonStorage btnJoin = new PanelButtonStorage((IGuiRect)new GuiRectangle(cvWidth - 50, i * 24, 50, 16, 0), 2, QuestTranslation.translate((String)"betterquesting.btn.party_join", (Object[])new Object[0]), (Object)pid);
            this.invitePanel.addPanel((IGuiPanel)btnJoin);
            String string = pName = party == null ? "Unknown (" + pid + ")" : (String)party.getProperties().getProperty(NativeProps.NAME);
            if (RenderUtils.getStringWidth((String)pName, (FontRenderer)this.field_146297_k.field_71466_p) > cvWidth - 58) {
                pName = this.field_146297_k.field_71466_p.func_78269_a(pName, cvWidth - 58 - elSize) + "...";
            }
            PanelTextBox txPartyName = new PanelTextBox((IGuiRect)new GuiRectangle(0, i * 24 + 4, cvWidth - 58, 12, 0), pName);
            txPartyName.setColor(PresetColor.TEXT_MAIN.getColor());
            this.invitePanel.addPanel((IGuiPanel)txPartyName);
            PanelHBarFill flExpiry = new PanelHBarFill((IGuiRect)new GuiRectangle(0, i * 24 + 16, cvWidth, 8));
            ValueFuncIO expFunc = new ValueFuncIO(() -> Float.valueOf((float)((double)(exp - System.currentTimeMillis()) / 300000.0)));
            flExpiry.setFillDriver((IValueIO)expFunc);
            flExpiry.setFillColor((IGuiColor)new GuiColorTransition((IGuiColor)new GuiColorStatic(-16711936), (IGuiColor)new GuiColorPulse(-65536, -4194304, 1.0, 0.0f)).setupBlending(false, 0.2f).setBlendDriver((IValueIO)expFunc));
            this.invitePanel.addPanel((IGuiPanel)flExpiry);
        }
        this.inviteScroll.setActive(this.invitePanel.getScrollBounds().getHeight() > 0);
    }
}

