/*
 * Decompiled with CFR 0.152.
 */
package bqtweaker.client.gui;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.popups.PopContextMenu;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.SimpleTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.editors.GuiQuestEditor;
import betterquesting.client.gui2.editors.GuiTaskEditor;
import betterquesting.network.handlers.NetQuestAction;
import betterquesting.questing.QuestDatabase;
import bqtweaker.client.util.MobendPatcher;
import bqtweaker.handlers.ConfigHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector4f;

public class GuiQuestOverride
extends GuiScreenCanvas
implements IPEventListener,
INeedsRefresh {
    private final int questID;
    private IQuest quest;
    private PanelButton btnDetect;
    private PanelButton btnClaim;
    private CanvasScrolling cvDesc;
    private PanelVScrollBar paDescScroll;
    private CanvasEmpty cvInner;
    private IGuiRect rectReward;
    private IGuiRect rectTask;
    private CanvasScrolling tskScroll;
    private PanelVScrollBar tskScrollBar;

    public GuiQuestOverride(GuiScreen parent, int questID) {
        super(parent);
        this.questID = questID;
    }

    public void initPanel() {
        super.initPanel();
        this.quest = (IQuest)QuestDatabase.INSTANCE.getValue(this.questID);
        if (this.quest == null) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        CanvasTextured cvBackground = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel((IGuiPanel)cvBackground);
        PanelTextBox panTxt = new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate((String)((String)this.quest.getProperty(NativeProps.NAME)), (Object[])new Object[0])).setAlignment(1);
        panTxt.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel((IGuiPanel)panTxt);
        if (((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g)) {
            cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 100, 16, 0), 0, QuestTranslation.translate((String)"gui.back", (Object[])new Object[0])));
            cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -16, 100, 16, 0), 1, QuestTranslation.translate((String)"betterquesting.btn.edit", (Object[])new Object[0])));
        } else {
            cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate((String)"gui.back", (Object[])new Object[0])));
        }
        this.cvInner = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(16, 32, 16, 24), 0));
        cvBackground.addPanel((IGuiPanel)this.cvInner);
        if (this.quest.getRewards().size() > 0) {
            this.btnClaim = new PanelButton((IGuiRect)new GuiTransform(new Vector4f(0.0f, 1.0f, 0.5f, 1.0f), new GuiPadding(16, -16, 24, 0), 0), 6, QuestTranslation.translate((String)"betterquesting.btn.claim", (Object[])new Object[0]));
            this.btnClaim.setActive(false);
            this.cvInner.addPanel((IGuiPanel)this.btnClaim);
        }
        this.rectReward = new GuiTransform(new Vector4f(0.0f, 0.5f, 0.5f, 1.0f), new GuiPadding(0, 0, 16, 16), 0);
        this.rectReward.setParent(this.cvInner.getTransform());
        this.refreshRewardDescPanel();
        this.btnDetect = new PanelButton((IGuiRect)new GuiTransform(new Vector4f(0.5f, 1.0f, 1.0f, 1.0f), new GuiPadding(24, -16, 16, 0), 0), 7, QuestTranslation.translate((String)"betterquesting.btn.detect_submit", (Object[])new Object[0]));
        this.btnDetect.setActive(false);
        this.cvInner.addPanel((IGuiPanel)this.btnDetect);
        this.rectTask = new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 0, 0, 18), 0);
        this.rectTask.setParent(this.cvInner.getTransform());
        CanvasEmpty cvTaskPopup = new CanvasEmpty(this.rectTask){

            public boolean onMouseClick(int mx, int my, int click) {
                if (click != 1) {
                    return false;
                }
                if (GuiQuestOverride.this.rectTask.getX() >= mx || GuiQuestOverride.this.rectTask.getX() + GuiQuestOverride.this.rectTask.getWidth() <= mx || GuiQuestOverride.this.rectTask.getY() >= my || GuiQuestOverride.this.rectTask.getY() + GuiQuestOverride.this.rectTask.getHeight() <= my) {
                    return false;
                }
                if (((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).canUserEdit((EntityPlayer)GuiQuestOverride.this.field_146297_k.field_71439_g)) {
                    PopContextMenu popup = new PopContextMenu(new GuiRectangle(mx, my, 64, 16), true);
                    final GuiTaskEditor editor = new GuiTaskEditor((GuiScreen)new GuiQuestOverride(GuiQuestOverride.this.parent, GuiQuestOverride.this.questID), GuiQuestOverride.this.quest);
                    Runnable action = new Runnable(){

                        @Override
                        public void run() {
                            GuiQuestOverride.this.field_146297_k.func_147108_a((GuiScreen)editor);
                        }
                    };
                    popup.addButton(QuestTranslation.translate((String)"bqtweaker.context.task", (Object[])new Object[0]), null, action);
                    GuiQuestOverride.this.openPopup((IGuiPanel)popup);
                    return true;
                }
                return false;
            }
        };
        this.cvInner.addPanel((IGuiPanel)cvTaskPopup);
        this.refreshTaskPanel();
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 0, 0, 0, 0);
        ls0.setParent(this.cvInner.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, 0, 0, 0, 0);
        le0.setParent(this.cvInner.getTransform());
        PanelLine paLine0 = new PanelLine((IGuiRect)ls0, (IGuiRect)le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        this.cvInner.addPanel((IGuiPanel)paLine0);
    }

    public void refreshGui() {
        this.refreshTaskPanel();
        this.refreshRewardDescPanel();
        this.updateButtons();
    }

    public boolean onMouseClick(int mx, int my, int click) {
        if (super.onMouseClick(mx, my, click)) {
            this.updateButtons();
            return true;
        }
        return false;
    }

    public boolean onMouseScroll(int mx, int my, int scroll) {
        if (super.onMouseScroll(mx, my, scroll)) {
            this.updateButtons();
            return true;
        }
        return false;
    }

    public boolean onKeyTyped(char c, int keycode) {
        if (super.onKeyTyped(c, keycode)) {
            this.updateButtons();
            return true;
        }
        return false;
    }

    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestEditor((GuiScreen)this, this.questID));
        } else if (btn.getButtonID() == 6) {
            NetQuestAction.requestClaim((int[])new int[]{this.questID});
        } else if (btn.getButtonID() == 7) {
            NetQuestAction.requestDetect((int[])new int[]{this.questID});
        }
    }

    private void refreshRewardDescPanel() {
        if (this.cvDesc != null) {
            this.cvInner.removePanel((IGuiPanel)this.cvDesc);
            this.cvInner.removePanel((IGuiPanel)this.paDescScroll);
        }
        this.cvDesc = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(0, 0, 16, 18), 0));
        this.cvInner.addPanel((IGuiPanel)this.cvDesc);
        String desc = QuestTranslation.translate((String)((String)this.quest.getProperty(NativeProps.DESC)), (Object[])new Object[0]);
        int panelPrevY = 0;
        int panelPrevHeight = 0;
        if (desc.contains("{Embed}")) {
            String[] descSplit;
            for (String split : descSplit = desc.split("\\{Embed\\}")) {
                if (split.startsWith("TypeImage") || split.startsWith("TypeLink")) {
                    try {
                        String[] embedEntry = split.split(";");
                        int width = Math.min(this.cvDesc.getTransform().getWidth(), Integer.parseInt(embedEntry[2]));
                        int height = Integer.parseInt(embedEntry[3]);
                        if (embedEntry[0].contentEquals("TypeImage")) {
                            SimpleTexture embedImage = new SimpleTexture(new ResourceLocation(embedEntry[1]), (IGuiRect)new GuiRectangle(0, 0, Integer.parseInt(embedEntry[4]), Integer.parseInt(embedEntry[5])));
                            this.cvDesc.addCulledPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle((this.cvDesc.getTransform().getWidth() - width) / 2, panelPrevY + panelPrevHeight + 8, width, height), (IGuiTexture)embedImage), false);
                        } else if (embedEntry[0].contentEquals("TypeLink")) {
                            PanelButton btnLink = new PanelButton((IGuiRect)new GuiRectangle((this.cvDesc.getTransform().getWidth() - width) / 2, panelPrevY + panelPrevHeight + 8, width, height), 69, embedEntry[4]);
                            btnLink.setClickAction(b -> {
                                TextComponentString component = new TextComponentString(embedEntry[1]);
                                component.func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, embedEntry[1])));
                                this.func_175276_a((ITextComponent)component);
                            });
                            btnLink.setTextAlignment(1);
                            this.cvDesc.addCulledPanel((IGuiPanel)btnLink, false);
                        }
                        panelPrevY = panelPrevY + panelPrevHeight + 8;
                        panelPrevHeight = height;
                    }
                    catch (Exception embedEntry) {}
                    continue;
                }
                PanelTextBox paDesc = new PanelTextBox((IGuiRect)new GuiRectangle(0, panelPrevY + panelPrevHeight + 12, this.cvDesc.getTransform().getWidth(), 0), split, true);
                paDesc.setColor(PresetColor.TEXT_MAIN.getColor());
                this.cvDesc.addCulledPanel((IGuiPanel)paDesc, false);
                panelPrevY = panelPrevY + panelPrevHeight + 12;
                panelPrevHeight = paDesc.getTransform().getHeight();
            }
            panelPrevY += 32;
        } else {
            PanelTextBox paDesc = new PanelTextBox((IGuiRect)new GuiRectangle(0, 0, this.cvDesc.getTransform().getWidth(), 0), desc, true);
            paDesc.setColor(PresetColor.TEXT_MAIN.getColor());
            this.cvDesc.addCulledPanel((IGuiPanel)paDesc, false);
            panelPrevY = 32;
            panelPrevHeight = paDesc.getTransform().getHeight() + 8;
        }
        this.paDescScroll = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.quickAnchor((ReadableVector4f)GuiAlign.TOP_CENTER, (ReadableVector4f)GuiAlign.BOTTOM_CENTER), new GuiPadding(-16, 0, 8, 18), 0));
        this.cvInner.addPanel((IGuiPanel)this.paDescScroll);
        this.cvDesc.setScrollDriverY((IValueIO)this.paDescScroll);
        this.paDescScroll.setEnabled(this.cvDesc.getScrollBounds().getHeight() > 0);
        if (this.quest.getRewards().size() <= 0) {
            this.updateButtons();
            return;
        }
        for (int index = 0; index < this.quest.getRewards().size(); ++index) {
            IReward rew = (IReward)((DBEntry)this.quest.getRewards().getEntries().get(index)).getValue();
            PanelTextBox rwdTitle = new PanelTextBox((IGuiRect)new GuiRectangle(0, panelPrevY + panelPrevHeight, this.cvDesc.getTransform().getWidth(), 16, 0), QuestTranslation.translate((String)rew.getUnlocalisedName(), (Object[])new Object[0])).setColor(PresetColor.TEXT_HEADER.getColor()).setAlignment(1);
            IGuiPanel pnReward = rew.getRewardGui((IGuiRect)new GuiRectangle(0, panelPrevY + panelPrevHeight + 16, this.cvDesc.getTransform().getWidth(), 32, 0), new DBEntry(this.questID, (Object)this.quest));
            this.cvDesc.addCulledPanel((IGuiPanel)rwdTitle, false);
            this.cvDesc.addCulledPanel(pnReward, false);
            int height = this.rectReward.getHeight() - 32;
            CanvasEmpty pnRewardCanvas = (CanvasEmpty)pnReward;
            for (IGuiPanel pnl : pnRewardCanvas.getChildren()) {
                if (!pnl.getClass().isAssignableFrom(CanvasScrolling.class)) continue;
                CanvasScrolling pnlScrolling = (CanvasScrolling)pnl;
                height = pnlScrolling.getScrollBounds().getHeight() + 32;
            }
            IGuiPanel pnRewardReplacement = rew.getRewardGui((IGuiRect)new GuiRectangle(0, panelPrevY + panelPrevHeight + 16, this.rectReward.getWidth(), height, 0), new DBEntry(this.questID, (Object)this.quest));
            this.cvDesc.removePanel(pnReward);
            this.cvDesc.addCulledPanel(pnRewardReplacement, false);
            CanvasEmpty pnRewardReplacementCanvas = (CanvasEmpty)pnRewardReplacement;
            for (IGuiPanel pnlRepl : pnRewardReplacementCanvas.getChildren()) {
                if (!pnlRepl.getClass().isAssignableFrom(PanelVScrollBar.class)) continue;
                pnRewardReplacementCanvas.removePanel(pnlRepl);
            }
            panelPrevY = panelPrevY + panelPrevHeight + 16;
            panelPrevHeight = height + 8;
        }
        this.paDescScroll.setEnabled(this.cvDesc.getScrollBounds().getHeight() > 0);
        this.updateButtons();
    }

    private void refreshTaskPanel() {
        if (this.tskScroll != null) {
            this.cvInner.removePanel((IGuiPanel)this.tskScroll);
            this.cvInner.removePanel((IGuiPanel)this.tskScrollBar);
        }
        if (this.quest.getTasks().size() <= 0) {
            this.updateButtons();
            return;
        }
        this.tskScroll = new CanvasScrolling(this.rectTask);
        this.cvInner.addPanel((IGuiPanel)this.tskScroll);
        this.tskScrollBar = new PanelVScrollBar((IGuiRect)new GuiRectangle(this.cvInner.getTransform().getWidth() - 8, 0, 8, this.rectTask.getHeight(), 0));
        this.cvInner.addPanel((IGuiPanel)this.tskScrollBar);
        this.tskScroll.setScrollDriverY((IValueIO)this.tskScrollBar);
        int panelPrevY = 0;
        int panelPrevHeight = 0;
        for (int index = 0; index < this.quest.getTasks().size(); ++index) {
            ITask tsk = (ITask)((DBEntry)this.quest.getTasks().getEntries().get(index)).getValue();
            PanelTextBox tskTitle = new PanelTextBox((IGuiRect)new GuiRectangle(0, panelPrevY + panelPrevHeight, this.rectTask.getWidth(), 16, 0), QuestTranslation.translate((String)tsk.getUnlocalisedName(), (Object[])new Object[0])).setColor(PresetColor.TEXT_HEADER.getColor()).setAlignment(1);
            IGuiPanel pnTask = tsk.getTaskGui((IGuiRect)new GuiRectangle(0, panelPrevY + panelPrevHeight + 16, this.rectTask.getWidth(), 32, 0), new DBEntry(this.questID, (Object)this.quest));
            this.tskScroll.addCulledPanel((IGuiPanel)tskTitle, false);
            this.tskScroll.addCulledPanel(pnTask, false);
            int height = this.rectTask.getHeight() - 16;
            if (pnTask instanceof CanvasEmpty) {
                CanvasEmpty pnTaskCanvas = (CanvasEmpty)pnTask;
                for (IGuiPanel pnl : pnTaskCanvas.getChildren()) {
                    if (!pnl.getClass().isAssignableFrom(CanvasScrolling.class)) continue;
                    CanvasScrolling pnlScrolling = (CanvasScrolling)pnl;
                    height = pnlScrolling.getScrollBounds().getHeight() + 32;
                }
            }
            IGuiPanel pnTaskReplacement = tsk.getTaskGui((IGuiRect)new GuiRectangle(0, panelPrevY + panelPrevHeight + 16, this.rectTask.getWidth(), height, 0), new DBEntry(this.questID, (Object)this.quest));
            this.tskScroll.removePanel(pnTask);
            if (pnTaskReplacement.getClass().getName().contentEquals("bq_standard.client.gui.tasks.PanelTaskHunt") && Loader.isModLoaded((String)"mobends") && ConfigHandler.client.bqMobendPatch) {
                pnTaskReplacement = MobendPatcher.patchPanel(pnTaskReplacement);
            }
            this.tskScroll.addCulledPanel(pnTaskReplacement, false);
            if (pnTaskReplacement instanceof CanvasEmpty) {
                CanvasEmpty pnTaskReplacementCanvas = (CanvasEmpty)pnTaskReplacement;
                for (IGuiPanel pnlRepl : pnTaskReplacementCanvas.getChildren()) {
                    if (!pnlRepl.getClass().isAssignableFrom(PanelVScrollBar.class)) continue;
                    pnTaskReplacementCanvas.removePanel(pnlRepl);
                }
            }
            panelPrevY = panelPrevY + panelPrevHeight + 16;
            panelPrevHeight = height + 8;
        }
        this.tskScrollBar.setEnabled(this.tskScroll.getScrollBounds().getHeight() > 0);
        this.updateButtons();
    }

    private void updateButtons() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.btnClaim != null) {
            this.btnClaim.setActive(this.quest.getRewards().size() > 0 && this.quest.canClaim((EntityPlayer)mc.field_71439_g));
        }
        if (this.btnDetect != null) {
            this.btnDetect.setActive(this.quest.canSubmit((EntityPlayer)mc.field_71439_g));
        }
    }
}

