/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type.casting;

import java.lang.reflect.Method;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import stanhebben.zenscript.compiler.EnvironmentMethod;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.compiler.ZenClassWriter;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeFunction;
import stanhebben.zenscript.type.ZenTypeFunctionCallable;
import stanhebben.zenscript.type.casting.ICastingRule;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenTypeUtil;

public class CastingRuleMatchedFunction
implements ICastingRule {
    private final ZenTypeFunction fromType;
    private final ZenType toType;
    private final ICastingRule returnCastingRule;
    private final ICastingRule[] argumentCastingRules;

    public CastingRuleMatchedFunction(ZenTypeFunction fromType, ZenType toType, ICastingRule returnCastingRule, ICastingRule[] argumentCastingRules) {
        this.fromType = fromType;
        this.toType = toType;
        this.returnCastingRule = returnCastingRule;
        this.argumentCastingRules = argumentCastingRules;
    }

    @Override
    public void compile(IEnvironmentMethod outerEnvironment) {
        Class aClass = this.toType.toJavaClass();
        Method method = ZenTypeUtil.findFunctionalInterfaceMethod(aClass);
        if (method == null) {
            outerEnvironment.error("Internal error: Cannot convert from " + this.fromType + " to " + this.toType + " because latter is not a functional interface!");
            return;
        }
        String className = outerEnvironment.makeClassNameWithMiddleName("generated_bridge_class");
        ZenClassWriter classWriter = new ZenClassWriter(2);
        classWriter.visit(50, 1, className, null, "java/lang/Object", new String[]{Type.getInternalName((Class)aClass)});
        classWriter.visitSource("generated_classfile", null);
        classWriter.visitField(18, "wrappedFun", this.fromType.getSignature(), null, null).visitEnd();
        MethodOutput bridgeOutput = new MethodOutput((ClassVisitor)classWriter, 1, "<init>", "(" + this.fromType.getSignature() + ")V", null, null);
        bridgeOutput.start();
        bridgeOutput.loadObject(0);
        bridgeOutput.invokeSpecial("java/lang/Object", "<init>", "()V");
        bridgeOutput.loadObject(0);
        bridgeOutput.loadObject(1);
        bridgeOutput.putField(className, "wrappedFun", this.fromType.getSignature());
        bridgeOutput.ret();
        bridgeOutput.end();
        MethodOutput output = new MethodOutput((ClassVisitor)classWriter, 1, method.getName(), Type.getMethodDescriptor((Method)method), null, null);
        EnvironmentMethod environment = new EnvironmentMethod(output, outerEnvironment);
        output.start();
        output.loadObject(0);
        output.getField(className, "wrappedFun", this.fromType.getSignature());
        int i = 0;
        for (Class<?> parameterType : method.getParameterTypes()) {
            output.load(Type.getType(parameterType), i + 1);
            ICastingRule argumentCastingRule = this.argumentCastingRules[i];
            if (argumentCastingRule != null) {
                argumentCastingRule.compile(environment);
            }
            ++i;
        }
        output.invokeInterface(Type.getType((String)this.fromType.getSignature()).getInternalName(), "accept", ((ZenTypeFunctionCallable)this.fromType).getDescriptor());
        if (this.returnCastingRule != null) {
            this.returnCastingRule.compile(environment);
        }
        if (method.getReturnType() != Void.TYPE) {
            output.returnType(Type.getType(method.getReturnType()));
        }
        output.ret();
        output.end();
        classWriter.visitEnd();
        outerEnvironment.putClass(className, classWriter.toByteArray());
        output = outerEnvironment.getOutput();
        output.newObject(className);
        output.dupX1();
        output.swap();
        output.invokeSpecial(className, "<init>", "(" + this.fromType.getSignature() + ")V");
    }

    @Override
    public ZenType getInputType() {
        return this.fromType;
    }

    @Override
    public ZenType getResultingType() {
        return this.toType;
    }
}

