/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Config(modid="loottweaker")
@Mod.EventBusSubscriber(modid="loottweaker")
public class LTConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"LootTweaker");
    @Config.LangKey(value="loottweaker.config.warnings.category")
    public static Warnings warnings = new Warnings();
    @Config.LangKey(value="loottweaker.config.workarounds.category")
    public static Workarounds workarounds = new Workarounds();
    @Config.Comment(value={"Do not touch!"})
    @Config.LangKey(value="loottweaker.config.lastCfgVersion")
    public static String lastCfgVersion = "0.3.1";

    public static void onLoad() {
        if (!lastCfgVersion.equals("0.3.1")) {
            lastCfgVersion = "0.3.1";
            LTConfig.warnings.deprecation = true;
        }
        LTConfig.forceInitClasses();
        ConfigManager.sync((String)"loottweaker", (Config.Type)Config.Type.INSTANCE);
    }

    @SubscribeEvent
    public static void syncConfig(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equals("loottweaker")) {
            LTConfig.forceInitClasses();
            ConfigManager.sync((String)"loottweaker", (Config.Type)Config.Type.INSTANCE);
        }
    }

    private static void forceInitClasses() {
        for (String className : LTConfig.workarounds.forceInitClasses) {
            try {
                Class.forName(className);
                LOGGER.info("{} initialisation ensured", (Object)className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Could not ensure initialisation of {}", (Object)className, (Object)e);
            }
        }
    }

    public static class Workarounds {
        @Config.Comment(value={"Classes to force initialise during pre-init. Use only if directed to by LootTweaker author."})
        @Config.LangKey(value="loottweaker.config.workarounds.forceInitClasses")
        public String[] forceInitClasses = new String[0];
    }

    public static class Warnings {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Warns about deprecated methods on world load. Resets if the version of LootTweaker is changed."})
        @Config.LangKey(value="loottweaker.config.warnings.deprecation")
        public boolean deprecation = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Warns when newTable() is passed a table id that implictly or explicitly uses the 'minecraft' namescape."})
        @Config.LangKey(value="loottweaker.config.warnings.newTableMinecraftNamespace")
        public boolean newTableMinecraftNamespace = true;
    }
}

