/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.kotlin;

import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=5, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\r*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0004\u001a\u0012\u0010\u0015\u001a\u00020\u0013*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0007\u001a\n\u0010\u0016\u001a\u00020\u0013*\u00020\u0002\u001a\n\u0010\u0017\u001a\u00020\u0013*\u00020\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u0013*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\t\u001a\u0012\u0010\u0019\u001a\u00020\u0013*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u000b\u001a\u0012\u0010\u001a\u001a\u00020\u0013*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\r\u001a\u0012\u0010\u001b\u001a\u00020\u0013*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u000f\u001a\u0012\u0010\u001c\u001a\u00020\u0013*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0011\u00a8\u0006\u001d"}, d2={"hasNullSignature", "", "Lio/netty/buffer/ByteBuf;", "readBooleanArray", "", "tryReadInto", "readFluidStack", "Lnet/minecraftforge/fluids/FluidStack;", "readStack", "Lnet/minecraft/item/ItemStack;", "readString", "", "readTag", "Lnet/minecraft/nbt/NBTTagCompound;", "readVarInt", "", "readVarLong", "", "writeBooleanArray", "", "value", "writeFluidStack", "writeNonnullSignature", "writeNullSignature", "writeStack", "writeString", "writeTag", "writeVarInt", "writeVarLong", "librarianlib-1.12.2"}, xs="com/teamwizardry/librarianlib/features/kotlin/CommonUtilMethods")
final class CommonUtilMethods__ExtByteBufKt {
    public static final void writeString(@NotNull ByteBuf $receiver, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(value, "value");
        ByteBufUtils.writeUTF8String((ByteBuf)$receiver, (String)value);
    }

    @NotNull
    public static final String readString(@NotNull ByteBuf $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        String string = ByteBufUtils.readUTF8String((ByteBuf)$receiver);
        Intrinsics.checkExpressionValueIsNotNull(string, "ByteBufUtils.readUTF8String(this)");
        return string;
    }

    public static final void writeStack(@NotNull ByteBuf $receiver, @NotNull ItemStack value) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(value, "value");
        ByteBufUtils.writeItemStack((ByteBuf)$receiver, (ItemStack)value);
    }

    @NotNull
    public static final ItemStack readStack(@NotNull ByteBuf $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        ItemStack itemStack = ByteBufUtils.readItemStack((ByteBuf)$receiver);
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "ByteBufUtils.readItemStack(this)");
        return itemStack;
    }

    public static final void writeTag(@NotNull ByteBuf $receiver, @NotNull NBTTagCompound value) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(value, "value");
        ByteBufUtils.writeTag((ByteBuf)$receiver, (NBTTagCompound)value);
    }

    @NotNull
    public static final NBTTagCompound readTag(@NotNull ByteBuf $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        NBTTagCompound nBTTagCompound = ByteBufUtils.readTag((ByteBuf)$receiver);
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        return nBTTagCompound;
    }

    public static final void writeVarInt(@NotNull ByteBuf $receiver, int value) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        int input = value;
        while ((input & 0xFFFFFF80) != 0) {
            $receiver.writeByte(input & 0x7F | 0x80);
            input >>>= 7;
        }
        $receiver.writeByte(input);
    }

    public static final int readVarInt(@NotNull ByteBuf $receiver) {
        byte b0;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        int i = 0;
        int j = 0;
        do {
            b0 = $receiver.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw (Throwable)new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    public static final void writeVarLong(@NotNull ByteBuf $receiver, long value) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        long input = value;
        while ((input & 0xFFFFFFFFFFFFFF80L) != 0L) {
            $receiver.writeByte((int)(input & 0x7FL) | 0x80);
            input = value >>> 7;
        }
        $receiver.writeByte((int)value);
    }

    public static final long readVarLong(@NotNull ByteBuf $receiver) {
        byte b0;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        long i = 0L;
        int j = 0;
        do {
            b0 = $receiver.readByte();
            i |= (long)(b0 & 0x7F) << j++ * 7;
            if (j <= 10) continue;
            throw (Throwable)new RuntimeException("VarLong too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeBooleanArray(@NotNull ByteBuf $receiver, @NotNull boolean[] value) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(value, "value");
        int len = value.length;
        CommonUtilMethods.writeVarInt($receiver, len);
        byte[] toReturn = new byte[(len + 7) / 8];
        int n = 0;
        int n2 = toReturn.length;
        while (n < n2) {
            void entry;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            int n3 = 0;
            Iterable iterable = new IntRange(n3, 7);
            Iterator iterator2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                if (!(entry * 8 + it < len && value[entry * 8 + it])) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                toReturn[entry] = (byte)(toReturn[entry] | 128 >> it);
            }
            ++entry;
        }
        $receiver.writeBytes(toReturn);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final boolean[] readBooleanArray(@NotNull ByteBuf $receiver, @Nullable boolean[] tryReadInto) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        int len = CommonUtilMethods.readVarInt($receiver);
        byte[] bytes = new byte[(len + 7) / 8];
        $receiver.readBytes(bytes);
        boolean[] toReturn = tryReadInto != null && tryReadInto.length == len ? tryReadInto : new boolean[len];
        int n = 0;
        int n2 = bytes.length;
        while (n < n2) {
            void entry;
            int n3 = 0;
            int n4 = 7;
            while (n3 <= n4) {
                void bit;
                int bitThing = bytes[entry] & 128 >> bit;
                if (entry * 8 + bit < len && bitThing != 0) {
                    toReturn[entry * 8 + bit] = true;
                }
                ++bit;
            }
            ++entry;
        }
        return toReturn;
    }

    @NotNull
    public static /* synthetic */ boolean[] readBooleanArray$default(ByteBuf byteBuf, boolean[] blArray, int n, Object object) {
        if ((n & 1) != 0) {
            blArray = null;
        }
        return CommonUtilMethods.readBooleanArray(byteBuf, blArray);
    }

    public static final void writeNullSignature(@NotNull ByteBuf $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        $receiver.writeBoolean(true);
    }

    public static final void writeNonnullSignature(@NotNull ByteBuf $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        $receiver.writeBoolean(false);
    }

    public static final boolean hasNullSignature(@NotNull ByteBuf $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        return $receiver.readBoolean();
    }

    public static final void writeFluidStack(@NotNull ByteBuf $receiver, @NotNull FluidStack value) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(value, "value");
        String string = FluidRegistry.getFluidName((Fluid)value.getFluid());
        Intrinsics.checkExpressionValueIsNotNull(string, "FluidRegistry.getFluidName(value.fluid)");
        CommonUtilMethods.writeString($receiver, string);
        $receiver.writeInt(value.amount);
        if (value.tag != null) {
            $receiver.writeBoolean(true);
            NBTTagCompound nBTTagCompound = value.tag;
            Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "value.tag");
            CommonUtilMethods.writeTag($receiver, nBTTagCompound);
        } else {
            $receiver.writeBoolean(false);
        }
    }

    @Nullable
    public static final FluidStack readFluidStack(@NotNull ByteBuf $receiver) {
        FluidStack fluidStack;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Fluid fluid = FluidRegistry.getFluid((String)CommonUtilMethods.readString($receiver));
        if (fluid != null) {
            int amount = $receiver.readInt();
            fluidStack = $receiver.readBoolean() ? new FluidStack(fluid, amount, CommonUtilMethods.readTag($receiver)) : new FluidStack(fluid, amount);
        } else {
            fluidStack = null;
        }
        return fluidStack;
    }
}

