/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.magicwerk.brownies.collections.BigList;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.KeyCollectionAsSet;
import org.magicwerk.brownies.collections.KeyListImpl;
import org.magicwerk.brownies.collections.exceptions.DuplicateKeyException;
import org.magicwerk.brownies.collections.exceptions.KeyException;
import org.magicwerk.brownies.collections.function.IConsumer;
import org.magicwerk.brownies.collections.function.IFunction;
import org.magicwerk.brownies.collections.function.IPredicate;
import org.magicwerk.brownies.collections.helper.BigLists;
import org.magicwerk.brownies.collections.helper.GapLists;
import org.magicwerk.brownies.collections.helper.IdentMapper;
import org.magicwerk.brownies.collections.helper.NaturalComparator;
import org.magicwerk.brownies.collections.helper.NullComparator;
import org.magicwerk.brownies.collections.helper.Option;
import org.magicwerk.brownies.collections.helper.SortedLists;

public class KeyCollectionImpl<E>
implements Collection<E>,
Serializable,
Cloneable {
    private static final boolean DEBUG_CHECK = false;
    int size;
    int maxSize;
    boolean movingWindow;
    KeyMap<E, Object>[] keyMaps;
    int orderByKey;
    boolean allowNullElem;
    IPredicate<E> constraint;
    IConsumer<E> beforeInsertTrigger;
    IConsumer<E> afterInsertTrigger;
    IConsumer<E> beforeDeleteTrigger;
    IConsumer<E> afterDeleteTrigger;
    KeyListImpl<E> keyList;

    KeyCollectionImpl() {
    }

    void initCopy(KeyCollectionImpl<E> that) {
        this.size = that.size;
        this.keyList = that.keyList;
        if (that.keyMaps != null) {
            this.keyMaps = new KeyMap[that.keyMaps.length];
            for (int i = 0; i < this.keyMaps.length; ++i) {
                if (that.keyMaps[i] == null) continue;
                this.keyMaps[i] = that.keyMaps[i].copy();
            }
        }
        this.maxSize = that.maxSize;
        this.movingWindow = that.movingWindow;
        this.allowNullElem = that.allowNullElem;
        this.constraint = that.constraint;
        this.orderByKey = that.orderByKey;
        this.beforeInsertTrigger = that.beforeInsertTrigger;
        this.afterInsertTrigger = that.afterInsertTrigger;
        this.beforeDeleteTrigger = that.beforeDeleteTrigger;
        this.afterDeleteTrigger = that.afterDeleteTrigger;
    }

    void initCrop(KeyCollectionImpl<E> that) {
        this.size = 0;
        this.keyList = that.keyList;
        if (that.keyMaps != null) {
            this.keyMaps = new KeyMap[that.keyMaps.length];
            for (int i = 0; i < this.keyMaps.length; ++i) {
                if (that.keyMaps[i] == null) continue;
                this.keyMaps[i] = that.keyMaps[i].crop();
            }
        }
        this.maxSize = that.maxSize;
        this.movingWindow = that.movingWindow;
        this.allowNullElem = that.allowNullElem;
        this.constraint = that.constraint;
        this.orderByKey = that.orderByKey;
        this.beforeInsertTrigger = that.beforeInsertTrigger;
        this.afterInsertTrigger = that.afterInsertTrigger;
        this.beforeDeleteTrigger = that.beforeDeleteTrigger;
        this.afterDeleteTrigger = that.afterDeleteTrigger;
    }

    void debugCheck() {
        if (this.keyMaps != null) {
            for (KeyMap<E, Object> keyMap : this.keyMaps) {
                if (keyMap == null) continue;
                this.doDebugCheck(keyMap);
            }
        }
    }

    private void doDebugCheck(KeyMap keyMap) {
        if (keyMap.keysMap != null) {
            int count = 0;
            if (keyMap.count) {
                for (Object val : keyMap.keysMap.values()) {
                    count += ((Integer)val).intValue();
                }
            } else {
                for (Object obj : keyMap.keysMap.values()) {
                    if (obj instanceof KeyMapList) {
                        count += ((KeyMapList)obj).size();
                        continue;
                    }
                    ++count;
                }
            }
            assert (count == this.size());
        } else if (keyMap.keysList != null) {
            assert (keyMap.keysList.size() == this.size());
            IList copy2 = keyMap.keysList.copy();
            copy2.sort(keyMap.comparator);
            assert (copy2.equals(keyMap.keysList));
        } else assert (false);
    }

    Object getKey(int keyIndex, E elem) {
        return this.keyMaps[keyIndex].getKey(elem);
    }

    public boolean isSorted() {
        return this.orderByKey != -1;
    }

    boolean isSortedByElem() {
        return this.orderByKey == 0;
    }

    Comparator getElemSortComparator() {
        Comparator comparator = this.keyMaps[this.orderByKey].comparator;
        if (comparator instanceof NaturalComparator) {
            return null;
        }
        return comparator;
    }

    boolean hasElemSet() {
        return this.keyMaps != null && this.keyMaps[0] != null;
    }

    void checkIndex(int loIndex, int hiIndex, E elem) {
        int cmp;
        KeyMap<E, Object> keyMap = this.keyMaps[this.orderByKey];
        Object key = keyMap.getKey(elem);
        IList list2 = keyMap.keysList;
        Comparator comp = keyMap.comparator;
        if (loIndex >= 0) {
            cmp = comp.compare(list2.doGet(loIndex), key);
            if (cmp == 0) {
                if (elem != null) {
                    if (!keyMap.allowDuplicates) {
                        cmp = 1;
                    }
                } else if (!keyMap.allowDuplicatesNull) {
                    cmp = 1;
                }
            }
            if (cmp > 0) {
                KeyCollectionImpl.errorInvalidIndex();
            }
        }
        if (hiIndex < list2.size()) {
            cmp = comp.compare(key, list2.doGet(hiIndex));
            if (cmp == 0) {
                if (elem != null) {
                    if (!keyMap.allowDuplicates) {
                        KeyCollectionImpl.errorDuplicateKey(key);
                    }
                } else if (!keyMap.allowDuplicatesNull) {
                    KeyCollectionImpl.errorDuplicateKey(key);
                }
            }
            if (cmp > 0) {
                KeyCollectionImpl.errorInvalidIndex();
            }
        }
    }

    void addSorted(int index, E elem) {
        this.checkIndex(index - 1, index, elem);
        this.beforeInsert(elem);
        KeyMap<E, Object> keyMap = this.keyMaps[this.orderByKey];
        Object key = keyMap.getKey(elem);
        IList list2 = keyMap.keysList;
        if (this.doAdd(elem, keyMap)) {
            ++this.size;
        }
        list2.doAdd(index, key);
        this.afterInsert(elem);
    }

    void addUnsorted(E elem) {
        this.beforeInsert(elem);
        if (this.doAdd(elem, null)) {
            ++this.size;
        }
        this.afterInsert(elem);
    }

    void setSorted(int index, E elem, E oldElem) {
        this.checkIndex(index - 1, index + 1, elem);
        KeyMap<E, Object> keyMap = this.keyMaps[this.orderByKey];
        Object key = keyMap.getKey(elem);
        IList list2 = keyMap.keysList;
        this.beforeDelete(oldElem);
        this.beforeInsert(elem);
        this.doRemove(oldElem, keyMap);
        try {
            this.doAdd(elem, keyMap);
        }
        catch (RuntimeException e) {
            this.doAdd(oldElem, keyMap);
            throw e;
        }
        list2.doSet(index, key);
        this.afterDelete(elem);
        this.afterInsert(elem);
    }

    int binarySearchSorted(E elem) {
        KeyMap<E, Object> keyMap = this.keyMaps[this.orderByKey];
        Object key = keyMap.getKey(elem);
        int index = keyMap.keysList.binarySearch(key, keyMap.comparator);
        if (index >= 0) {
            ++index;
            while (index < keyMap.keysList.size() && keyMap.comparator.compare(keyMap.keysList.get(index), key) == 0) {
                ++index;
            }
        }
        return index;
    }

    int indexOfSorted(E elem) {
        KeyMap<E, Object> keyMap = this.keyMaps[this.orderByKey];
        Object key = keyMap.getKey(elem);
        int index = keyMap.keysList.binarySearch(key, keyMap.comparator);
        return index < 0 ? -1 : index;
    }

    void checkElemAllowed(E elem) {
        if (elem == null && !this.allowNullElem) {
            KeyCollectionImpl.errorNullElement();
        }
        if (this.constraint != null && !this.constraint.test(elem)) {
            KeyCollectionImpl.errorConstraintElement();
        }
    }

    static void errorNullElement() {
        throw new KeyException("Constraint violation: null element not allowed");
    }

    static void errorConstraintElement() {
        throw new KeyException("Constraint violation: element not allowed");
    }

    static void errorNullKey() {
        throw new KeyException("Constraint violation: null key not allowed");
    }

    static void errorMaxSize() {
        throw new KeyException("Constraint violation: maximum size reached");
    }

    static void errorDuplicateKey(Object key) {
        throw new DuplicateKeyException(key);
    }

    static void errorInvalidData() {
        throw new IllegalStateException("Invalid data: call update() on change of key data");
    }

    static void errorInvalidIndex() {
        throw new IllegalStateException("Invalid index for sorted list");
    }

    static void errorInvalidateNotSupported() {
        throw new IllegalStateException("Invalidate is not support if elemCount is true");
    }

    private void beforeInsert(E elem) {
        if (this.beforeInsertTrigger != null) {
            this.beforeInsertTrigger.accept(elem);
        }
    }

    private void afterInsert(E elem) {
        if (this.afterInsertTrigger != null) {
            this.afterInsertTrigger.accept(elem);
        }
    }

    private void beforeDelete(E elem) {
        if (this.beforeDeleteTrigger != null) {
            this.beforeDeleteTrigger.accept(elem);
        }
    }

    private void afterDelete(E elem) {
        if (this.afterDeleteTrigger != null) {
            this.afterDeleteTrigger.accept(elem);
        }
    }

    @Override
    public boolean add(E elem) {
        this.checkAddElem(elem);
        this.beforeInsert(elem);
        if (this.doAdd(elem, null)) {
            ++this.size;
        }
        this.afterInsert(elem);
        return true;
    }

    @Override
    public boolean remove(Object elem) {
        return this.remove(elem, null);
    }

    void checkAddElem(E elem) {
        this.checkElemAllowed(elem);
        if (this.maxSize != 0 && this.size >= this.maxSize) {
            KeyCollectionImpl.errorMaxSize();
        }
    }

    boolean remove(Object elem, KeyMap ignore) {
        this.beforeDelete(elem);
        Option<E> removed = this.doRemove(elem, ignore);
        if (removed.hasValue() || ignore != null) {
            --this.size;
        }
        this.afterDelete(elem);
        return removed.hasValue();
    }

    protected E put(E elem) {
        return this.putByKey(0, elem);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (this.keyMaps[0] != null) {
            return this.keyMaps[0].containsKey(o);
        }
        return this.keyMaps[1].containsValue(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.keyMaps[this.orderByKey].iteratorValues(this);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            added = true;
        }
        return added;
    }

    public GapList<E> toList() {
        GapList<E> list2 = new GapList<E>(this.size());
        for (E e : this) {
            list2.add(e);
        }
        return list2;
    }

    @Override
    public Object[] toArray() {
        GapList<E> list2 = new GapList<E>(this.size());
        for (E e : this) {
            list2.add(e);
        }
        return list2.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        GapList<E> list2 = new GapList<E>(this.size());
        for (E e : this) {
            list2.add(e);
        }
        return list2.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        if (c.size() < this.size()) {
            Iterator<?> i = c.iterator();
            while (i.hasNext()) {
                if (!this.remove(i.next())) continue;
                changed = true;
            }
        } else {
            Iterator<E> i = this.iterator();
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                changed = true;
            }
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<E> i = this.iterator();
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            changed = true;
        }
        return changed;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        boolean first = true;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            if (!first) {
                buf.append(", ");
            } else {
                first = false;
            }
            buf.append(iter.next());
        }
        buf.append("]");
        return buf.toString();
    }

    Option<E> doRemove(Object elem, KeyMap ignore) {
        Option<Object> removed = Option.EMPTY();
        boolean first = true;
        if (this.keyMaps != null) {
            for (int i = 0; i < this.keyMaps.length; ++i) {
                if (this.keyMaps[i] == null || this.keyMaps[i] == ignore) continue;
                Object key = this.keyMaps[i].getKey(elem);
                Option<E> obj = this.keyMaps[i].remove(key, true, elem, this);
                if (first) {
                    if (!obj.hasValue()) {
                        return Option.EMPTY();
                    }
                    removed = obj;
                    first = false;
                    continue;
                }
                if (obj.hasValue() && obj.getValue().equals(removed.getValue())) continue;
                KeyCollectionImpl.errorInvalidData();
            }
        }
        return removed;
    }

    public KeyCollectionImpl copy() {
        try {
            KeyCollectionImpl copy2 = (KeyCollectionImpl)super.clone();
            copy2.initCopy(this);
            return copy2;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public KeyCollectionImpl crop() {
        try {
            KeyCollectionImpl copy2 = (KeyCollectionImpl)super.clone();
            copy2.initCrop(this);
            return copy2;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected Object clone() {
        return this.copy();
    }

    protected void initClone(Object that) {
    }

    public Set<E> asSet() {
        return new KeyCollectionAsSet(this, false);
    }

    @Override
    public void clear() {
        if (this.keyMaps != null) {
            for (KeyMap<E, Object> keyMap : this.keyMaps) {
                if (keyMap == null) continue;
                this.doClear(keyMap);
            }
        }
        this.size = 0;
    }

    private void doClear(KeyMap<E, ?> keyMap) {
        if (keyMap.keysMap != null) {
            keyMap.keysMap.clear();
        } else {
            keyMap.keysList.clear();
        }
    }

    boolean doAdd(E elem, KeyMap ignore) {
        Object key;
        if (this.keyMaps == null) {
            return false;
        }
        RuntimeException error = null;
        int i = 0;
        try {
            for (i = 0; i < this.keyMaps.length; ++i) {
                if (this.keyMaps[i] == null || this.keyMaps[i] == ignore) continue;
                key = this.keyMaps[i].getKey(elem);
                this.keyMaps[i].add(key, elem);
            }
        }
        catch (RuntimeException e) {
            error = e;
        }
        if (error != null) {
            --i;
            while (i >= 0) {
                if (this.keyMaps[i] != null) {
                    key = this.keyMaps[i].getKey(elem);
                    this.keyMaps[i].remove(key, true, elem, this);
                }
                --i;
            }
            if (error != null) {
                throw error;
            }
        }
        return true;
    }

    protected <K> boolean containsKey(int keyIndex, K key) {
        return this.getKeyMap(keyIndex).containsKey(key);
    }

    protected Set<?> getDistinctKeys(int keyIndex) {
        return this.getKeyMap(keyIndex).getDistinctKeys();
    }

    protected GapList<?> getAllKeys(int keyIndex) {
        IFunction mapper = this.getKeyMap((int)keyIndex).mapper;
        GapList list2 = GapList.create();
        for (E obj : this) {
            list2.add(mapper.apply(obj));
        }
        return list2;
    }

    void checkKeyMap(int keyIndex) {
        if (this.keyMaps == null || keyIndex >= this.keyMaps.length || keyIndex < 0 || this.keyMaps[keyIndex] == null) {
            throw new IllegalArgumentException("Invalid key index: " + keyIndex);
        }
    }

    void checkAsMap(int keyIndex) {
        if (this.keyMaps == null || keyIndex >= this.keyMaps.length || keyIndex <= 0 || this.keyMaps[keyIndex] == null) {
            throw new IllegalArgumentException("Invalid key index: " + keyIndex);
        }
        if (this.keyMaps[keyIndex].allowDuplicates || this.keyMaps[keyIndex].allowDuplicatesNull) {
            throw new IllegalArgumentException("Key map must not allow duplicates");
        }
    }

    void checkAsSet() {
        if (this.keyMaps == null || this.keyMaps[0] == null) {
            throw new IllegalArgumentException("No element set");
        }
        if (this.keyMaps[0].allowDuplicates || this.keyMaps[0].allowDuplicatesNull) {
            throw new IllegalArgumentException("Element set must not allow duplicates");
        }
    }

    KeyMap<E, Object> getKeyMap(int keyIndex) {
        this.checkKeyMap(keyIndex);
        return this.keyMaps[keyIndex];
    }

    protected IFunction<E, Object> getKeyMapper(int keyIndex) {
        return this.getKeyMap((int)keyIndex).mapper;
    }

    protected E getByKey(int keyIndex, Object key) {
        return this.getByKey(this.getKeyMap(keyIndex), key);
    }

    private <K> E getByKey(KeyMap<E, K> keyMap, K key) {
        if (key == null && !keyMap.allowNull) {
            return null;
        }
        if (keyMap.keysMap != null) {
            Object obj = keyMap.keysMap.get(key);
            if (obj instanceof KeyMapList) {
                GapList list2 = (GapList)obj;
                return list2.getFirst();
            }
            return (E)obj;
        }
        int index = SortedLists.binarySearchGet(keyMap.keysList, key, keyMap.comparator);
        if (index >= 0) {
            return this.keyList.doGet(index);
        }
        return null;
    }

    protected GapList<E> getAllByKey(int keyIndex, Object key) {
        return this.doGetAllByKey(this.getKeyMap(keyIndex), key);
    }

    private <K> GapList<E> doGetAllByKey(KeyMap<E, K> keyMap, K key) {
        if (key == null && !keyMap.allowNull) {
            return GapList.create();
        }
        if (keyMap.keysMap != null) {
            Object obj = keyMap.keysMap.get(key);
            if (obj == null) {
                return GapList.create();
            }
            if (obj instanceof KeyMapList) {
                GapList list2 = (GapList)obj;
                return list2.copy();
            }
            return GapList.create(keyMap.keysMap.get(key));
        }
        int index = SortedLists.binarySearchGet(keyMap.keysList, key, keyMap.comparator);
        if (index >= 0) {
            GapList<E> list3 = new GapList<E>();
            do {
                list3.add(this.keyList.doGet(index));
            } while (++index != keyMap.keysList.size() && GapList.equalsElem(keyMap.keysList.get(index), key));
            return list3;
        }
        return GapList.create();
    }

    protected int getCountByKey(int keyIndex, Object key) {
        return this.getCountByKey(this.getKeyMap(keyIndex), key);
    }

    private <K> int getCountByKey(KeyMap<E, K> keyMap, K key) {
        if (key == null && !keyMap.allowNull) {
            return 0;
        }
        if (keyMap.keysMap != null) {
            if (keyMap.count) {
                Integer val = (Integer)keyMap.keysMap.get(key);
                if (val == null) {
                    return 0;
                }
                return val;
            }
            Object obj = keyMap.keysMap.get(key);
            if (obj == null) {
                return 0;
            }
            if (obj instanceof KeyMapList) {
                GapList list2 = (GapList)obj;
                return list2.size();
            }
            return 1;
        }
        int index = SortedLists.binarySearchGet(keyMap.keysList, key, keyMap.comparator);
        if (index >= 0) {
            int count = 0;
            do {
                ++count;
            } while (++index != keyMap.keysList.size() && GapList.equalsElem(keyMap.keysList.get(index), key));
            return count;
        }
        return 0;
    }

    protected void invalidate(E elem) {
        if (this.keyMaps != null) {
            for (int i = 0; i < this.keyMaps.length; ++i) {
                Option<Object> key;
                if (this.keyMaps[i] == null) continue;
                if (i == 0 && this.keyMaps[0].count) {
                    KeyCollectionImpl.errorInvalidateNotSupported();
                }
                if (!(key = this.invalidate(this.keyMaps[i], elem)).hasValue()) continue;
                this.keyMaps[i].add(key.getValue(), elem);
            }
        }
    }

    protected void invalidateKey(int keyIndex, Object oldKey, Object newKey, E elem) {
        this.doInvalidateKey(keyIndex, oldKey, newKey, elem);
    }

    E doInvalidateKey(int keyIndex, Object oldKey, Object newKey, E elem) {
        KeyMap<E, Object> keyMap = this.getKeyMap(keyIndex);
        Option<E> removed = elem == null ? keyMap.remove(oldKey, false, null, this) : keyMap.remove(oldKey, true, elem, this);
        if (!removed.hasValue()) {
            KeyCollectionImpl.errorInvalidData();
        }
        keyMap.add(newKey, removed.getValue());
        return removed.getValue();
    }

    private Option<Object> invalidate(KeyMap keyMap, Object elem) {
        boolean allowDuplicates = keyMap.allowDuplicates;
        Object key = keyMap.getKey(elem);
        if (keyMap.keysMap != null) {
            Iterator iter = keyMap.keysMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!GapList.equalsElem(elem, entry.getValue())) continue;
                if (GapList.equalsElem(key, entry.getKey())) {
                    return Option.EMPTY();
                }
                iter.remove();
                if (allowDuplicates) continue;
                break;
            }
        } else {
            assert (keyMap.keysList != null);
            for (int i = 0; i < keyMap.keysList.size(); ++i) {
                if (!GapList.equalsElem(elem, this.keyList.doGet(i))) continue;
                if (GapList.equalsElem(key, keyMap.keysList.get(i))) {
                    return Option.EMPTY();
                }
                keyMap.keysList.remove(i);
                if (allowDuplicates) {
                    continue;
                }
                break;
            }
        }
        return new Option<Object>(key);
    }

    protected E removeByKey(int keyIndex, Object key) {
        return this.doRemoveByKey(keyIndex, key).getValueOrNull();
    }

    protected Option<E> doRemoveByKey(int keyIndex, Object key) {
        this.checkKeyMap(keyIndex);
        Option<E> removed = this.keyMaps[keyIndex].remove(key, false, null, this);
        if (removed.hasValue()) {
            E elem = removed.getValue();
            try {
                this.beforeDelete(elem);
            }
            catch (RuntimeException e) {
                this.keyMaps[keyIndex].add(key, elem);
                throw e;
            }
            for (int i = 0; i < this.keyMaps.length; ++i) {
                if (i == keyIndex || this.keyMaps[i] == null) continue;
                E value = removed.getValue();
                Object k = this.keyMaps[i].getKey(value);
                this.keyMaps[i].remove(k, true, value, this);
            }
            --this.size;
            this.afterDelete(elem);
        }
        return removed;
    }

    protected GapList<E> removeAllByKey(int keyIndex, Object key) {
        this.checkKeyMap(keyIndex);
        GapList removeds = ((KeyMap)this.keyMaps[keyIndex]).doRemoveAllByKey(key, this);
        for (int n = 0; n < removeds.size(); ++n) {
            Object elem = removeds.get(n);
            try {
                this.beforeDelete(elem);
            }
            catch (RuntimeException e) {
                int n2 = n;
                while (n2 < removeds.size()) {
                    this.keyMaps[keyIndex].add(key, removeds.get(n2));
                    ++n;
                }
                throw e;
            }
            for (int i = 0; i < this.keyMaps.length; ++i) {
                if (i == keyIndex || this.keyMaps[i] == null) continue;
                Object k = this.keyMaps[i].getKey(elem);
                ((KeyMap)this.keyMaps[i]).doRemoveAllByKey(k, this);
            }
            this.afterDelete(elem);
            --this.size;
        }
        return removeds;
    }

    protected E putByKey(int keyIndex, E elem) {
        Option<E> removed;
        if (keyIndex == 0) {
            removed = this.doRemove(elem, null);
            if (removed.hasValue()) {
                --this.size;
            }
        } else {
            Object key = this.getKey(keyIndex, elem);
            removed = this.doRemoveByKey(keyIndex, key);
        }
        if (removed.hasValue()) {
            try {
                this.beforeDelete(removed.getValue());
            }
            catch (RuntimeException e) {
                this.doAdd(removed.getValue(), null);
                throw e;
            }
        }
        try {
            this.beforeInsert(elem);
        }
        catch (RuntimeException e) {
            ++this.size;
            this.doAdd(removed.getValue(), null);
            throw e;
        }
        try {
            this.checkAddElem(elem);
            this.doAdd(elem, null);
            ++this.size;
        }
        catch (RuntimeException e) {
            ++this.size;
            this.doAdd(removed.getValue(), null);
            throw e;
        }
        if (removed.hasValue()) {
            this.afterDelete(removed.getValue());
        }
        this.afterInsert(elem);
        return removed.getValueOrNull();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection c = (Collection)o;
        if (c.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(c);
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (E obj : this) {
            if (obj == null) continue;
            h += obj.hashCode();
        }
        return h;
    }

    protected GapList<E> getAll(E elem) {
        return this.getAllByKey(0, elem);
    }

    protected int getCount(E elem) {
        return this.getCountByKey(0, elem);
    }

    protected GapList<E> removeAll(E elem) {
        return this.removeAllByKey(0, elem);
    }

    protected Set<E> getDistinct() {
        return this.getDistinctKeys(0);
    }

    static class KeyMapList<E>
    extends GapList<E> {
        public KeyMapList() {
        }

        public KeyMapList(KeyMapList that) {
            super(that);
        }
    }

    static class KeyMap<E, K>
    implements Serializable {
        IFunction<E, K> mapper;
        boolean allowNull;
        boolean allowDuplicates;
        boolean allowDuplicatesNull;
        Comparator<K> comparator;
        Map<K, Object> keysMap;
        IList<K> keysList;
        boolean count;

        KeyMap() {
        }

        KeyMap<E, K> copy() {
            KeyMap<E, K> copy2 = new KeyMap<E, K>();
            copy2.mapper = this.mapper;
            copy2.allowNull = this.allowNull;
            copy2.allowDuplicates = this.allowDuplicates;
            copy2.allowDuplicatesNull = this.allowDuplicatesNull;
            copy2.comparator = this.comparator;
            copy2.count = this.count;
            if (this.keysMap != null) {
                copy2.keysMap = this.keysMap instanceof HashMap ? (Map)((HashMap)this.keysMap).clone() : (Map)((TreeMap)this.keysMap).clone();
                for (Map.Entry<K, Object> obj : copy2.keysMap.entrySet()) {
                    Map.Entry<K, Object> entry = obj;
                    KeyMapList val = entry.getValue();
                    if (!(val instanceof KeyMapList)) continue;
                    val = new KeyMapList(val);
                    entry.setValue(val);
                }
            } else {
                copy2.keysList = this.keysList.copy();
            }
            return copy2;
        }

        KeyMap<E, K> crop() {
            KeyMap<E, K> copy2 = new KeyMap<E, K>();
            copy2.mapper = this.mapper;
            copy2.allowNull = this.allowNull;
            copy2.allowDuplicates = this.allowDuplicates;
            copy2.allowDuplicatesNull = this.allowDuplicatesNull;
            copy2.comparator = this.comparator;
            copy2.count = this.count;
            if (this.keysMap != null) {
                copy2.keysMap = this.keysMap instanceof HashMap ? new HashMap<K, Object>() : new TreeMap<K, Object>();
            } else {
                copy2.keysList = new GapList<K>();
            }
            return copy2;
        }

        K getKey(E elem) {
            if (elem == null) {
                return null;
            }
            return this.mapper.apply(elem);
        }

        boolean containsKey(Object key) {
            if (key == null && !this.allowNull) {
                return false;
            }
            if (this.keysMap != null) {
                return this.keysMap.containsKey(key);
            }
            return this.keysList.binarySearch(key, this.comparator) >= 0;
        }

        boolean containsValue(Object value) {
            assert (!this.count);
            return this.keysMap.containsValue(value);
        }

        Option<E> getContainedKey(Object key) {
            if (key == null && !this.allowNull) {
                return Option.EMPTY();
            }
            if (this.keysMap != null) {
                Object val = this.keysMap.get(key);
                if (val != null) {
                    return new Option<Object>(val);
                }
                if (this.keysMap.containsKey(key)) {
                    return new Option<Object>(val);
                }
            } else {
                int index = this.keysList.binarySearch(key, this.comparator);
                if (index >= 0) {
                    return new Option<K>(this.keysList.get(index));
                }
            }
            return Option.EMPTY();
        }

        Option<E> getContainedValue(Object value) {
            assert (!this.count);
            for (Map.Entry<K, Object> entry : this.keysMap.entrySet()) {
                if ((entry.getValue() != null || value != null) && (entry.getValue() == null || !entry.getValue().equals(value))) continue;
                return new Option<Object>(entry.getValue());
            }
            return Option.EMPTY();
        }

        Iterator<E> iteratorValues(KeyCollectionImpl<E> keyColl) {
            assert (this.keysMap != null);
            if (this.count) {
                return new KeyMapCountIter<E, K>(keyColl, this, this.keysMap);
            }
            return new KeyMapIter<E, K>(keyColl, this, this.keysMap);
        }

        void add(K key, E elem) {
            if (key == null && !this.allowNull) {
                KeyCollectionImpl.errorNullKey();
            }
            if (this.keysMap != null) {
                Object newElem = this.count ? Integer.valueOf(1) : elem;
                int oldSize = this.keysMap.size();
                Object oldElem = this.keysMap.put(key, newElem);
                boolean hasOldElem = oldElem != null ? true : (key == null ? this.keysMap.size() == oldSize : false);
                if (hasOldElem) {
                    if (!(this.allowDuplicates || key == null && this.allowDuplicatesNull)) {
                        this.keysMap.put(key, oldElem);
                        KeyCollectionImpl.errorDuplicateKey(key);
                    }
                    if (this.count) {
                        if (oldElem != null) {
                            Integer val = (Integer)oldElem;
                            this.keysMap.put(key, val + 1);
                        }
                    } else {
                        KeyMapList<Object> list2;
                        if (oldElem instanceof KeyMapList) {
                            list2 = (KeyMapList<Object>)oldElem;
                            list2.add(elem);
                        } else {
                            list2 = new KeyMapList<Object>();
                            list2.addArray(oldElem, elem);
                        }
                        this.keysMap.put(key, list2);
                    }
                }
            } else {
                int addIndex = 0;
                if (!this.keysList.isEmpty()) {
                    if (this.comparator.compare(key, this.keysList.getLast()) > 0) {
                        addIndex = -this.keysList.size() - 1;
                    } else if (this.comparator.compare(key, this.keysList.getFirst()) < 0) {
                        addIndex = -1;
                    }
                }
                if (addIndex == 0) {
                    addIndex = SortedLists.binarySearchAdd(this.keysList, key, this.comparator);
                }
                boolean add = false;
                if (addIndex < 0) {
                    addIndex = -addIndex - 1;
                    add = true;
                } else if (this.allowDuplicates || key == null && this.allowDuplicatesNull) {
                    add = true;
                }
                if (!add) {
                    KeyCollectionImpl.errorDuplicateKey(key);
                }
                this.keysList.doAdd(addIndex, key);
            }
        }

        Option<E> remove(Object key, boolean matchValue, Object value, KeyCollectionImpl keyColl) {
            if (key == null && !this.allowNull) {
                return Option.EMPTY();
            }
            if (this.keysMap != null) {
                if (!this.keysMap.containsKey(key)) {
                    return Option.EMPTY();
                }
                if (this.count) {
                    assert (!matchValue || key == value);
                    Integer val = (Integer)this.keysMap.get(key);
                    if (val == 1) {
                        this.keysMap.remove(key);
                    } else {
                        this.keysMap.put(key, val - 1);
                    }
                    return new Option<Object>(key);
                }
                Object elem = null;
                Object obj = this.keysMap.get(key);
                if (obj instanceof KeyMapList) {
                    GapList list2 = (GapList)obj;
                    if (matchValue) {
                        if (!list2.remove(value)) {
                            return Option.EMPTY();
                        }
                        elem = value;
                    } else {
                        elem = list2.removeFirst();
                    }
                    if (list2.isEmpty()) {
                        this.keysMap.remove(key);
                    }
                } else {
                    elem = this.keysMap.remove(key);
                }
                return new Option<Object>(elem);
            }
            int index = this.keysList.binarySearch(key, this.comparator);
            Object elem = null;
            if (index < 0) {
                return Option.EMPTY();
            }
            elem = keyColl.keyList.doGet(index);
            this.keysList.remove(index);
            return new Option<Object>(elem);
        }

        private GapList<E> doRemoveAllByKey(K key, KeyCollectionImpl<E> keyColl) {
            if (key == null && !this.allowNull) {
                return GapList.create();
            }
            if (this.keysMap != null) {
                if (!this.keysMap.containsKey(key)) {
                    return GapList.create();
                }
                Object obj = this.keysMap.remove(key);
                GapList<Object> removed = obj instanceof KeyMapList ? GapList.create((GapList)obj) : GapList.create(obj);
                return removed;
            }
            int index = SortedLists.binarySearchGet(this.keysList, key, this.comparator);
            if (index < 0) {
                return GapList.create();
            }
            int start = index;
            while (++index != this.keysList.size() && GapList.equalsElem(this.keysList.get(index), key)) {
            }
            GapList removed = (GapList)keyColl.keyList.list.getAll(start, index - start);
            this.keysList.remove(start, index - start);
            return removed;
        }

        Set<K> getDistinctKeys() {
            if (this.keysMap != null) {
                Set<K> set = this.keysMap.keySet();
                if (this.comparator != null) {
                    TreeSet<K> treeSet = new TreeSet<K>(this.comparator);
                    treeSet.addAll(set);
                    return treeSet;
                }
                return new HashSet<K>(set);
            }
            Object lastKey = null;
            TreeSet<K> set = new TreeSet<K>(this.comparator);
            for (int i = 0; i < this.keysList.size(); ++i) {
                K key = this.keysList.get(i);
                boolean add = false;
                if (set.isEmpty()) {
                    add = true;
                } else if (key != null) {
                    add = !key.equals(lastKey);
                } else {
                    boolean bl = add = lastKey != null;
                }
                if (!add) continue;
                set.add(key);
                lastKey = key;
            }
            return set;
        }

        static class KeyMapCountIter<E, K>
        implements Iterator<E> {
            KeyCollectionImpl<E> keyColl;
            KeyMap<E, K> keyMap;
            Map<K, Object> map;
            Iterator<Map.Entry<K, Object>> mapIter;
            E elem;
            int count;
            boolean hasElem;

            public KeyMapCountIter(KeyCollectionImpl<E> keyColl, KeyMap<E, K> keyMap, Map<K, Object> map) {
                this.keyColl = keyColl;
                this.keyMap = keyMap;
                this.map = map;
                this.mapIter = map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                boolean hasNext = false;
                if (this.count > 0) {
                    hasNext = true;
                }
                if (!hasNext) {
                    hasNext = this.mapIter.hasNext();
                }
                return hasNext;
            }

            @Override
            public E next() {
                this.hasElem = false;
                if (this.count > 0) {
                    --this.count;
                } else {
                    Map.Entry<K, Object> o = this.mapIter.next();
                    this.elem = o.getKey();
                    this.count = (Integer)o.getValue();
                    --this.count;
                }
                this.hasElem = true;
                return this.elem;
            }

            @Override
            public void remove() {
                if (!this.hasElem) {
                    throw new IllegalStateException("No current element to remove");
                }
                this.hasElem = false;
                Integer val = (Integer)this.map.get(this.elem);
                if (val == 1) {
                    this.mapIter.remove();
                } else {
                    this.map.put(this.elem, val - 1);
                }
            }
        }

        static class KeyMapIter<E, K>
        implements Iterator<E> {
            KeyCollectionImpl<E> keyColl;
            KeyMap<E, K> keyMap;
            Iterator<Object> mapIter;
            Iterator<E> listIter;
            boolean hasElem;
            E elem;

            public KeyMapIter(KeyCollectionImpl<E> tableColl, KeyMap<E, K> keyMap, Map<K, Object> map) {
                this.keyColl = tableColl;
                this.keyMap = keyMap;
                this.mapIter = map.values().iterator();
            }

            @Override
            public boolean hasNext() {
                boolean hasNext = false;
                if (this.listIter != null) {
                    hasNext = this.listIter.hasNext();
                }
                if (!hasNext) {
                    hasNext = this.mapIter.hasNext();
                }
                return hasNext;
            }

            @Override
            public E next() {
                this.hasElem = false;
                boolean hasNext = false;
                this.elem = null;
                if (this.listIter != null) {
                    if (this.listIter.hasNext()) {
                        hasNext = true;
                        this.elem = this.listIter.next();
                    } else {
                        this.listIter = null;
                    }
                }
                if (!hasNext) {
                    Object o = this.mapIter.next();
                    if (o instanceof KeyMapList) {
                        this.listIter = ((KeyMapList)o).iterator();
                        this.elem = this.listIter.next();
                    } else {
                        this.elem = o;
                    }
                }
                this.hasElem = true;
                return this.elem;
            }

            @Override
            public void remove() {
                if (!this.hasElem) {
                    throw new IllegalStateException("No current element to remove");
                }
                this.hasElem = false;
                if (this.listIter != null) {
                    this.listIter.remove();
                } else {
                    this.mapIter.remove();
                }
                this.keyColl.remove(this.elem, this.keyMap);
            }
        }
    }

    public static class BuilderImpl<E> {
        KeyCollectionImpl<E> keyColl;
        KeyListImpl<E> keyList;
        boolean allowNullElem = true;
        IPredicate<E> constraint;
        IConsumer<E> beforeInsertTrigger;
        IConsumer<E> afterInsertTrigger;
        IConsumer<E> beforeDeleteTrigger;
        IConsumer<E> afterDeleteTrigger;
        GapList<KeyMapBuilder<E, Object>> keyMapBuilders = GapList.create();
        Collection<? extends E> collection;
        E[] array;
        int capacity;
        int maxSize;
        Boolean movingWindow;
        boolean count;
        boolean useBigList;

        protected BuilderImpl<E> withNull(boolean allowNull) {
            this.allowNullElem = allowNull;
            if (this.hasElemMapBuilder()) {
                this.getKeyMapBuilder((int)0).allowNull = allowNull;
            }
            return this;
        }

        protected BuilderImpl<E> withConstraint(IPredicate<E> constraint) {
            this.constraint = constraint;
            return this;
        }

        protected BuilderImpl<E> withBeforeInsertTrigger(IConsumer<E> trigger) {
            this.beforeInsertTrigger = trigger;
            return this;
        }

        protected BuilderImpl<E> withAfterInsertTrigger(IConsumer<E> trigger) {
            this.afterInsertTrigger = trigger;
            return this;
        }

        protected BuilderImpl<E> withBeforeDeleteTrigger(IConsumer<E> trigger) {
            this.beforeDeleteTrigger = trigger;
            return this;
        }

        protected BuilderImpl<E> withAfterDeleteTrigger(IConsumer<E> trigger) {
            this.afterDeleteTrigger = trigger;
            return this;
        }

        protected BuilderImpl<E> withCapacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        protected BuilderImpl<E> withContent(Collection<? extends E> elements) {
            this.collection = elements;
            return this;
        }

        protected BuilderImpl<E> withContent(E ... elements) {
            this.array = elements;
            return this;
        }

        protected BuilderImpl<E> withMaxSize(int maxSize) {
            if (this.movingWindow != null) {
                throw new IllegalArgumentException("maximum or window size alreay set");
            }
            this.maxSize = maxSize;
            this.movingWindow = false;
            return this;
        }

        protected BuilderImpl<E> withWindowSize(int maxSize) {
            if (this.movingWindow != null) {
                throw new IllegalArgumentException("maximum or window size alreay set");
            }
            this.maxSize = maxSize;
            this.movingWindow = true;
            return this;
        }

        protected BuilderImpl<E> withElemCount(boolean count) {
            this.count = count;
            return this;
        }

        protected BuilderImpl<E> withElemSet() {
            return this.withKeyMap(0, IdentMapper.INSTANCE);
        }

        protected BuilderImpl<E> withOrderByElem(boolean orderBy) {
            return this.withOrderByKey(0, orderBy);
        }

        protected BuilderImpl<E> withOrderByElem(Class<?> type) {
            return this.withOrderByKey(0, type);
        }

        protected BuilderImpl<E> withElemNull(boolean allowNull) {
            return this.withKeyNull(0, allowNull);
        }

        protected BuilderImpl<E> withElemDuplicates(boolean allowDuplicates) {
            return this.withElemDuplicates(allowDuplicates, allowDuplicates);
        }

        protected BuilderImpl<E> withElemDuplicates(boolean allowDuplicates, boolean allowDuplicatesNull) {
            return this.withKeyDuplicates(0, allowDuplicates, allowDuplicatesNull);
        }

        protected BuilderImpl<E> withElemSort(boolean sort) {
            return this.withKeySort(0, sort);
        }

        protected BuilderImpl<E> withElemSort(Comparator<? super E> comparator) {
            return this.withKeySort(0, comparator);
        }

        protected BuilderImpl<E> withElemSort(Comparator<? super E> comparator, boolean sortNullsFirst) {
            return this.withKeySort(0, comparator, sortNullsFirst);
        }

        protected BuilderImpl<E> withPrimaryElem() {
            return this.withPrimaryKeyMap(0, null);
        }

        protected BuilderImpl<E> withUniqueElem() {
            return this.withUniqueKeyMap(0, null);
        }

        protected BuilderImpl<E> withKeyMap(int keyIndex, IFunction mapper) {
            if (mapper == null) {
                throw new IllegalArgumentException("Mapper may not be null");
            }
            KeyMapBuilder<E, Object> kmb = this.getKeyMapBuilder(keyIndex);
            if (kmb.mapper != null) {
                throw new IllegalArgumentException("Mapper already set");
            }
            kmb.mapper = mapper;
            return this;
        }

        protected BuilderImpl<E> withOrderByKey(int keyIndex, boolean orderBy) {
            KeyMapBuilder<E, Object> kmb = this.getKeyMapBuilder(keyIndex);
            if (kmb.orderBy != null) {
                throw new IllegalArgumentException("Order by already set");
            }
            kmb.orderBy = orderBy;
            return this;
        }

        protected BuilderImpl<E> withOrderByKey(int keyIndex, Class<?> type) {
            if (type == null) {
                throw new IllegalArgumentException("Order by type may not be null");
            }
            if (!type.isPrimitive()) {
                throw new IllegalArgumentException("Class type must be primitive");
            }
            KeyMapBuilder<E, Object> kmb = this.getKeyMapBuilder(keyIndex);
            if (kmb.orderBy != null) {
                throw new IllegalArgumentException("Order by already set");
            }
            kmb.orderBy = true;
            kmb.primitiveListType = type;
            return this;
        }

        protected BuilderImpl<E> withListType(Class<?> type) {
            if (type == null) {
                throw new IllegalArgumentException("Class type may not be null");
            }
            if (!type.isPrimitive()) {
                throw new IllegalArgumentException("Class type must be primitive");
            }
            KeyMapBuilder<E, Object> kmb = this.getKeyMapBuilder(0);
            kmb.primitiveListType = type;
            return this;
        }

        protected BuilderImpl<E> withListBig(boolean big) {
            this.useBigList = big;
            return this;
        }

        protected BuilderImpl<E> withKeyNull(int keyIndex, boolean allowNull) {
            KeyMapBuilder<E, Object> kmb = this.getKeyMapBuilder(keyIndex);
            if (kmb.allowNull != null) {
                throw new IllegalArgumentException("AllowNull already set");
            }
            kmb.allowNull = allowNull;
            if (keyIndex == 0) {
                this.allowNullElem = allowNull;
            }
            return this;
        }

        protected BuilderImpl<E> withKeyDuplicates(int keyIndex, boolean allowDuplicates, boolean allowDuplicatesNull) {
            KeyMapBuilder<E, Object> kmb = this.getKeyMapBuilder(keyIndex);
            if (kmb.allowDuplicates != null) {
                throw new IllegalArgumentException("AllowDuplicates already set");
            }
            kmb.allowDuplicates = allowDuplicates;
            kmb.allowDuplicatesNull = allowDuplicatesNull;
            return this;
        }

        protected BuilderImpl<E> withKeySort(int keyIndex, boolean sort) {
            KeyMapBuilder<E, Object> kmb = this.getKeyMapBuilder(keyIndex);
            if (kmb.sort != null) {
                throw new IllegalArgumentException("Sort already set");
            }
            kmb.sort = sort;
            kmb.comparator = null;
            kmb.comparatorSortsNull = false;
            kmb.sortNullsFirst = false;
            return this;
        }

        protected BuilderImpl<E> withKeySort(int keyIndex, Comparator<?> comparator) {
            KeyMapBuilder<E, Object> kmb = this.getKeyMapBuilder(keyIndex);
            if (kmb.sort != null) {
                throw new IllegalArgumentException("Sort already set");
            }
            kmb.sort = true;
            kmb.comparator = comparator;
            kmb.comparatorSortsNull = true;
            kmb.sortNullsFirst = false;
            return this;
        }

        protected BuilderImpl<E> withKeySort(int keyIndex, Comparator<?> comparator, boolean sortNullsFirst) {
            KeyMapBuilder<E, Object> kmb = this.getKeyMapBuilder(keyIndex);
            if (kmb.sort != null) {
                throw new IllegalArgumentException("Sort already set");
            }
            kmb.sort = true;
            kmb.comparator = comparator;
            kmb.comparatorSortsNull = false;
            kmb.sortNullsFirst = sortNullsFirst;
            return this;
        }

        protected BuilderImpl<E> withPrimaryKeyMap(int keyIndex, IFunction mapper) {
            if (mapper != null) {
                this.withKeyMap(keyIndex, mapper);
            }
            this.withKeyNull(keyIndex, false);
            this.withKeyDuplicates(keyIndex, false, false);
            return this;
        }

        protected BuilderImpl<E> withUniqueKeyMap(int keyIndex, IFunction mapper) {
            if (mapper != null) {
                this.withKeyMap(keyIndex, mapper);
            }
            this.withKeyNull(keyIndex, true);
            this.withKeyDuplicates(keyIndex, false, true);
            return this;
        }

        protected BuilderImpl<E> withOrderByKey1(boolean orderBy) {
            return this.withOrderByKey(1, orderBy);
        }

        protected BuilderImpl<E> withOrderByKey1(Class<?> type) {
            return this.withOrderByKey(1, type);
        }

        protected BuilderImpl<E> withKey1Null(boolean allowNull) {
            return this.withKeyNull(1, allowNull);
        }

        protected BuilderImpl<E> withKey1Duplicates(boolean allowDuplicates) {
            return this.withKeyDuplicates(1, allowDuplicates, allowDuplicates);
        }

        protected BuilderImpl<E> withKey1Duplicates(boolean allowDuplicates, boolean allowDuplicatesNull) {
            return this.withKeyDuplicates(1, allowDuplicates, allowDuplicatesNull);
        }

        protected BuilderImpl<E> withKey1Sort(boolean sort) {
            return this.withKeySort(1, sort);
        }

        protected BuilderImpl<E> withOrderByKey2(boolean orderBy) {
            return this.withOrderByKey(2, orderBy);
        }

        protected BuilderImpl<E> withOrderByKey2(Class<?> type) {
            return this.withOrderByKey(2, type);
        }

        protected BuilderImpl<E> withKey2Null(boolean allowNull) {
            return this.withKeyNull(2, allowNull);
        }

        protected BuilderImpl<E> withKey2Duplicates(boolean allowDuplicates) {
            return this.withKeyDuplicates(2, allowDuplicates, allowDuplicates);
        }

        protected BuilderImpl<E> withKey2Duplicates(boolean allowDuplicates, boolean allowDuplicatesNull) {
            return this.withKeyDuplicates(2, allowDuplicates, allowDuplicatesNull);
        }

        protected BuilderImpl<E> withKey2Sort(boolean sort) {
            return this.withKeySort(2, sort);
        }

        void initKeyMapBuilder(int numKeys) {
            assert (numKeys >= 0);
            this.keyMapBuilders.initMult(numKeys + 1, null);
        }

        boolean hasElemMapBuilder() {
            return this.keyMapBuilders.size() > 0 && this.keyMapBuilders.get(0) != null;
        }

        KeyMapBuilder<E, Object> getKeyMapBuilder(int index) {
            int size2;
            for (int i = size2 = this.keyMapBuilders.size(); i <= index; ++i) {
                this.keyMapBuilders.add(i, null);
            }
            KeyMapBuilder<E, Object> kmb = this.keyMapBuilders.get(index);
            if (kmb == null) {
                kmb = new KeyMapBuilder();
                this.keyMapBuilders.set(index, kmb);
            }
            return kmb;
        }

        boolean isTrue(Boolean b) {
            return b != null && b != false;
        }

        boolean isFalse(Boolean b) {
            return b == null || b != false;
        }

        KeyMap buildKeyMap(KeyMapBuilder keyMapBuilder, boolean list2) {
            KeyMap keyMap = new KeyMap();
            keyMap.mapper = keyMapBuilder.mapper;
            keyMap.allowNull = this.isFalse(keyMapBuilder.allowNull);
            keyMap.allowDuplicates = this.isFalse(keyMapBuilder.allowDuplicates);
            keyMap.allowDuplicatesNull = this.isFalse(keyMapBuilder.allowDuplicatesNull);
            if (this.isTrue(keyMapBuilder.sort) || this.isTrue(keyMapBuilder.orderBy)) {
                keyMap.comparator = keyMapBuilder.comparator == null ? (keyMap.allowNull ? new NullComparator(NaturalComparator.INSTANCE(), keyMapBuilder.sortNullsFirst) : NaturalComparator.INSTANCE()) : (!keyMapBuilder.comparatorSortsNull && keyMap.allowNull ? new NullComparator(keyMapBuilder.comparator, keyMapBuilder.sortNullsFirst) : keyMapBuilder.comparator);
            }
            if (list2 && this.isTrue(keyMapBuilder.orderBy)) {
                if (keyMapBuilder.primitiveListType == null) {
                    keyMap.keysList = this.useBigList ? new BigList() : new GapList();
                } else {
                    if (keyMapBuilder.comparator != null && keyMapBuilder.comparator != NaturalComparator.INSTANCE()) {
                        throw new IllegalArgumentException("Only natural comparator supported for list type");
                    }
                    if (this.isTrue(keyMapBuilder.allowNull)) {
                        throw new IllegalArgumentException("Null values are not supported for primitive list type");
                    }
                    keyMap.comparator = NaturalComparator.INSTANCE();
                    keyMap.keysList = this.useBigList ? BigLists.createWrapperList(keyMapBuilder.primitiveListType) : GapLists.createWrapperList(keyMapBuilder.primitiveListType);
                }
            } else {
                keyMap.keysMap = keyMap.comparator != null ? new TreeMap(keyMap.comparator) : new HashMap();
            }
            return keyMap;
        }

        void build(KeyCollectionImpl keyColl, boolean list2) {
            keyColl.allowNullElem = this.allowNullElem;
            keyColl.constraint = this.constraint;
            keyColl.beforeInsertTrigger = this.beforeInsertTrigger;
            keyColl.afterInsertTrigger = this.afterInsertTrigger;
            keyColl.beforeDeleteTrigger = this.beforeDeleteTrigger;
            keyColl.afterDeleteTrigger = this.afterDeleteTrigger;
            keyColl.maxSize = this.maxSize;
            keyColl.movingWindow = this.isTrue(this.movingWindow);
            int orderByKey = -1;
            int size2 = this.keyMapBuilders.size();
            if (size2 == 1) {
                KeyMapBuilder<E, Object> kmb = this.keyMapBuilders.get(0);
                if (kmb == null) {
                    if (!list2) {
                        this.withElemSet();
                    } else {
                        size2 = 0;
                    }
                } else if (list2 && kmb.primitiveListType != null && kmb.orderBy == null && kmb.mapper == null && kmb.allowDuplicates == null && kmb.allowNull == null && kmb.sort == null) {
                    size2 = 0;
                }
            }
            if (size2 > 0) {
                keyColl.keyMaps = new KeyMap[size2];
                for (int i = 0; i < size2; ++i) {
                    KeyMapBuilder<E, Object> kmb = this.keyMapBuilders.get(i);
                    if (kmb == null) {
                        if (i == 0) continue;
                        throw new IllegalArgumentException("Key " + i + " is not defined");
                    }
                    if (this.isTrue(kmb.orderBy)) {
                        if (orderByKey != -1) {
                            throw new IllegalArgumentException("Only one order by key allowed");
                        }
                        orderByKey = i;
                    }
                    if (kmb.mapper == null) {
                        if (i == 0) {
                            kmb.mapper = IdentMapper.INSTANCE;
                        } else {
                            throw new IllegalArgumentException("No mapper for key " + i + " defined");
                        }
                    }
                    keyColl.keyMaps[i] = this.buildKeyMap(kmb, list2);
                    if (i != 0) continue;
                    keyColl.keyMaps[i].count = this.count;
                }
            }
            if (orderByKey == -1 && !list2 && keyColl.keyMaps != null) {
                if (keyColl.keyMaps[0] != null) {
                    orderByKey = 0;
                } else {
                    assert (keyColl.keyMaps[1] != null);
                    orderByKey = 1;
                }
            }
            keyColl.orderByKey = orderByKey;
        }

        void init(KeyCollectionImpl keyColl) {
            if (this.collection != null) {
                keyColl.addAll(this.collection);
            } else if (this.array != null) {
                keyColl.addAll(Arrays.asList(this.array));
            }
        }

        void init(KeyCollectionImpl keyColl, KeyListImpl keyList) {
            keyList.keyColl = keyColl;
            keyColl.keyList = keyList;
            if (keyColl.orderByKey == 0) {
                keyList.list = keyColl.keyMaps[0].keysList;
                if (keyList.list == null) {
                    keyList.list = this.initList();
                }
                if (this.collection != null) {
                    keyColl.addAll(this.collection);
                } else if (this.array != null) {
                    keyColl.addAll(Arrays.asList(this.array));
                }
            } else {
                keyList.list = this.initList();
                if (this.collection != null) {
                    keyList.ensureCapacity(this.capacity);
                    keyList.addAll(this.collection);
                } else if (this.array != null) {
                    keyList.ensureCapacity(this.capacity);
                    keyList.addArray(this.array);
                } else if (this.capacity != 0) {
                    keyList.ensureCapacity(this.capacity);
                }
            }
        }

        IList<?> initList() {
            Class<?> primitiveListType = null;
            KeyMapBuilder<E, Object> kmb = this.keyMapBuilders.get(0);
            if (kmb != null) {
                primitiveListType = kmb.primitiveListType;
            }
            if (primitiveListType == null) {
                if (this.useBigList) {
                    return new BigList();
                }
                return new GapList();
            }
            if (this.useBigList) {
                return BigLists.createWrapperList(primitiveListType);
            }
            return GapLists.createWrapperList(primitiveListType);
        }

        public static class KeyMapBuilder<E, K> {
            Boolean orderBy;
            Class<?> primitiveListType;
            IFunction<E, K> mapper;
            Boolean allowNull;
            Boolean allowDuplicates;
            boolean allowDuplicatesNull;
            Boolean sort;
            Comparator<?> comparator;
            boolean comparatorSortsNull;
            boolean sortNullsFirst;
        }
    }
}

