/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.debug;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.silentchaos512.lib.SilentLib;
import org.apache.logging.log4j.Logger;

public final class DataDump {
    private static final String REGISTRY_NAME_IS_NULL = "Registry name is null! This indicates a broken mod and is a serious problem!";
    private static final String SEPARATOR = "--------------------------------------------------------------------------------";

    private DataDump() {
        throw new IllegalAccessError("Utility class");
    }

    public static void dumpBlocks() {
        SilentLib.LOGGER.info(SEPARATOR);
        ArrayList<String> lines = new ArrayList<String>();
        for (Block block : ForgeRegistries.BLOCKS) {
            try {
                ResourceLocation name = Objects.requireNonNull(block.getRegistryName(), REGISTRY_NAME_IS_NULL);
                String translatedName = I18n.func_135052_a((String)(block.func_149739_a() + ".name"), (Object[])new Object[0]);
                lines.add(String.format("%-60s %-60s", name, translatedName));
            }
            catch (Exception ex) {
                SilentLib.LOGGER.warn("*** Error on block: {} ***", (Object)block);
                SilentLib.LOGGER.catching((Throwable)ex);
            }
        }
        lines.sort(String::compareToIgnoreCase);
        lines.forEach(arg_0 -> ((Logger)SilentLib.LOGGER).info(arg_0));
        SilentLib.LOGGER.info(SEPARATOR);
    }

    public static void dumpEnchantments() {
        SilentLib.LOGGER.info(SEPARATOR);
        for (Enchantment ench : Enchantment.field_185264_b) {
            try {
                ResourceLocation name = Objects.requireNonNull(ench.getRegistryName(), REGISTRY_NAME_IS_NULL);
                String translatedName = ench.func_77316_c(1).replaceFirst(" I$", "");
                String type = ench.field_77351_y == null ? "null" : ench.field_77351_y.name();
                SilentLib.LOGGER.info(String.format("%-30s %-40s type=%-10s", translatedName, name, type));
            }
            catch (Exception ex) {
                SilentLib.LOGGER.warn("*** Error on enchantment: {} ***", (Object)ench);
                SilentLib.LOGGER.catching((Throwable)ex);
            }
        }
        SilentLib.LOGGER.info(SEPARATOR);
    }

    public static void dumpEntityList() {
        SilentLib.LOGGER.info(SEPARATOR);
        ArrayList list = Lists.newArrayList();
        for (EntityEntry entry : ForgeRegistries.ENTITIES) {
            try {
                ResourceLocation name = Objects.requireNonNull(entry.getRegistryName(), REGISTRY_NAME_IS_NULL);
                Class clazz = EntityList.getClass((ResourceLocation)entry.getRegistryName());
                String oldName = EntityList.func_191302_a((ResourceLocation)name);
                int id = EntityList.getID((Class)clazz);
                list.add(String.format("%-30s %4d   %-40s %-40s", oldName, id, name, clazz));
            }
            catch (Exception ex) {
                SilentLib.LOGGER.warn("*** Error on entity: {} ***", (Object)entry.getEntityClass());
                SilentLib.LOGGER.catching((Throwable)ex);
            }
        }
        list.sort(String::compareToIgnoreCase);
        list.forEach(arg_0 -> ((Logger)SilentLib.LOGGER).info(arg_0));
        SilentLib.LOGGER.info(SEPARATOR);
    }

    public static void dumpItems() {
        SilentLib.LOGGER.info(SEPARATOR);
        ArrayList<String> lines = new ArrayList<String>();
        for (Item item : ForgeRegistries.ITEMS) {
            try {
                ResourceLocation name = Objects.requireNonNull(item.getRegistryName(), REGISTRY_NAME_IS_NULL);
                String translatedName = I18n.func_135052_a((String)(item.func_77658_a() + ".name"), (Object[])new Object[0]);
                lines.add(String.format("%-60s %-60s", name, translatedName));
            }
            catch (Exception ex) {
                SilentLib.LOGGER.warn("*** Error on item: {} ***", (Object)item);
                SilentLib.LOGGER.catching((Throwable)ex);
            }
        }
        lines.forEach(arg_0 -> ((Logger)SilentLib.LOGGER).info(arg_0));
        SilentLib.LOGGER.info(SEPARATOR);
    }

    public static void dumpPotionEffects() {
        SilentLib.LOGGER.info(SEPARATOR);
        for (Potion pot : Potion.field_188414_b) {
            try {
                ResourceLocation name = Objects.requireNonNull(pot.getRegistryName(), REGISTRY_NAME_IS_NULL);
                SilentLib.LOGGER.info(String.format("%-30s %-40s", pot.func_76393_a(), name));
            }
            catch (Exception ex) {
                SilentLib.LOGGER.warn("*** Error on potion: {} ***", (Object)pot);
                SilentLib.LOGGER.catching((Throwable)ex);
            }
        }
        SilentLib.LOGGER.info(SEPARATOR);
    }

    public static void dumpRecipes() {
        SilentLib.LOGGER.info(SEPARATOR);
        SilentLib.LOGGER.info("The following is a list of all recipes registered as of Silent Lib's post-init:");
        for (IRecipe rec : CraftingManager.field_193380_a) {
            try {
                ResourceLocation name = Objects.requireNonNull(rec.getRegistryName(), REGISTRY_NAME_IS_NULL);
                int id = CraftingManager.field_193380_a.func_148757_b((Object)rec);
                if (id < 0) {
                    throw new IndexOutOfBoundsException("id < 0");
                }
                SilentLib.LOGGER.info(String.format("%-6d %-40s", id, name));
            }
            catch (Exception ex) {
                SilentLib.LOGGER.info("*** Error on recipe: {} ***", (Object)rec);
                throw ex;
            }
        }
        SilentLib.LOGGER.info(SEPARATOR);
    }
}

