/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.Random;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;

public final class MathUtils {
    private static final double DOUBLES_EQUAL_PRECISION = 1.0E-9;
    private static final Random RANDOM = new Random();

    private MathUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static AxisAlignedBB boundingBoxByPixels(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new AxisAlignedBB((double)((float)minX / 16.0f), (double)((float)minY / 16.0f), (double)((float)minZ / 16.0f), (double)((float)maxX / 16.0f), (double)((float)maxY / 16.0f), (double)((float)maxZ / 16.0f));
    }

    public static double distance(Vec3i from, Vec3i to) {
        int dx = to.func_177958_n() - from.func_177958_n();
        int dy = to.func_177956_o() - from.func_177956_o();
        int dz = to.func_177952_p() - from.func_177952_p();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double distanceSq(Vec3i from, Vec3i to) {
        int dx = to.func_177958_n() - from.func_177958_n();
        int dy = to.func_177956_o() - from.func_177956_o();
        int dz = to.func_177952_p() - from.func_177952_p();
        return dx * dx + dy * dy + dz * dz;
    }

    public static double distanceHorizontal(Vec3i from, Vec3i to) {
        int dx = to.func_177958_n() - from.func_177958_n();
        int dz = to.func_177952_p() - from.func_177952_p();
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double distanceHorizontalSq(Vec3i from, Vec3i to) {
        int dx = to.func_177958_n() - from.func_177958_n();
        int dz = to.func_177952_p() - from.func_177952_p();
        return dx * dx + dz * dz;
    }

    public static boolean doublesEqual(double a, double b) {
        return MathUtils.doublesEqual(a, b, 1.0E-9);
    }

    public static boolean doublesEqual(double a, double b, double precision) {
        return Math.abs(b - a) < precision;
    }

    public static boolean floatsEqual(float a, float b) {
        return MathUtils.floatsEqual(a, b, 1.0E-9f);
    }

    public static boolean floatsEqual(float a, float b, float precision) {
        return Math.abs(b - a) < precision;
    }

    public static boolean inRangeExclusive(double value, double min, double max) {
        return value < max && value > min;
    }

    public static boolean inRangeExclusive(int value, int min, int max) {
        return value < max && value > min;
    }

    public static boolean inRangeInclusive(double value, double min, double max) {
        return value <= max && value >= min;
    }

    public static boolean inRangeInclusive(int value, int min, int max) {
        return value <= max && value >= min;
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static int min(int a, int b, int c) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static int min(int a, int b, int c, int d) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        if (d < a) {
            a = d;
        }
        return a;
    }

    public static int min(int a, int b, int c, int d, int ... rest) {
        int min = MathUtils.min(a, b, c, d);
        for (int i : rest) {
            if (i >= min) continue;
            min = i;
        }
        return min;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static int max(int a, int b, int c) {
        if (b > a) {
            a = b;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static int max(int a, int b, int c, int d) {
        if (b > a) {
            a = b;
        }
        if (c > a) {
            a = c;
        }
        if (d > a) {
            a = d;
        }
        return a;
    }

    public static int max(int a, int b, int c, int d, int ... rest) {
        int max = MathUtils.max(a, b, c, d);
        for (int i : rest) {
            if (i <= max) continue;
            max = i;
        }
        return max;
    }

    public static double nextGaussian(double mean, double deviation) {
        return deviation * RANDOM.nextGaussian() + mean;
    }

    public static double nextGaussian(Random random, double mean, double deviation) {
        return deviation * random.nextGaussian() + mean;
    }

    public static int nextInt(int bound) {
        return RANDOM.nextInt(bound);
    }

    public static int nextIntInclusive(int min, int max) {
        return RANDOM.nextInt(max - min + 1) + min;
    }

    public static int nextIntInclusive(Random random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static boolean tryPercentage(double percent) {
        return RANDOM.nextDouble() < percent;
    }

    public static boolean tryPercentage(Random random, double percent) {
        return random.nextDouble() < percent;
    }
}

